/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.table.TableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public DefaultTableCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(object);
        return this;
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }
}

