/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTable;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.TableColumnModelEvent;
import com.sun.java.swing.event.TableColumnModelListener;
import com.sun.java.swing.plaf.TableHeaderUI;
import com.sun.java.swing.table.DefaultTableColumnModel;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    protected JTable table;
    protected TableColumnModel columnModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
        }
        this.setColumnModel(tableColumnModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setResizingAllowed(boolean bl) {
        this.resizingAllowed = bl;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setUpdateTableInRealTime(boolean bl) {
        this.updateTableInRealTime = bl;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public Rectangle getHeaderRect(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (n < 0 || n >= tableColumnModel.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (n3 == n) {
                return new Rectangle(n2, 0, tableColumn.getWidth() + n4, this.getSize().height);
            }
            n2 += tableColumn.getWidth() + n4;
            ++n3;
        }
        return new Rectangle();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TableColumn tableColumn;
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnModel.getColumnIndexAtX(point.x);
        if (n != -1 && (component = (tableCellRenderer = (tableColumn = this.columnModel.getColumn(n)).getHeaderRenderer()).getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n)) instanceof JComponent) {
            Rectangle rectangle = this.getHeaderRect(n);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
        if (this.ui != tableHeaderUI) {
            super.setUI(tableHeaderUI);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        return "TableHeaderUI";
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public boolean isOpaque() {
        return true;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected void initializeLocalVars() {
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.resizingColumn = null;
        this.updateTableInRealTime = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setDraggedColumn(TableColumn tableColumn) {
        this.draggedColumn = tableColumn;
    }

    public void setDraggedDistance(int n) {
        this.draggedDistance = n;
    }

    public void setResizingColumn(TableColumn tableColumn) {
        this.resizingColumn = tableColumn;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTableHeader();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTableHeader.this.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
                return new AccessibleJTableHeaderEntry(this, n, JTableHeader.this, JTableHeader.this.table);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTableHeader.this.columnModel.getColumnCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
            return new AccessibleJTableHeaderEntry(this, n, JTableHeader.this, JTableHeader.this.table);
        }

        AccessibleJTableHeader() {
            super(JTableHeader.this);
            JTableHeader.this = JTableHeader.this;
        }

        static /* synthetic */ JTableHeader access$0(AccessibleJTableHeader accessibleJTableHeader) {
            return accessibleJTableHeader.JTableHeader.this;
        }
    }
}

