/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.daemons;

import java.util.Enumeration;
import java.util.Hashtable;
import stardiv.daemons.sadmind.Daemon;
import stardiv.daemons.sadmind.Property;
import stardiv.daemons.sadmind.TypeOfProperty;
import stardiv.daemons.sadmind.XDaemonController;
import stardiv.daemons.sadmind.XDaemonManager;

class DaemonModel {
    protected Hashtable m_daemons;
    protected Hashtable m_controllers;
    protected Hashtable m_properties;
    protected Hashtable m_observerIds;
    protected XDaemonManager m_daemonManager;

    public DaemonModel(XDaemonManager xDaemonManager) {
        this.m_daemonManager = xDaemonManager;
        this.m_properties = new Hashtable(10, 1.0f);
    }

    public Daemon[] getAllDaemons() {
        Daemon[] daemonArray = null;
        if (this.m_daemons != null) {
            int n = this.m_daemons.size();
            daemonArray = new Daemon[n];
            Enumeration enumeration = this.m_daemons.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                daemonArray[n2] = (Daemon)enumeration.nextElement();
                ++n2;
            }
        } else {
            this.m_daemons = new Hashtable(10, 1.0f);
            Daemon[] daemonArray2 = this.m_daemonManager.getSequenceOfDaemons();
            int n = 0;
            while (n < daemonArray2.length) {
                this.m_daemons.put(daemonArray2[n].sUniqueID, daemonArray2[n]);
                ++n;
            }
            daemonArray = this.getAllDaemons();
        }
        return daemonArray;
    }

    public String[] getDaemonNames() {
        String[] stringArray = null;
        Daemon[] daemonArray = this.getAllDaemons();
        int n = daemonArray.length;
        stringArray = new String[n];
        if (daemonArray != null) {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(daemonArray[n2].sNameOfDaemon);
                ++n2;
            }
        }
        return stringArray;
    }

    public String[] getDaemonIds() {
        String[] stringArray = null;
        Daemon[] daemonArray = this.getAllDaemons();
        int n = daemonArray.length;
        stringArray = new String[n];
        if (daemonArray != null) {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(daemonArray[n2].sUniqueID);
                ++n2;
            }
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = null;
        Property[] propertyArray = this.getProperties(string);
        int n = propertyArray.length;
        stringArray = new String[n];
        if (propertyArray != null) {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(propertyArray[n2].sName);
                ++n2;
            }
        }
        return stringArray;
    }

    public String[] getPropertyValues(String string) {
        String[] stringArray = null;
        Property[] propertyArray = this.getProperties(string);
        int n = propertyArray.length;
        stringArray = new String[n];
        if (propertyArray != null) {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(propertyArray[n2].sValue);
                ++n2;
            }
        }
        return stringArray;
    }

    public TypeOfProperty[] getPropertyTypes(String string) {
        TypeOfProperty[] typeOfPropertyArray = null;
        Property[] propertyArray = this.getProperties(string);
        int n = propertyArray.length;
        typeOfPropertyArray = new TypeOfProperty[n];
        if (propertyArray != null) {
            int n2 = 0;
            while (n2 < n) {
                typeOfPropertyArray[n2] = propertyArray[n2].eType;
                ++n2;
            }
        }
        return typeOfPropertyArray;
    }

    public int getObserverId(String string) {
        Integer n = (Integer)this.m_observerIds.get(string);
        return n;
    }

    Hashtable getObserverIds() {
        if (this.m_observerIds != null) {
            return this.m_observerIds;
        }
        this.m_observerIds = new Hashtable(10, 1.0f);
        return this.m_observerIds;
    }

    public void putObserverId(String string, int n) {
        this.getObserverIds().put(string, new Integer(n));
    }

    protected XDaemonController getController(String string) {
        XDaemonController xDaemonController = null;
        if (this.m_controllers != null) {
            xDaemonController = (XDaemonController)this.m_controllers.get(string);
            if (xDaemonController == null) {
                XDaemonController xDaemonController2 = this.m_daemonManager.createDaemonController(string);
                if (xDaemonController2 != null) {
                    this.m_controllers.put(string, xDaemonController2);
                }
                xDaemonController = xDaemonController2;
            }
        } else {
            this.m_controllers = new Hashtable(10, 1.0f);
            xDaemonController = this.getController(string);
        }
        return xDaemonController;
    }

    public Property[] getProperties(String string) {
        XDaemonController xDaemonController = this.getController(string);
        Property[] propertyArray = null;
        propertyArray = xDaemonController.getProperties();
        return propertyArray;
    }

    public boolean updateProperties(String string, Property[] propertyArray) {
        boolean bl = false;
        Property[] propertyArray2 = null;
        if (this.m_properties != null) {
            propertyArray2 = (Property[])this.m_properties.remove(string);
            if (propertyArray != null) {
                int n = propertyArray2.length;
                int n2 = propertyArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < n && !bl2) {
                        if (propertyArray2[n4].sName.equals(propertyArray[n3].sName)) {
                            propertyArray2[n4].sValue = propertyArray[n3].sValue;
                            bl2 = true;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                this.m_properties.put(string, propertyArray2);
            }
            bl = propertyArray2 != null;
        } else {
            this.m_properties = new Hashtable(10, 1.0f);
            bl = this.updateProperties(string, propertyArray);
        }
        return bl;
    }
}

