/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.daemons;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import stardiv.admin.daemons.DaemonModel;
import stardiv.admin.daemons.DaemonView;
import stardiv.admin.daemons.IDaemonController;
import stardiv.daemons.sadmind.Daemon;
import stardiv.daemons.sadmind.StatusOfDaemon;
import stardiv.daemons.sadmind.XDaemonController;

public class DaemonView
extends Panel {
    protected List m_daemonList;
    protected IDaemonController m_controller;
    protected ButtonPanel m_buttonPanel;
    protected DaemonModel m_daemonModel;
    protected Daemon[] m_daemonArray;

    public DaemonView(IDaemonController iDaemonController, DaemonModel daemonModel) {
        this.m_controller = iDaemonController;
        this.m_daemonModel = daemonModel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 20;
        this.m_daemonList = new List();
        this.add((Component)this.m_daemonList, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.m_buttonPanel = new ButtonPanel(this.m_controller);
        this.updateList();
    }

    public void updateList() {
        this.m_daemonArray = this.m_daemonModel.getAllDaemons();
        int n = this.m_daemonArray.length;
        this.m_daemonList.removeAll();
        int n2 = 0;
        while (n2 < n) {
            XDaemonController xDaemonController = this.m_daemonModel.getController(this.m_daemonArray[n2].sUniqueID);
            StatusOfDaemon statusOfDaemon = null;
            if (xDaemonController != null) {
                statusOfDaemon = xDaemonController.getStatusOfDaemon();
            }
            String string = this.statusToString(statusOfDaemon);
            this.m_daemonList.addItem(String.valueOf(this.m_daemonArray[n2].sNameOfDaemon) + " (" + string + ")");
            ++n2;
        }
    }

    protected String statusToString(StatusOfDaemon statusOfDaemon) {
        String string = null;
        string = statusOfDaemon == StatusOfDaemon.STARTING ? "starting" : (statusOfDaemon == StatusOfDaemon.RUNNING ? "running" : (statusOfDaemon == StatusOfDaemon.PAUSED ? "paused" : (statusOfDaemon == StatusOfDaemon.STOPPING ? "stopping" : (statusOfDaemon == StatusOfDaemon.STOPPED ? "stopped" : "unknown"))));
        return string;
    }

    protected void update(int n) {
        this.updateList();
    }

    public String getSelectedDaemonId() {
        String string = null;
        int n = this.m_daemonList.getSelectedIndex();
        string = n != -1 ? this.m_daemonArray[n].sUniqueID : "";
        return string;
    }

    class ButtonPanel
    extends Panel {
        protected Button m_startBtn;
        protected Button m_stopBtn;
        protected Button m_pauseBtn;
        protected Button m_restartBtn;
        protected IDaemonController m_controller;

        ButtonPanel(IDaemonController iDaemonController) {
            DaemonView.this = DaemonView.this;
            this.m_controller = iDaemonController;
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.m_startBtn = new Button("Start");
            this.add((Component)this.m_startBtn, gridBagConstraints);
            this.m_startBtn.addActionListener(new 1(this));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            this.m_stopBtn = new Button("Stop");
            this.add((Component)this.m_stopBtn, gridBagConstraints);
            this.m_stopBtn.addActionListener(new 2(this));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            this.m_pauseBtn = new Button("Pause");
            this.add((Component)this.m_pauseBtn, gridBagConstraints);
            this.m_pauseBtn.addActionListener(new 3(this));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.m_restartBtn = new Button("Restart");
            this.add((Component)this.m_restartBtn, gridBagConstraints);
            this.m_restartBtn.addActionListener(new 4(this));
        }

        static /* synthetic */ DaemonView access$0(ButtonPanel buttonPanel) {
            return buttonPanel.DaemonView.this;
        }
    }
}

