/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.daemons;

import java.applet.Applet;
import stardiv.admin.daemons.DaemonModel;
import stardiv.admin.daemons.IDaemonController;
import stardiv.connect.AdminDaemonConnection;
import stardiv.connect.ConnectionEvent;
import stardiv.connect.IConnectionListener;
import stardiv.daemons.sadmind.Daemon;
import stardiv.daemons.sadmind.OResultOfVerificationHolder;
import stardiv.daemons.sadmind.Property;
import stardiv.daemons.sadmind.ResultOfVerification;
import stardiv.daemons.sadmind.TypeOfProperty;
import stardiv.daemons.sadmind.XDaemonController;
import stardiv.daemons.sadmind.XDaemonManager;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.sys.marshal.ODecodeException;

public class Sdadmin
extends Applet
implements IConnectionListener,
IDaemonController {
    protected AdminDaemonConnection m_connection;
    protected XDaemonManager m_daemonManager;
    protected DaemonModel m_daemonModel;
    protected String m_sUser = "";
    protected String m_sPass = "";
    protected String m_sHost = "";
    protected String m_sPort = "";
    protected String m_sLastError = "";
    protected short m_lastError = (short)999;

    public void init() {
        super.init();
        this.m_sHost = this.getCodeBase().getHost();
        if (this.m_sHost.equals("")) {
            this.m_sHost = "127.0.0.1";
        }
        System.err.println("Sdadmin: loaded from host " + this.m_sHost);
    }

    public String getUser() {
        this.resetError();
        return this.m_sUser;
    }

    public String getPassword() {
        this.resetError();
        return this.m_sPass;
    }

    public String getPort() {
        this.resetError();
        return this.m_sPort;
    }

    public String getHost() {
        this.resetError();
        return this.m_sHost;
    }

    public void setHost(String string) {
        this.resetError();
        this.m_sHost = string;
    }

    public void setUser(String string) {
        this.resetError();
        this.m_sUser = string;
    }

    public void setPassword(String string) {
        this.resetError();
        this.m_sPass = string;
    }

    public void setPort(String string) {
        this.resetError();
        this.m_sPort = string;
    }

    public short getLastError() {
        return this.m_lastError;
    }

    public void connectAndLogin(String string, String string2, String string3) {
        System.out.println("Sdamin: connectAndLogin(): " + string + "," + string3);
        try {
            boolean bl = false;
            this.resetError();
            bl = this.getConnection().connectAndLogin(string, string2, string3);
            if (this.getConnection().isConnected()) {
                this.getConnection().addConnectionListener(this);
                return;
            }
            this.appendError("connectAndLogin: " + this.getConnection().getLastErrorString());
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("connectAndLogin: caught OUnoSystemException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.appendError("connectAndLogin: caught NullPointerException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
    }

    public void changePassword(String string, String string2, String string3, String string4) {
        System.out.println("Sdamin: trying to change password");
        try {
            boolean bl = false;
            this.resetError();
            bl = this.getConnection().changePassword(string, string2, string3, string4);
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("connectAndLogin: caught OUnoSystemException ");
            this.appendError("user: " + string2);
            this.appendError("host: " + string);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.appendError("connectAndLogin: caught NullPointerException ");
            this.appendError("user: " + string2);
            this.appendError("host: " + string);
            return;
        }
    }

    protected AdminDaemonConnection getConnection() {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = new AdminDaemonConnection();
        return this.m_connection;
    }

    protected XDaemonManager getDaemonManager() {
        if (this.m_daemonManager != null) {
            return this.m_daemonManager;
        }
        this.m_daemonManager = this.getConnection().getDaemonManager();
        return this.m_daemonManager;
    }

    protected DaemonModel getDaemonModel() {
        if (this.m_daemonModel != null) {
            return this.m_daemonModel;
        }
        this.m_daemonModel = new DaemonModel(this.getDaemonManager());
        return this.m_daemonModel;
    }

    public String[] getDaemonNames() {
        return this.getDaemonModel().getDaemonNames();
    }

    public String[] getDaemonIds() {
        return this.getDaemonModel().getDaemonIds();
    }

    public String[] getPropertyNames(String string) {
        return this.getDaemonModel().getPropertyNames(string);
    }

    public String[] getPropertyValues(String string) {
        return this.getDaemonModel().getPropertyValues(string);
    }

    public String[] getPropertyTypes(String string) {
        String[] stringArray = null;
        TypeOfProperty[] typeOfPropertyArray = this.getDaemonModel().getPropertyTypes(string);
        int n = typeOfPropertyArray.length;
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = typeOfPropertyArray[n2] == TypeOfProperty.TYPE_BOOLEAN ? "boolean" : (typeOfPropertyArray[n2] == TypeOfProperty.TYPE_ULONG ? "ulong" : (typeOfPropertyArray[n2] == TypeOfProperty.TYPE_STRING ? "string" : "unknown"));
            ++n2;
        }
        return stringArray;
    }

    protected Daemon[] getAllDaemons() {
        return this.getDaemonModel().getAllDaemons();
    }

    protected Property[] getProperties(String string) {
        Property[] propertyArray = null;
        XDaemonController xDaemonController = this.getDaemonModel().getController(string);
        try {
            propertyArray = xDaemonController.getProperties();
        }
        catch (ODecodeException oDecodeException) {
            System.out.println("Sdadmin: getProperies(): Caught ODecodeException");
            xDaemonController = this.getConnection().getDaemonManager().createDaemonController(string);
            propertyArray = xDaemonController.getProperties();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Sdadmin: getProperies(): Caught NullPointerExeption");
            xDaemonController = this.getConnection().getDaemonManager().createDaemonController(string);
            propertyArray = xDaemonController.getProperties();
        }
        return propertyArray;
    }

    public String getPropertyValue(String string, String string2) {
        Property[] propertyArray = null;
        String string3 = null;
        this.resetError();
        System.out.println("Getting property: " + string + ", " + string2);
        try {
            propertyArray = this.getProperties(string);
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("getPropertyValue: caught OUnoSystemException");
            this.appendError("daemonId: " + string);
            this.appendError("property name: " + string2);
            return "";
        }
        if (propertyArray != null) {
            int n = propertyArray.length;
            boolean bl = false;
            string2 = string2.toLowerCase();
            int n2 = 0;
            while (n2 < n && !bl) {
                String string4 = propertyArray[n2].sName.toLowerCase();
                if (string4.equals(string2)) {
                    bl = true;
                    string3 = propertyArray[n2].sValue;
                }
                ++n2;
            }
        }
        this.m_lastError = 0;
        System.out.println("Got property value: " + string3);
        if (string3 == null) {
            this.appendError("getPropertyValue: Could not get value of property " + string2 + " from daemon " + string);
            string3 = "";
        }
        return string3;
    }

    protected Property createProperty(String string, String string2, String string3) {
        Property property = null;
        TypeOfProperty typeOfProperty = null;
        if (string.equals("string")) {
            typeOfProperty = TypeOfProperty.TYPE_STRING;
        } else if (string.equals("ulong")) {
            typeOfProperty = TypeOfProperty.TYPE_ULONG;
        } else if (string.equals("boolean")) {
            typeOfProperty = TypeOfProperty.TYPE_BOOLEAN;
        } else {
            this.appendError("createProperty: unknown type " + string);
        }
        property = new Property(string2, typeOfProperty, string3);
        return property;
    }

    public boolean verifyProperty(String string, short s, String string2, String string3, String string4) {
        this.resetError();
        boolean bl = false;
        Property property = this.createProperty(string2, string3, string4);
        try {
            bl = this.verifyProperty(string, s, property);
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("verifyProperty: caught OUnoSystemException");
            this.appendError("daemonId: " + string);
            this.appendError("type: " + string2);
            this.appendError("name: " + string3);
            this.appendError("value: " + string4);
            return false;
        }
        if (!bl) {
            this.appendError("verifyProperty (" + string + "," + string2 + "," + string3 + "," + string4 + ") returned false");
        }
        return bl;
    }

    protected boolean verifyProperty(String string, short s, Property property) {
        boolean bl = false;
        OResultOfVerificationHolder oResultOfVerificationHolder = new OResultOfVerificationHolder();
        ResultOfVerification resultOfVerification = null;
        System.out.println("Verifing property: " + string + "," + s + "," + property.sName + "," + property.sValue);
        XDaemonController xDaemonController = this.getDaemonModel().getController(string);
        if (xDaemonController != null) {
            bl = xDaemonController.propertyIsValid(s, property, oResultOfVerificationHolder);
        } else {
            this.appendError("verifyProperty: XDaemonController for " + string + " is null");
        }
        resultOfVerification = oResultOfVerificationHolder.getValue();
        this.m_lastError = resultOfVerification.nErrorCode;
        return bl;
    }

    public boolean verifyProperties(String string, Property[] propertyArray) {
        boolean bl = true;
        short s = 0;
        while (s < propertyArray.length && bl) {
            bl = this.verifyProperty(string, s, propertyArray[s]);
            s = (short)(s + 1);
        }
        return bl;
    }

    public boolean setProperty(String string, String string2, String string3, String string4) {
        boolean bl = false;
        Property property = this.createProperty(string2, string3, string4);
        Property[] propertyArray = new Property[]{property};
        try {
            bl = this.setProperties(string, propertyArray);
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("setProperty: caught OUnoSystemException");
            this.appendError("daemonId: " + string);
            this.appendError("name: " + string3);
            this.appendError("value: " + string4);
            return false;
        }
        return bl;
    }

    public boolean setProperties(String string, Property[] propertyArray) {
        boolean bl = true;
        System.out.print("Setting Properties for Id: " + string);
        int n = 0;
        while (n < propertyArray.length) {
            System.out.print("Name: " + propertyArray[n].sName);
            System.out.println(", Value: " + propertyArray[n].sValue);
            ++n;
        }
        XDaemonController xDaemonController = this.getDaemonModel().getController(string);
        if (xDaemonController != null) {
            xDaemonController.setProperties(propertyArray);
        } else {
            bl = false;
            this.appendError("setProperties: XDaemonController is null");
        }
        if (bl) {
            this.m_lastError = 0;
        }
        return bl;
    }

    public void startDaemon(String string) {
        this.getDaemonModel().getController(string).startDaemon();
    }

    public void stopDaemon(String string) {
        this.getDaemonModel().getController(string).stopDaemon();
    }

    public void pauseDaemon(String string) {
        this.getDaemonModel().getController(string).pauseDaemon();
    }

    public void restartDaemon(String string) {
        this.getDaemonModel().getController(string).restartDaemon();
    }

    protected void appendError(String string) {
        this.m_sLastError = String.valueOf(this.m_sLastError) + "Sdadmin: " + string + "\n";
    }

    public void resetError() {
        this.m_sLastError = "";
    }

    public String getLastErrorString() {
        return this.m_sLastError;
    }

    public void connectionStatus(ConnectionEvent connectionEvent) {
        System.out.println("AdminDaemonConnection closed.");
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {}
        System.out.println("Sdamin finalized");
    }
}

