/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.daemons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import stardiv.admin.daemons.DaemonView;
import stardiv.admin.daemons.Sdadmin;
import stardiv.daemons.sadmind.Daemon;
import stardiv.daemons.sadmind.XDaemonController;
import stardiv.daemons.sadmind.XObserver;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;

public class Sdcontroller
extends Sdadmin
implements XObserver {
    protected DaemonView m_controllerView;

    public XInterface queryInterface(Uik uik) {
        if (uik.isEqual(XObserver.UIK) || uik.isEqual(XInterface.UIK)) {
            return this;
        }
        return null;
    }

    public void acquire() {
    }

    public void release() {
    }

    public void init() {
        super.init();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
    }

    public void connectAndLogin(String string, String string2, String string3) {
        System.out.println("Sdcontroller: connectAndLogin called");
        boolean bl = false;
        try {
            bl = this.getConnection().connectAndLogin(string, string2, string3);
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("connectAndLogin: caught OUnoSystemException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
        }
        catch (NullPointerException nullPointerException) {
            this.appendError("connectAndLogin: caught NullPointerException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
        }
        if (this.getConnection().isConnected()) {
            this.getConnection().addConnectionListener(this);
        } else {
            this.m_connection = null;
        }
        if (bl) {
            this.initView();
            this.registerObservers();
        }
    }

    protected void initView() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.removeAll();
        this.invalidate();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        this.m_controllerView = new DaemonView(this, this.getDaemonModel());
        this.add((Component)this.m_controllerView, gridBagConstraints);
        this.m_controllerView.invalidate();
        this.m_controllerView.doLayout();
        this.invalidate();
        this.doLayout();
        this.validate();
    }

    protected void registerObservers() {
        Daemon[] daemonArray = this.getDaemonModel().getAllDaemons();
        int n = daemonArray.length;
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            n2 = this.getDaemonModel().getController(daemonArray[n3].sUniqueID).addObserver(this);
            this.m_daemonModel.putObserverId(daemonArray[n3].sUniqueID, n2);
            ++n3;
        }
    }

    protected void removeObservers() {
        Daemon[] daemonArray = this.getDaemonModel().getAllDaemons();
        int n = daemonArray.length;
        int n2 = 1;
        while (n2 < n) {
            XDaemonController xDaemonController = this.getDaemonModel().getController(daemonArray[n2].sUniqueID);
            int n3 = this.m_daemonModel.getObserverId(daemonArray[n2].sUniqueID);
            xDaemonController.removeObserver(n3);
            ++n2;
        }
    }

    public void destroy() {
        if (this.m_connection != null) {
            this.removeObservers();
            this.m_connection.disconnect();
        }
    }

    public void update(int n) {
        this.m_controllerView.update(n);
    }

    public void startDaemon() {
        try {
            String string = this.m_controllerView.getSelectedDaemonId();
            this.getDaemonModel().getController(string).startDaemon();
            this.m_controllerView.updateList();
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("startDaemon: caught OUnoSystemException ");
            return;
        }
    }

    public void stopDaemon() {
        try {
            String string = this.m_controllerView.getSelectedDaemonId();
            this.getDaemonModel().getController(string).stopDaemon();
            this.m_controllerView.updateList();
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("stopDaemon: caught OUnoSystemException ");
            return;
        }
    }

    public void pauseDaemon() {
        try {
            String string = this.m_controllerView.getSelectedDaemonId();
            this.getDaemonModel().getController(string).pauseDaemon();
            this.m_controllerView.updateList();
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("pauseDaemon: caught OUnoSystemException ");
            return;
        }
    }

    public void restartDaemon() {
        try {
            String string = this.m_controllerView.getSelectedDaemonId();
            this.getDaemonModel().getController(string).restartDaemon();
            this.m_controllerView.updateList();
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("restartDaemon: caught OUnoSystemException ");
            return;
        }
    }

    public void finalize() {
        System.out.println("Sdcontroller.finalize() called");
    }
}

