/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usermon;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import stardiv.admin.usermon.TableUserView;
import stardiv.admin.usermon.UserController;
import stardiv.admin.usermon.UserModel;
import stardiv.connect.ConnectionEvent;
import stardiv.connect.IConnectionListener;
import stardiv.connect.MonitorConnection;
import stardiv.daemons.sofficed.AdminType;
import stardiv.daemons.sofficed.OUserHolder;
import stardiv.daemons.sofficed.User;
import stardiv.daemons.sofficed.XMonitor;
import stardiv.daemons.sofficed.XObserver;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;
import stardiv.util.Cryptor;
import stardiv.util.ILoginPanelListener;
import stardiv.util.LoginPanel;

public class SOUserMonitor
extends JApplet
implements XObserver,
ILoginPanelListener,
IConnectionListener {
    protected MonitorConnection m_connection;
    protected UserModel m_userModel;
    protected TableUserView m_userView;
    protected UserController m_userController;
    protected XMonitor m_daemonMonitor;
    protected int m_myObserverId;
    protected LoginPanel m_loginPanel;
    protected boolean m_isApplet = true;
    protected Timer m_updateTimer;
    protected String m_sLastError = "";
    public static final boolean DEBUG = false;

    public XInterface queryInterface(Uik uik) {
        if (uik.isEqual(XObserver.UIK) || uik.isEqual(XInterface.UIK)) {
            return this;
        }
        return null;
    }

    public void acquire() {
    }

    public void release() {
    }

    public void killSelectedUser() {
        this.resetError();
        try {
            this.m_userController.killSelectedUser();
            return;
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("killSelectedUser(): caught OUnoSystemException ");
            return;
        }
    }

    protected void initViewAndController(UserModel userModel, XMonitor xMonitor) {
        this.m_userController = new UserController(userModel, xMonitor);
        this.m_userView = new TableUserView(userModel);
        userModel.addObserver(this.m_userView);
        this.m_updateTimer = new Timer(5000, new TimerAdapter());
        this.m_updateTimer.start();
    }

    public void init() {
        super.init();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        this.getContentPane().add((Component)new Label("Loading, please wait ..."), gridBagConstraints);
    }

    protected void showLoginPanel() {
        this.m_loginPanel = new LoginPanel(this);
        this.m_loginPanel.setUser("root");
        this.m_loginPanel.setHost(this.getHost());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_loginPanel, "West");
        this.getContentPane().validate();
    }

    protected boolean initConnection(String string, String string2, String string3) {
        boolean bl = false;
        this.m_connection = new MonitorConnection();
        this.m_connection.connect(string3);
        this.m_connection.addConnectionListener(this);
        if (!this.m_connection.isConnected()) {
            this.getContentPane().removeAll();
            this.getContentPane().invalidate();
            this.getContentPane().validate();
            this.appendError("initConnection(): Could not connect to daemon on host " + string3);
        } else {
            AdminType adminType = AdminType.UNAUTHORIZED;
            Cryptor cryptor = new Cryptor();
            cryptor.encryptString(string2, "@2 3\u00a7#e'rt^*");
            adminType = this.m_connection.login(string, cryptor.getResult());
            if (adminType != AdminType.UNAUTHORIZED) {
                this.m_daemonMonitor = this.m_connection.getMonitor();
                if (this.m_daemonMonitor != null) {
                    bl = true;
                }
            } else {
                this.appendError("initConnection(): Could not login user " + string);
                this.m_connection.disconnect();
                this.m_connection = null;
            }
        }
        return bl;
    }

    protected String getHost() {
        String string = "";
        if (this.m_isApplet) {
            URL uRL = this.getCodeBase();
            string = uRL.getHost();
        }
        if (string.equals("")) {
            string = "127.0.0.1";
        }
        return string;
    }

    public void connectAndLogin(String string, String string2, String string3) {
        this.resetError();
        System.out.println("connectAndLogin: " + string + "," + string3);
        try {
            boolean bl = this.initConnection(string, string2, string3);
            if (bl) {
                this.initUserModel();
                this.initViewAndController(this.m_userModel, this.m_daemonMonitor);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().removeAll();
                this.getContentPane().add((Component)this.m_userView.getView(), "Center");
                this.getContentPane().validate();
                this.getContentPane().repaint();
                this.invalidate();
                this.doLayout();
                this.validate();
                return;
            }
        }
        catch (OUnoSystemException oUnoSystemException) {
            this.appendError("showUserMonitor: caught OUnoSystemException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.appendError("connectAndLogin: caught NullPointerException ");
            this.appendError("user: " + string);
            this.appendError("host: " + string3);
            return;
        }
    }

    public void initUserModel() {
        User[] userArray = this.m_daemonMonitor.getSeqOfUsers();
        this.m_userModel = new UserModel();
        if (userArray != null) {
            this.m_userModel.addUsers(userArray);
        }
        this.m_myObserverId = this.m_connection.getMonitor().addObserver(this);
    }

    public void updateUserModel() {
        User[] userArray = null;
        userArray = this.m_userModel.getAllUsers();
        int n = 0;
        while (n < userArray.length) {
            OUserHolder oUserHolder = new OUserHolder();
            oUserHolder.value = userArray[n];
            this.m_daemonMonitor.forceUpdate(oUserHolder);
            this.m_userView.userChanged(userArray[n]);
            ++n;
        }
    }

    public void exit() {
        if (this.m_connection != null) {
            this.m_connection.getMonitor().removeObserver(this.m_myObserverId);
            this.m_connection.disconnect();
            this.m_userModel.removeObserver(this.m_userView);
        }
        System.exit(0);
    }

    private void showInFrame() {
        JFrame jFrame = new JFrame("SOUserMonitor");
        jFrame.addWindowListener(new 1());
        jFrame.getContentPane().add("Center", this);
        jFrame.pack();
        ((Component)jFrame).setSize(new Dimension(485, 200));
        ((Component)jFrame).setVisible(true);
    }

    public void userLoggedIn(User user) {
        this.m_userModel.addUser(user);
    }

    public void userLoggedOut(int n) {
        this.m_userModel.removeUser(n);
    }

    public void loginAction() {
        this.connectAndLogin(this.m_loginPanel.getUser(), this.m_loginPanel.getPassword(), this.m_loginPanel.getHost());
    }

    public void connectionStatus(ConnectionEvent connectionEvent) {
        System.out.println("MonitorConnection is disconnected.");
    }

    protected void appendError(String string) {
        this.m_sLastError = String.valueOf(this.m_sLastError) + "SOUserMonitor: " + string + "\n";
    }

    public void resetError() {
        this.m_sLastError = "";
    }

    public String getLastErrorString() {
        return this.m_sLastError;
    }

    public static void main(String[] stringArray) {
        SOUserMonitor sOUserMonitor = new SOUserMonitor();
        sOUserMonitor.m_isApplet = false;
        sOUserMonitor.init();
        sOUserMonitor.start();
        sOUserMonitor.showInFrame();
    }

    class TestMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            SOUserMonitor.this.m_userController.killSelectedUser();
        }

        TestMouseAdapter() {
            SOUserMonitor.this = SOUserMonitor.this;
        }
    }

    class TimerAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SOUserMonitor.this.updateUserModel();
        }

        TimerAdapter() {
            SOUserMonitor.this = SOUserMonitor.this;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            SOUserMonitor.this.exit();
        }

        /* synthetic */ 1() {
        }
    }
}

