/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usermon;

import com.sun.java.swing.table.AbstractTableModel;
import java.util.Date;
import stardiv.admin.usermon.UserModel;

class TableUserViewModel
extends AbstractTableModel {
    protected UserModel m_users;
    protected String[] m_columnNames = new String[]{"User", "Workstation", "Connected since", "CPU", "Heapsize"};

    TableUserViewModel(UserModel userModel) {
        this.m_users = userModel;
    }

    public synchronized int getColumnCount() {
        return this.m_columnNames.length;
    }

    public synchronized int getRowCount() {
        return this.m_users.getNoOfUsers();
    }

    public synchronized Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.m_users.getUserByIndex((int)n).sNameOfUser;
                }
                case 1: {
                    return this.m_users.getUserByIndex((int)n).sNameOfWorkstation;
                }
                case 2: {
                    return new Date(Long.parseLong(this.m_users.getUserByIndex((int)n).sTimeOfLogin) * 1000L);
                }
                case 3: {
                    return new String(this.getCPUTime(n));
                }
                case 4: {
                    return new Integer(this.m_users.getUserByIndex((int)n).lMemory / 1024);
                }
                case 5: {
                    return new Integer(this.m_users.getUserByIndex((int)n).uniqueID);
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: TableUserViewModel: sadmind returned strange user data (NumberFormatException)");
            return "";
        }
    }

    public synchronized String getColumnName(int n) {
        return this.m_columnNames[n];
    }

    public synchronized boolean isCellEditable(int n, int n2) {
        return false;
    }

    protected synchronized String getCPUTime(int n) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n2 = this.m_users.getUserByIndex((int)n).lSystemCPU;
        int n3 = this.m_users.getUserByIndex((int)n).lProcessCPU;
        int n4 = n2 + n3;
        string4 = new Integer(n4 % 1000).toString();
        string2 = new Integer((n4 /= 1000) % 60).toString();
        string3 = new Integer((n4 /= 60) % 60).toString();
        string = new Integer(n4 /= 60).toString();
        if (string.length() < 2) {
            string = String.valueOf('0') + string;
        }
        if (string3.length() < 2) {
            string3 = String.valueOf('0') + string3;
        }
        if (string2.length() < 2) {
            string2 = String.valueOf('0') + string2;
        }
        string5 = String.valueOf(string) + ":" + string3 + ":" + string2;
        return string5;
    }
}

