/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usermon;

import java.util.Enumeration;
import java.util.Vector;
import stardiv.admin.usermon.IUserObserver;
import stardiv.daemons.sofficed.User;

class UserModel {
    protected Vector m_users = new Vector(10, 5);
    protected Vector m_userObservers = new Vector(5, 5);
    protected User m_selectedUser;

    protected synchronized User cloneUser(User user) {
        User user2 = new User(user.uniqueID, user.sNameOfUser, user.sNameOfWorkstation, user.sTimeOfLogin, user.lProcessCPU, user.lSystemCPU, user.lMemory);
        return user2;
    }

    public synchronized void addUsers(User[] userArray) {
        int n = 0;
        while (n < userArray.length) {
            this.addUser(userArray[n]);
            ++n;
        }
    }

    public synchronized boolean addUser(User user) {
        boolean bl = false;
        if (this.hasUniqueId(user)) {
            User user2 = this.cloneUser(user);
            this.m_users.addElement(user2);
            if (this.m_userObservers != null) {
                Enumeration enumeration = this.m_userObservers.elements();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                    iUserObserver.userAdded(user);
                    ++n;
                }
            }
            bl = true;
        }
        return bl;
    }

    public synchronized boolean removeUser(int n) {
        boolean bl = false;
        int n2 = this.getIndexById(n);
        if (n2 < 0) {
            bl = false;
        } else {
            this.m_users.removeElementAt(n2);
            this.m_users.trimToSize();
            if (this.m_userObservers != null) {
                Enumeration enumeration = this.m_userObservers.elements();
                int n3 = 0;
                while (enumeration.hasMoreElements()) {
                    IUserObserver iUserObserver = (IUserObserver)enumeration.nextElement();
                    iUserObserver.userRemoved(n);
                    ++n3;
                }
            }
            bl = true;
        }
        return bl;
    }

    public synchronized void removeAllUsers() {
        Enumeration enumeration = this.m_users.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            this.removeUser(user.uniqueID);
            ++n;
        }
    }

    public synchronized void addObserver(IUserObserver iUserObserver) {
        this.m_userObservers.addElement(iUserObserver);
    }

    public synchronized boolean removeObserver(IUserObserver iUserObserver) {
        boolean bl = false;
        bl = this.m_userObservers.removeElement(iUserObserver);
        return bl;
    }

    public synchronized User[] getAllUsers() {
        Enumeration enumeration = this.m_users.elements();
        User[] userArray = new User[this.m_users.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            User user;
            userArray[n] = user = (User)enumeration.nextElement();
            ++n;
        }
        return userArray;
    }

    public synchronized User getUserById(int n) {
        int n2 = this.getNoOfUsers();
        int n3 = 0;
        while (n3 < n2) {
            if (((User)this.m_users.elementAt((int)n3)).uniqueID == n) {
                return (User)this.m_users.elementAt(n3);
            }
            ++n3;
        }
        return null;
    }

    public synchronized User getUserByIndex(int n) {
        return (User)this.m_users.elementAt(n);
    }

    public synchronized int getIndexById(int n) {
        int n2 = this.getNoOfUsers();
        int n3 = 0;
        while (n3 < n2) {
            if (((User)this.m_users.elementAt((int)n3)).uniqueID == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public synchronized int getNoOfUsers() {
        return this.m_users.size();
    }

    public synchronized void setSelectedUser(User user) {
        this.m_selectedUser = user;
    }

    public synchronized User getSelectedUser() {
        return this.m_selectedUser;
    }

    public synchronized boolean hasUniqueId(User user) {
        boolean bl = true;
        User user2 = null;
        Enumeration enumeration = this.m_users.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            user2 = (User)enumeration.nextElement();
            if (user2.uniqueID == user.uniqueID) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    UserModel() {
    }
}

