/*
 * Decompiled with CFR 0.152.
 */
package stardiv.admin.usersetup;

import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import stardiv.admin.usersetup.ExtUserConfiguration;
import stardiv.admin.usersetup.UserModel;
import stardiv.admin.usersetup.UserSetup;
import stardiv.daemons.sofficed.ResultOfInstallation;

public class UserController
implements ListSelectionListener {
    UserModel m_model;
    UserSetup m_installer;
    int m_firstSelectedRow = -1;
    int m_lastSelectedRow = -1;
    protected String m_sLastError = "";

    public UserController(UserModel userModel, UserSetup userSetup) {
        this.m_model = userModel;
        this.m_installer = userSetup;
    }

    public void addUser() {
        if (this.m_firstSelectedRow != -1) {
            this.m_model.addUser("", "", "", this.m_model.getProfile(this.m_firstSelectedRow), this.m_model.getLanguageId(this.m_firstSelectedRow));
            return;
        }
        this.m_model.addUser("");
    }

    public void addUser(String string) {
        this.m_model.addUser(string);
    }

    public void addFromFile() {
        System.out.println("addFromFile() called...");
    }

    public void removeUser(String string) {
        this.m_model.setRemoved(string, true);
    }

    public void removeUser() {
        String string = null;
        if (this.m_firstSelectedRow != -1) {
            if (this.m_model.isUserNew(this.m_firstSelectedRow)) {
                this.m_model.removeUserByIndex(this.m_firstSelectedRow);
                if (this.m_model.getNoOfUsers() <= this.m_firstSelectedRow) {
                    this.m_firstSelectedRow = -1;
                    return;
                }
            } else {
                string = this.m_model.getID(this.m_firstSelectedRow);
                if (string.equals("")) {
                    this.m_model.toggleRemovedByIndex(this.m_firstSelectedRow);
                    return;
                }
                this.m_model.toggleRemoved(string);
            }
        }
    }

    public String[] getUserIds() {
        ExtUserConfiguration[] extUserConfigurationArray = this.m_model.getUserConfigs();
        int n = extUserConfigurationArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = extUserConfigurationArray[n2].sUserID;
            ++n2;
        }
        return stringArray;
    }

    public boolean applyChanges() {
        boolean bl = true;
        this.resetError();
        if (!this.m_model.checkModel()) {
            this.appendError("checkModel() failed:" + this.m_model.getLastErrorString());
            return false;
        }
        int n = this.m_model.getNoOfUsers();
        int n2 = 0;
        while (n2 < n) {
            ExtUserConfiguration extUserConfiguration = this.m_model.getUserByIndex(n2);
            if (extUserConfiguration.isRemoved()) {
                System.out.println("Removing user:");
                System.out.println(String.valueOf(extUserConfiguration.sUserID) + "," + extUserConfiguration.sUserName + "," + extUserConfiguration.sOfficeDir + extUserConfiguration.sProfile + "," + extUserConfiguration.eLanguage);
                ResultOfInstallation resultOfInstallation = this.m_installer.getUserInstaller().removeUser(extUserConfiguration.sUserID);
                if (resultOfInstallation == ResultOfInstallation.OK) {
                    this.m_model.removeUser(extUserConfiguration);
                    this.resetError();
                } else {
                    this.appendError("Could not remove user '" + extUserConfiguration.sUserID + "'");
                }
                if (bl) {
                    bl = resultOfInstallation == ResultOfInstallation.OK;
                }
                n = this.m_model.getNoOfUsers();
                --n2;
                if (this.m_model.getNoOfUsers() <= this.m_firstSelectedRow) {
                    this.m_firstSelectedRow = -1;
                }
            } else if (extUserConfiguration.isNew()) {
                System.out.println("Installing user:");
                System.out.println(String.valueOf(extUserConfiguration.sUserID) + "," + extUserConfiguration.sUserName + "," + extUserConfiguration.sOfficeDir + extUserConfiguration.sProfile + "," + extUserConfiguration.eLanguage);
                boolean bl2 = false;
                ResultOfInstallation resultOfInstallation = this.m_installer.getUserInstaller().addUser(extUserConfiguration, bl2);
                if (bl) {
                    boolean bl3 = bl = resultOfInstallation == ResultOfInstallation.OK;
                }
                if (resultOfInstallation == ResultOfInstallation.OK) {
                    this.m_model.setNew(n2, false);
                    this.m_model.setModified(n2, false);
                    this.resetError();
                } else {
                    this.appendError("Could not install user '" + extUserConfiguration.sUserID + "'");
                }
            } else if (extUserConfiguration.isModified()) {
                System.out.println("Modifing user:");
                System.out.println(String.valueOf(extUserConfiguration.sUserID) + "," + extUserConfiguration.sUserName + "," + extUserConfiguration.sOfficeDir + extUserConfiguration.sProfile + "," + extUserConfiguration.eLanguage);
                this.m_model.setModified(n2, false);
                this.resetError();
            }
            ++n2;
        }
        return bl;
    }

    protected void appendError(String string) {
        this.m_sLastError = String.valueOf(this.m_sLastError) + "UserController: " + string + "\n";
    }

    protected void resetError() {
        this.m_sLastError = "";
    }

    public String getLastErrorString() {
        return this.m_sLastError;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.m_firstSelectedRow = listSelectionModel.getMinSelectionIndex();
            this.m_lastSelectedRow = listSelectionModel.getMaxSelectionIndex();
        }
    }
}

