/*
 * Decompiled with CFR 0.152.
 */
package stardiv.connect;

import java.util.Enumeration;
import java.util.Vector;
import stardiv.connect.ConnectionEvent;
import stardiv.connect.IConnectionListener;
import stardiv.uno.IExitListener;
import stardiv.uno.OEnvironment;
import stardiv.uno.OServer;
import stardiv.uno.OXInterfaceHolder;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;

public abstract class Connection {
    protected DispatcherThread m_thread;
    protected OEnvironment m_environ;
    protected OServer m_appServer;
    protected boolean m_isLoggedIn = false;
    protected Vector m_listeners;
    protected String m_sLastError = "";

    public void addConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new Vector();
            }
            this.m_listeners.addElement(iConnectionListener);
        }
    }

    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null && this.m_listeners != null) {
            this.m_listeners.removeElement(iConnectionListener);
        }
    }

    public synchronized boolean connect(String string) {
        boolean bl = false;
        if (!this.isConnected()) {
            String string2 = string;
            if (string2.lastIndexOf(58) <= 0) {
                string2 = String.valueOf(string2) + ":8125";
            }
            this.m_environ = new OEnvironment(1);
            this.m_appServer = this.m_environ.registerServer("uno://" + string2);
            if (this.m_appServer != null) {
                this.m_thread = new DispatcherThread();
                try {
                    this.m_thread.setDaemon(true);
                }
                catch (Exception exception) {
                    System.err.println("Connection: DispatcherThread is no daemon.");
                }
                this.m_thread.start();
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void disconnect() {
        System.out.println("Connection.disconnect() called.");
        this.m_isLoggedIn = false;
        if (this.m_thread != null) {
            if (this.m_environ != null) {
                OEnvironment oEnvironment = this.m_environ;
                synchronized (oEnvironment) {
                    this.m_environ.flushBlock();
                    this.m_environ.destroy();
                }
            }
            try {
                if (this.m_thread != null) {
                    this.m_thread.join();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_thread = null;
        this.m_environ = null;
        System.gc();
    }

    public synchronized XInterface createObject(String string, Uik uik) {
        OXInterfaceHolder oXInterfaceHolder = new OXInterfaceHolder();
        if (this.isConnected()) {
            this.m_appServer.createInstance(string, uik, oXInterfaceHolder);
        }
        return oXInterfaceHolder.getValue();
    }

    public synchronized boolean isConnected() {
        return this.m_thread != null;
    }

    public boolean isLoggedIn() {
        return this.m_isLoggedIn;
    }

    protected void finalize() {
        System.out.println("Connection.finalize() called");
        this.disconnect();
    }

    protected abstract void appendError(String var1);

    protected void resetError() {
        this.m_sLastError = "";
    }

    public String getLastErrorString() {
        return this.m_sLastError;
    }

    class DispatcherThread
    extends Thread
    implements IExitListener {
        public synchronized void run() {
            Connection.this.m_environ.setExitListener(this);
            while (Connection.this.m_environ.isAnyServerConnected()) {
                Connection.this.m_environ.dispatch(-1);
            }
            System.out.println("Exiting dispatcher thread...");
            this.exit(0);
        }

        public synchronized void exit(int n) {
            Connection.this.m_environ.setExitListener(null);
            Connection.this.m_thread = null;
            Connection.this.m_environ = null;
            Connection.this.m_appServer = null;
            System.out.println("Exit called.");
            if (Connection.this.m_listeners != null) {
                Enumeration enumeration = Connection.this.m_listeners.elements();
                ConnectionEvent connectionEvent = new ConnectionEvent(this, 1);
                while (enumeration.hasMoreElements()) {
                    ((IConnectionListener)enumeration.nextElement()).connectionStatus(connectionEvent);
                }
            }
        }

        DispatcherThread() {
            Connection.this = Connection.this;
        }
    }
}

