/*
 * Decompiled with CFR 0.152.
 */
package stardiv.connect;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import stardiv.connect.ConnectionEvent;
import stardiv.connect.IConnectionListener;
import stardiv.daemons.sofficed.AdminType;
import stardiv.daemons.sofficed.XMonitor;
import stardiv.uno.IExitListener;
import stardiv.uno.OEnvironment;
import stardiv.uno.OServer;
import stardiv.uno.OXInterfaceHolder;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;

public class MonitorConnection {
    protected DispatcherThread m_thread;
    protected OEnvironment m_environ;
    protected OServer m_appServer;
    protected boolean m_isLoggedIn = false;
    protected Vector m_listeners;
    protected XMonitor m_xMonitor;

    public XMonitor getMonitor() {
        return this.m_xMonitor;
    }

    public void addConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new Vector();
            }
            this.m_listeners.addElement(iConnectionListener);
        }
    }

    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null && this.m_listeners != null) {
            this.m_listeners.removeElement(iConnectionListener);
        }
    }

    public synchronized boolean connect(String string) {
        boolean bl = false;
        if (!this.isConnected()) {
            String string2 = string;
            if (string2.lastIndexOf(58) <= 0) {
                string2 = String.valueOf(string2) + ":8125";
            }
            this.m_environ = new OEnvironment(1);
            this.m_appServer = this.m_environ.registerServer("uno://" + string2);
            if (this.m_appServer != null) {
                this.m_thread = new DispatcherThread();
                try {
                    this.m_thread.setDaemon(true);
                }
                catch (Exception exception) {
                    System.err.println("Connection: DispatcherThread is no daemon.");
                }
                this.m_thread.start();
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void disconnect() {
        this.m_isLoggedIn = false;
        if (this.m_thread != null) {
            if (this.m_environ != null) {
                OEnvironment oEnvironment = this.m_environ;
                synchronized (oEnvironment) {
                    this.m_environ.flushBlock();
                    this.m_environ.destroy();
                }
            }
            try {
                if (this.m_thread != null) {
                    this.m_thread.join();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_thread = null;
        this.m_environ = null;
        System.gc();
    }

    public synchronized AdminType login(String string, String string2) {
        OXInterfaceHolder oXInterfaceHolder;
        AdminType adminType = AdminType.UNAUTHORIZED;
        if (this.isConnected() && this.m_appServer.createInstance("Monitor.sofficed.daemons.stardiv.de", XMonitor.UIK, oXInterfaceHolder = new OXInterfaceHolder())) {
            this.m_xMonitor = (XMonitor)oXInterfaceHolder.value;
            if (this.m_xMonitor != null) {
                String string3 = "unknown";
                try {
                    string3 = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {}
                adminType = this.m_xMonitor.login(string, string2);
                if (adminType != AdminType.UNAUTHORIZED) {
                    this.m_isLoggedIn = true;
                }
            }
        }
        return adminType;
    }

    public synchronized XInterface createObject(String string, Uik uik) {
        OXInterfaceHolder oXInterfaceHolder = new OXInterfaceHolder();
        if (this.isConnected()) {
            this.m_appServer.createInstance(string, uik, oXInterfaceHolder);
        }
        return oXInterfaceHolder.getValue();
    }

    public synchronized boolean isConnected() {
        return this.m_thread != null;
    }

    public boolean isLoggedIn() {
        return this.m_isLoggedIn;
    }

    protected void finalize() {
        this.disconnect();
    }

    class DispatcherThread
    extends Thread
    implements IExitListener {
        public synchronized void run() {
            MonitorConnection.this.m_environ.setExitListener(this);
            while (MonitorConnection.this.m_environ.isAnyServerConnected()) {
                MonitorConnection.this.m_environ.dispatch(-1);
            }
            this.exit(0);
        }

        public synchronized void exit(int n) {
            MonitorConnection.this.m_environ.setExitListener(null);
            MonitorConnection.this.m_thread = null;
            MonitorConnection.this.m_environ = null;
            MonitorConnection.this.m_appServer = null;
            if (MonitorConnection.this.m_listeners != null) {
                Enumeration enumeration = MonitorConnection.this.m_listeners.elements();
                ConnectionEvent connectionEvent = new ConnectionEvent(this, 1);
                while (enumeration.hasMoreElements()) {
                    ((IConnectionListener)enumeration.nextElement()).connectionStatus(connectionEvent);
                }
            }
        }

        DispatcherThread() {
            MonitorConnection.this = MonitorConnection.this;
        }
    }
}

