/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.holder;

import stardiv.uno.OUnoSystemException;
import stardiv.uno.XInterface;

public final class OAny {
    protected Class m_class;
    protected Object m_object;
    protected int m_typeCode;

    public OAny(Object object, Class clazz) {
        if (object == null || clazz == null || !clazz.isAssignableFrom(object.getClass())) {
            throw new OUnoSystemException("initializing OAny with wrong object / class pair");
        }
        this.m_class = clazz;
        this.m_object = object;
        this.m_typeCode = OAny.queryTypeCodeFromClass(this.m_class);
    }

    public OAny() {
        this.m_object = null;
        this.m_class = null;
        this.m_typeCode = 1;
    }

    public OAny(int n) {
        this.m_object = new Integer(n);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 9;
    }

    public OAny(long l) {
        this.m_object = new Long(l);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 11;
    }

    public OAny(short s) {
        this.m_object = new Short(s);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 7;
    }

    public OAny(boolean bl) {
        this.m_object = new Boolean(bl);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 15;
    }

    public OAny(float f) {
        this.m_object = new Float(f);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 13;
    }

    public OAny(double d) {
        this.m_object = new Double(d);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 14;
    }

    public OAny(char c) {
        this.m_object = new Character(c);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 4;
    }

    public OAny(byte by) {
        this.m_object = new Byte(by);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 3;
    }

    public OAny(String string) {
        this.m_object = new String(string);
        this.m_class = this.m_object.getClass();
        this.m_typeCode = 18;
    }

    public int getTypeCode() {
        return this.m_typeCode;
    }

    public Class getAnyClass() {
        return this.m_class;
    }

    public int getAnyType() {
        return this.m_typeCode;
    }

    public Object getAnyValue() {
        return this.m_object;
    }

    public int getIntValue() {
        return (Integer)this.m_object;
    }

    public long getLongValue() {
        return (Long)this.m_object;
    }

    public short getShortValue() {
        return (Short)this.m_object;
    }

    public boolean getBoolValue() {
        return (Boolean)this.m_object;
    }

    public float getFloatValue() {
        return ((Float)this.m_object).floatValue();
    }

    public double getDoubleValue() {
        return (Double)this.m_object;
    }

    public char getCharValue() {
        return ((Character)this.m_object).charValue();
    }

    public byte getByteValue() {
        return (Byte)this.m_object;
    }

    public String getStringValue() {
        return (String)this.m_object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OAny setUnsigned(boolean bl) {
        if (bl) {
            switch (this.m_typeCode) {
                case 5: {
                    this.m_typeCode = 6;
                    return this;
                }
                case 7: {
                    this.m_typeCode = 8;
                    return this;
                }
                case 9: {
                    this.m_typeCode = 10;
                    return this;
                }
                case 11: {
                    this.m_typeCode = 12;
                    return this;
                }
                default: {
                    return this;
                }
            }
        }
        switch (this.m_typeCode) {
            case 6: {
                this.m_typeCode = 5;
                break;
            }
            case 8: {
                this.m_typeCode = 7;
                break;
            }
            case 10: {
                this.m_typeCode = 9;
                break;
            }
            case 12: {
                this.m_typeCode = 11;
            }
        }
        return this;
    }

    public boolean isUnsigned() {
        return this.m_typeCode == 6 || this.m_typeCode == 8 || this.m_typeCode == 10 || this.m_typeCode == 12;
    }

    protected static int queryTypeCodeFromClass(Class clazz) {
        String string;
        int n = 127;
        n = clazz.isArray() ? 19 : ((string = clazz.getName()).equals("stardiv.uno.OAny") ? 22 : (string.equals("java.lang.Integer") ? 9 : (string.equals("java.lang.Long") ? 11 : (string.equals("java.lang.Short") ? 7 : (string.equals("java.lang.Boolean") ? 15 : (string.equals("java.lang.Float") ? 13 : (string.equals("java.lang.Double") ? 14 : (string.equals("java.lang.Char") ? 4 : (string.equals("java.lang.Byte") ? 3 : (string.equals("java.lang.String") ? 18 : (XInterface.CLASS.isAssignableFrom(clazz) ? 20 : 17)))))))))));
        return n;
    }
}

