/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import java.util.Stack;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OSemaphore;
import stardiv.uno.sys.marshal.OBufferHeap;

class OCachedRequestQueue {
    public Stack m_ridStack;
    protected int m_front;
    protected int m_back;
    protected ORequest[] m_requests;
    protected OBufferHeap m_bufferHeap;
    protected ORequestBroker m_broker;
    protected int m_lastInit;
    protected OSemaphore m_sem;

    public OCachedRequestQueue(OBufferHeap oBufferHeap, ORequestBroker oRequestBroker) {
        this.m_broker = oRequestBroker;
        this.m_requests = new ORequest[256];
        this.m_bufferHeap = oBufferHeap;
        this.m_front = -1;
        this.m_back = -1;
        this.m_lastInit = -1;
        this.m_ridStack = new Stack();
        this.m_sem = new OSemaphore(Integer.MAX_VALUE);
    }

    public synchronized boolean isEmpty() {
        return this.m_front < 0;
    }

    public synchronized void push(ORequest oRequest) {
        if (this.m_back < 0) {
            this.m_requests[0] = oRequest;
            this.m_back = 0;
            this.m_front = 0;
        } else {
            if (this.m_back >= this.m_requests.length - 1) {
                ORequest[] oRequestArray = new ORequest[this.m_requests.length * 2];
                System.arraycopy(this.m_requests, 0, oRequestArray, 0, this.m_requests.length);
                this.m_requests = oRequestArray;
            }
            this.m_requests[++this.m_back] = oRequest;
        }
        this.m_sem.release();
    }

    public ORequest pop(boolean bl) {
        ORequest oRequest = null;
        if (bl) {
            this.m_sem.acquire();
        } else {
            this.m_sem.tryToAcquire();
        }
        OCachedRequestQueue oCachedRequestQueue = this;
        synchronized (oCachedRequestQueue) {
            if (this.m_front >= 0) {
                if (this.m_back == this.m_front) {
                    oRequest = this.m_requests[this.m_front];
                    if (this.m_front > 0) {
                        int n = 0;
                        while (n < this.m_back) {
                            this.m_requests[n].releaseAllBuffers();
                            this.m_requests[n] = null;
                            ++n;
                        }
                    }
                    this.m_front = -1;
                    this.m_back = -1;
                    this.m_lastInit = -1;
                } else {
                    oRequest = this.m_requests[this.m_front++];
                }
            }
        }
        return oRequest;
    }
}

