/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import java.util.Enumeration;
import java.util.Hashtable;
import stardiv.uno.IDispatchAble;
import stardiv.uno.IInterfaceFactory;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;
import stardiv.uno.XInterfaceRemoteProxy;
import stardiv.uno.sys.OCid;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OThreadCallContext;
import stardiv.uno.sys.StubKey;

public class OContext {
    protected static Class m_proxyClass = null;
    protected IInterfaceFactory m_factory;
    protected OCid m_cid;
    protected XInterface m_xInterface;
    protected IDispatchAble m_stub;
    protected ORequestBroker m_broker;
    protected int m_refCount;
    protected static Hashtable m_threadContextTable = new Hashtable();
    protected static Hashtable m_cidTable = new Hashtable();
    protected static Hashtable m_stubTable = new Hashtable();
    protected static int m_oidCount = 1;
    protected static int m_serverIdCount = 1;

    public OContext(ORequestBroker oRequestBroker, XInterface xInterface, IInterfaceFactory iInterfaceFactory) {
        this.m_cid = new OCid(m_oidCount++, 1);
        this.m_factory = iInterfaceFactory;
        this.m_broker = oRequestBroker;
        this.m_xInterface = xInterface;
        this.m_stub = iInterfaceFactory.createStub(xInterface);
        this.m_refCount = 1;
        m_cidTable.put(this.m_cid, this);
    }

    public OContext(OCid oCid, ORequestBroker oRequestBroker, IInterfaceFactory iInterfaceFactory) {
        this.m_cid = oCid;
        this.m_refCount = 1;
        m_cidTable.put(this.m_cid, this);
        this.m_factory = iInterfaceFactory;
        this.m_broker = oRequestBroker;
        this.m_xInterface = iInterfaceFactory.createProxy(oRequestBroker, oCid);
        this.m_stub = null;
    }

    protected void finalize() {
        if (this.m_xInterface != null && this.m_stub != null) {
            this.m_xInterface.release();
        }
    }

    public void setProxy(XInterface xInterface) {
        if (this.m_xInterface != null && this.m_stub != null) {
            this.m_xInterface.release();
            this.m_xInterface = null;
            --this.m_refCount;
        }
        this.m_xInterface = xInterface;
        ++this.m_refCount;
        if (this.m_xInterface != null && this.m_stub != null) {
            this.m_xInterface.acquire();
        }
    }

    public void setStub(IDispatchAble iDispatchAble) {
        this.m_stub = iDispatchAble;
        ++this.m_refCount;
        if (this.m_xInterface != null && this.m_stub != null) {
            this.m_xInterface.acquire();
        }
    }

    public static OContext createStubContext(ORequestBroker oRequestBroker, XInterface xInterface, IInterfaceFactory iInterfaceFactory) {
        Class<?> clazz;
        OContext oContext = null;
        if (m_proxyClass == null) {
            try {
                m_proxyClass = Class.forName("stardiv.uno.XInterfaceRemoteProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OUnoSystemException("class XInterfaceRemoteProxy not found while initializing context table");
            }
        }
        if (m_proxyClass.isAssignableFrom(clazz = xInterface.getClass())) {
            oContext = OContext.getContext(((XInterfaceRemoteProxy)xInterface).getCid());
            if (oContext.getCid().m_sidLen == 1 && oContext.getCid().m_shortSid == oRequestBroker.getServer().getServerId()) {
                oContext.acquire();
            } else {
                oContext = null;
            }
        }
        if (oContext == null) {
            StubKey stubKey = new StubKey(xInterface, iInterfaceFactory);
            oContext = (OContext)m_stubTable.get(stubKey);
            if (oContext == null) {
                oContext = new OContext(oRequestBroker, xInterface, iInterfaceFactory);
                m_stubTable.put(stubKey, oContext);
            } else {
                oContext.acquire();
            }
        }
        return oContext;
    }

    public static XInterface createProxyContext(ORequestBroker oRequestBroker, OCid oCid, Uik uik, IInterfaceFactory iInterfaceFactory) {
        OContext oContext = (OContext)m_cidTable.get(oCid);
        XInterface xInterface = null;
        if (oContext == null) {
            oContext = new OContext(oCid, oRequestBroker, iInterfaceFactory);
        }
        xInterface = oContext.getXInterface();
        return xInterface;
    }

    public static OContext getContext(OCid oCid) {
        return (OContext)m_cidTable.get(oCid);
    }

    public static int invalidateContexts(ORequestBroker oRequestBroker) {
        int n = 0;
        Enumeration enumeration = m_cidTable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            OContext oContext = (OContext)enumeration.nextElement();
            if (oContext.getBroker() != oRequestBroker) continue;
            if (oContext.getXInterface() != null) {
                try {
                    object = (XInterfaceRemoteProxy)oContext.getXInterface();
                    if (!((XInterfaceRemoteProxy)object).m_isFinalized) {
                        ORequest oRequest = new ORequest(oContext.getBroker(), oContext.getCid(), 3, Integer.MIN_VALUE);
                        oRequest.execute();
                        ((XInterfaceRemoteProxy)object).m_isFinalized = true;
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (OUnoSystemException oUnoSystemException) {}
            }
            if (oContext.getXInterface() != null) {
                object = new StubKey(oContext.getXInterface(), oContext.getFactory());
                m_stubTable.remove(object);
            }
            oContext.invalidate();
            m_cidTable.remove(oContext.getCid());
        }
        return n;
    }

    public static synchronized int getNewServerId() {
        return ++m_serverIdCount;
    }

    public OCid getCid() {
        return this.m_cid;
    }

    public void invalidate() {
        if (this.m_xInterface != null && this.m_stub != null) {
            this.m_xInterface.release();
        }
        this.m_broker = null;
        this.m_xInterface = null;
        this.m_stub = null;
    }

    public ORequestBroker getBroker() {
        return this.m_broker;
    }

    public IDispatchAble getStub() {
        return this.m_stub;
    }

    public XInterface getXInterface() {
        return this.m_xInterface;
    }

    public IInterfaceFactory getFactory() {
        return this.m_factory;
    }

    public int acquire() {
        return ++this.m_refCount;
    }

    public int release() {
        int n;
        if ((n = --this.m_refCount) == 0) {
            m_cidTable.remove(this.m_cid);
            if (this.m_factory != null && this.m_xInterface != null) {
                StubKey stubKey = new StubKey(this.m_xInterface, this.m_factory);
                m_stubTable.remove(stubKey);
            }
            if (this.m_xInterface != null && this.m_stub != null) {
                this.m_xInterface.release();
            }
            this.m_xInterface = null;
            this.m_stub = null;
        }
        return n;
    }

    public static void setActualCallContext(OThreadCallContext oThreadCallContext, Thread thread) {
        m_threadContextTable.put(thread, oThreadCallContext);
    }

    public static OThreadCallContext getActualCallContext(Thread thread) {
        if (m_threadContextTable.containsKey(thread)) {
            return (OThreadCallContext)m_threadContextTable.get(thread);
        }
        return OThreadCallContext.NULL_CONTEXT;
    }
}

