/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys;

import java.lang.reflect.Array;
import stardiv.uno.Enum;
import stardiv.uno.OUikHolder;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.OUnoUserException;
import stardiv.uno.OXInterfaceHolder;
import stardiv.uno.Uik;
import stardiv.uno.XInterface;
import stardiv.uno.holder.OAny;
import stardiv.uno.holder.OArrayHolder;
import stardiv.uno.holder.OBooleanArrayHolder;
import stardiv.uno.holder.OBooleanHolder;
import stardiv.uno.holder.OByteArrayHolder;
import stardiv.uno.holder.OByteHolder;
import stardiv.uno.holder.OCharArrayHolder;
import stardiv.uno.holder.OCharHolder;
import stardiv.uno.holder.OCidHolder;
import stardiv.uno.holder.ODoubleArrayHolder;
import stardiv.uno.holder.ODoubleHolder;
import stardiv.uno.holder.OFloatArrayHolder;
import stardiv.uno.holder.OFloatHolder;
import stardiv.uno.holder.OIntArrayHolder;
import stardiv.uno.holder.OIntHolder;
import stardiv.uno.holder.OLongArrayHolder;
import stardiv.uno.holder.OLongHolder;
import stardiv.uno.holder.OOAnyHolder;
import stardiv.uno.holder.OObjectArrayHolder;
import stardiv.uno.holder.OObjectHolder;
import stardiv.uno.holder.OShortArrayHolder;
import stardiv.uno.holder.OShortHolder;
import stardiv.uno.holder.OStringHolder;
import stardiv.uno.sys.IMarshalFunction;
import stardiv.uno.sys.OCid;
import stardiv.uno.sys.OConcreteArrayHolder;
import stardiv.uno.sys.OContext;
import stardiv.uno.sys.ODynMarshalXInterface;
import stardiv.uno.sys.OMarshalAny;
import stardiv.uno.sys.OMarshalType;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OThreadCallContext;
import stardiv.uno.sys.marshal.OBuffer;
import stardiv.uno.sys.marshal.OBufferHeap;
import stardiv.uno.sys.marshal.OCdrDecoder;
import stardiv.uno.sys.marshal.OCdrEncoder;
import stardiv.uno.sys.marshal.ODecodeException;
import stardiv.uno.sys.marshal.OEncodeException;
import stardiv.uno.sys.server.OServerStub;

public class ORequest {
    public static final int FLAG_ONEWAY = Integer.MIN_VALUE;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_RETRY = 0x10000000;
    public static final int FLAG_INCOMING = 0x20000000;
    public static final int FLAG_REPLY = 0x40000000;
    protected static final int REQUESTHEADERLEN = 18;
    protected static OMarshalAny m_anyMarshalFunction = new OMarshalAny();
    protected static String m_marshalPrefix = ".OMarshal";
    public OBuffer m_head;
    public OBuffer m_data;
    protected OBuffer m_trash;
    protected ORequestBroker m_broker;
    protected int m_rid;
    protected OCid m_cid;
    protected int m_flags;
    protected int m_inUnmarshal;
    protected short m_signature;
    protected OCdrDecoder m_decoder;
    protected OCdrEncoder m_encoder;
    protected OBufferHeap m_bufferHeap;
    protected OUnoSystemException m_systemException;
    protected OUnoUserException m_userException;
    protected OThreadCallContext m_threadCallContext;
    protected static ODynMarshalXInterface m_dynMarshal = new ODynMarshalXInterface();
    protected static OMarshalType[] sysDispatchTypes = new OMarshalType[]{new OMarshalType(18, 1, null), new OMarshalType(17, 1, Uik.m_marshalFunction), new OMarshalType(20, 2, m_dynMarshal), new OMarshalType(15, 2, null)};

    public ORequest(ORequestBroker oRequestBroker, OCid oCid, short s, int n) {
        this.m_threadCallContext = OThreadCallContext.NULL_CONTEXT;
        if (oRequestBroker == null) {
            throw new OUnoSystemException("call to invalid remote interface");
        }
        this.m_cid = oCid;
        this.m_signature = s;
        this.m_flags = n;
        this.m_broker = oRequestBroker;
        this.m_encoder = this.m_broker.m_channel.getEncoder();
        this.m_decoder = this.m_broker.m_channel.getDecoder();
        this.m_rid = this.m_broker.createRid();
        this.m_inUnmarshal = 0;
        this.m_bufferHeap = this.m_broker.m_channel.m_bufferHeap;
        this.m_data = new OBuffer();
        this.m_head = new OBuffer(18);
        this.m_trash = null;
    }

    public ORequest(ORequestBroker oRequestBroker, short s, int n) {
        this.m_threadCallContext = OThreadCallContext.NULL_CONTEXT;
        if (oRequestBroker == null) {
            throw new OUnoSystemException("call to invalid remote interface");
        }
        this.m_cid = OCid.invalidCid;
        this.m_signature = s;
        this.m_flags = n;
        this.m_broker = oRequestBroker;
        this.m_encoder = this.m_broker.m_channel.getEncoder();
        this.m_decoder = this.m_broker.m_channel.getDecoder();
        this.m_rid = this.m_broker.createRid();
        this.m_inUnmarshal = 0;
        this.m_bufferHeap = this.m_broker.m_channel.m_bufferHeap;
        this.m_data = new OBuffer();
        this.m_head = new OBuffer(18);
        this.m_trash = null;
    }

    public ORequest(ORequestBroker oRequestBroker, OBuffer oBuffer) {
        int n = 0;
        this.m_threadCallContext = new OThreadCallContext();
        if (oRequestBroker == null) {
            throw new OUnoSystemException("call to invalid remote interface");
        }
        this.m_broker = oRequestBroker;
        this.m_encoder = this.m_broker.m_channel.getEncoder();
        this.m_decoder = this.m_broker.m_channel.getDecoder();
        this.m_inUnmarshal = 1;
        this.m_bufferHeap = this.m_broker.m_channel.m_bufferHeap;
        this.m_data = oBuffer;
        this.m_head = this.m_bufferHeap.getBuffer(18);
        this.m_trash = null;
        this.m_rid = this.m_decoder.decodeULong(this.m_data);
        n = this.m_decoder.decodeULong(this.m_data);
        this.m_threadCallContext.m_threadId = this.m_decoder.decodeULong(this.m_data);
        this.m_cid = this.m_decoder.decodeCid(this.m_data);
        this.m_signature = this.m_decoder.decodeUShort(this.m_data);
        this.m_flags = this.m_decoder.decodeULong(this.m_data) | 0x20000000;
        this.m_threadCallContext.m_serverId = this.m_broker.getServer().mapIncomingServerId(n);
        this.unmarshalException();
    }

    public ORequest(OBuffer oBuffer, ORequestBroker oRequestBroker, OCdrEncoder oCdrEncoder, OCdrDecoder oCdrDecoder) {
        int n = 0;
        this.m_threadCallContext = new OThreadCallContext();
        this.m_broker = oRequestBroker;
        this.m_data = oBuffer;
        this.m_trash = null;
        this.m_encoder = oCdrEncoder;
        this.m_decoder = oCdrDecoder;
        this.m_inUnmarshal = 1;
        this.m_bufferHeap = this.m_broker.m_channel.m_bufferHeap;
        this.m_head = this.m_bufferHeap.getBuffer(18);
        this.m_rid = this.m_decoder.decodeULong(this.m_data);
        n = this.m_decoder.decodeULong(this.m_data);
        this.m_threadCallContext.m_threadId = this.m_decoder.decodeULong(this.m_data);
        this.m_cid = this.m_decoder.decodeCid(this.m_data);
        this.m_signature = this.m_decoder.decodeUShort(this.m_data);
        this.m_flags = this.m_decoder.decodeULong(this.m_data) | 0x20000000;
        this.m_threadCallContext.m_serverId = this.m_broker.getServer().mapIncomingServerId(n);
        this.unmarshalException();
    }

    public OUnoUserException getUserException() {
        return this.m_userException;
    }

    public void releaseAllBuffers() {
        if (this.m_head != null) {
            this.m_bufferHeap.putBuffer(this.m_head);
            this.m_head = null;
        }
        if (this.m_data != null) {
            this.m_bufferHeap.putBuffer(this.m_data);
            this.m_data = null;
        }
        if (this.m_trash != null) {
            this.m_bufferHeap.putBuffer(this.m_trash);
            this.m_trash = null;
        }
    }

    public boolean marshalArguments(OMarshalType[] oMarshalTypeArray, Object[] objectArray, int n) {
        try {
            if (objectArray != null && oMarshalTypeArray != null) {
                int n2 = 0;
                while (n2 < oMarshalTypeArray.length) {
                    if ((n & oMarshalTypeArray[n2].m_inOut) > 0) {
                        switch (oMarshalTypeArray[n2].m_type) {
                            case 2: {
                                this.m_encoder.encodeOctet(this.m_data, ((OByteHolder)objectArray[n2]).value);
                                break;
                            }
                            case 3: {
                                this.m_encoder.encodeByte(this.m_data, ((OByteHolder)objectArray[n2]).value);
                                break;
                            }
                            case 4: {
                                this.m_encoder.encodeChar(this.m_data, ((OCharHolder)objectArray[n2]).value);
                                break;
                            }
                            case 5: {
                                this.m_encoder.encodeLong(this.m_data, ((OIntHolder)objectArray[n2]).value);
                                break;
                            }
                            case 6: {
                                this.m_encoder.encodeULong(this.m_data, ((OIntHolder)objectArray[n2]).value);
                                break;
                            }
                            case 7: {
                                this.m_encoder.encodeShort(this.m_data, ((OShortHolder)objectArray[n2]).value);
                                break;
                            }
                            case 8: {
                                this.m_encoder.encodeUShort(this.m_data, ((OShortHolder)objectArray[n2]).value);
                                break;
                            }
                            case 9: {
                                this.m_encoder.encodeLong(this.m_data, ((OIntHolder)objectArray[n2]).value);
                                break;
                            }
                            case 10: {
                                this.m_encoder.encodeULong(this.m_data, ((OIntHolder)objectArray[n2]).value);
                                break;
                            }
                            case 11: {
                                this.m_encoder.encodeHyper(this.m_data, ((OLongHolder)objectArray[n2]).value);
                                break;
                            }
                            case 12: {
                                this.m_encoder.encodeUHyper(this.m_data, ((OLongHolder)objectArray[n2]).value);
                                break;
                            }
                            case 13: {
                                this.m_encoder.encodeFloat(this.m_data, ((OFloatHolder)objectArray[n2]).value);
                                break;
                            }
                            case 14: {
                                this.m_encoder.encodeDouble(this.m_data, ((ODoubleHolder)objectArray[n2]).value);
                                break;
                            }
                            case 15: {
                                this.m_encoder.encodeBoolean(this.m_data, ((OBooleanHolder)objectArray[n2]).value);
                                break;
                            }
                            case 16: {
                                if (oMarshalTypeArray[n2].m_mFunction == null) {
                                    this.m_encoder.encodeEnum(this.m_data, ((OIntHolder)objectArray[n2]).value);
                                    break;
                                }
                                this.m_encoder.encodeEnum(this.m_data, ((Enum)((OObjectHolder)objectArray[n2]).value).getValue());
                                break;
                            }
                            case 18: {
                                this.m_encoder.encodeString(this.m_data, ((OStringHolder)objectArray[n2]).value);
                                break;
                            }
                            case 17: {
                                this.m_encoder.encodeEnum(this.m_data, 17);
                                oMarshalTypeArray[n2].m_mFunction.marshal(this, (OObjectHolder)objectArray[n2], true);
                                break;
                            }
                            case 20: {
                                this.m_encoder.encodeEnum(this.m_data, 20);
                                oMarshalTypeArray[n2].m_mFunction.marshal(this, (OObjectHolder)objectArray[n2], true);
                                break;
                            }
                            case 21: {
                                this.m_encoder.encodeCid(this.m_data, ((OCidHolder)objectArray[n2]).getValue());
                                break;
                            }
                            case 19: {
                                this.m_encoder.encodeEnum(this.m_data, 19);
                                this.encodeSequence((OObjectHolder)objectArray[n2], oMarshalTypeArray[n2].m_mFunction);
                                break;
                            }
                            case 22: {
                                this.m_encoder.encodeEnum(this.m_data, 22);
                                m_anyMarshalFunction.marshal(this, (OOAnyHolder)objectArray[n2], true);
                                break;
                            }
                            case 23: {
                                throw new OUnoSystemException();
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new OUnoSystemException("error while marshaling request");
        }
        return true;
    }

    public boolean unmarshalArguments(OMarshalType[] oMarshalTypeArray, Object[] objectArray, int n) {
        try {
            ++this.m_inUnmarshal;
            if (objectArray != null && oMarshalTypeArray != null) {
                int n2 = 0;
                while (n2 < oMarshalTypeArray.length) {
                    if ((n & oMarshalTypeArray[n2].m_inOut) > 0) {
                        switch (oMarshalTypeArray[n2].m_type) {
                            case 2: {
                                ((OByteHolder)objectArray[n2]).value = this.m_decoder.decodeOctet(this.m_data);
                                break;
                            }
                            case 3: {
                                ((OByteHolder)objectArray[n2]).value = this.m_decoder.decodeByte(this.m_data);
                                break;
                            }
                            case 4: {
                                ((OCharHolder)objectArray[n2]).value = this.m_decoder.decodeChar(this.m_data);
                                break;
                            }
                            case 5: {
                                ((OIntHolder)objectArray[n2]).value = this.m_decoder.decodeLong(this.m_data);
                                break;
                            }
                            case 6: {
                                ((OIntHolder)objectArray[n2]).value = this.m_decoder.decodeULong(this.m_data);
                                break;
                            }
                            case 7: {
                                ((OShortHolder)objectArray[n2]).value = this.m_decoder.decodeShort(this.m_data);
                                break;
                            }
                            case 8: {
                                ((OShortHolder)objectArray[n2]).value = this.m_decoder.decodeUShort(this.m_data);
                                break;
                            }
                            case 9: {
                                ((OIntHolder)objectArray[n2]).value = this.m_decoder.decodeLong(this.m_data);
                                break;
                            }
                            case 10: {
                                ((OIntHolder)objectArray[n2]).value = this.m_decoder.decodeULong(this.m_data);
                                break;
                            }
                            case 11: {
                                ((OLongHolder)objectArray[n2]).value = this.m_decoder.decodeHyper(this.m_data);
                                break;
                            }
                            case 12: {
                                ((OLongHolder)objectArray[n2]).value = this.m_decoder.decodeUHyper(this.m_data);
                                break;
                            }
                            case 13: {
                                ((OFloatHolder)objectArray[n2]).value = this.m_decoder.decodeFloat(this.m_data);
                                break;
                            }
                            case 14: {
                                ((ODoubleHolder)objectArray[n2]).value = this.m_decoder.decodeDouble(this.m_data);
                                break;
                            }
                            case 15: {
                                ((OBooleanHolder)objectArray[n2]).value = this.m_decoder.decodeBoolean(this.m_data);
                                break;
                            }
                            case 16: {
                                if (oMarshalTypeArray[n2].m_mFunction == null) {
                                    ((OIntHolder)objectArray[n2]).value = this.m_decoder.decodeEnum(this.m_data);
                                    break;
                                }
                                Object object = new OObjectHolder(new Integer(this.m_decoder.decodeEnum(this.m_data)));
                                oMarshalTypeArray[n2].m_mFunction.marshal(this, (OObjectHolder)object, false);
                                if (((OObjectHolder)object).value == null) {
                                    throw new ODecodeException();
                                }
                                ((OObjectHolder)objectArray[n2]).value = ((OObjectHolder)object).value;
                                break;
                            }
                            case 18: {
                                ((OStringHolder)objectArray[n2]).value = this.m_decoder.decodeString(this.m_data);
                                break;
                            }
                            case 17: {
                                int n3 = this.m_decoder.decodeEnum(this.m_data);
                                if (n3 == 17) {
                                    oMarshalTypeArray[n2].m_mFunction.marshal(this, (OObjectHolder)objectArray[n2], false);
                                    break;
                                }
                                throw new ODecodeException();
                            }
                            case 20: {
                                int n3 = this.m_decoder.decodeEnum(this.m_data);
                                if (n3 == 20) {
                                    oMarshalTypeArray[n2].m_mFunction.marshal(this, (OObjectHolder)objectArray[n2], false);
                                    break;
                                }
                                throw new ODecodeException();
                            }
                            case 21: {
                                ((OCidHolder)objectArray[n2]).value = this.m_decoder.decodeCid(this.m_data);
                                break;
                            }
                            case 19: {
                                int n3 = this.m_decoder.decodeEnum(this.m_data);
                                if (n3 == 19) {
                                    this.decodeSequence((OObjectHolder)objectArray[n2], oMarshalTypeArray[n2].m_mFunction);
                                    break;
                                }
                                throw new ODecodeException();
                            }
                            case 22: {
                                Object object;
                                int n3 = this.m_decoder.decodeEnum(this.m_data);
                                if (n3 == 22) {
                                    object = new OMarshalAny();
                                    ((OMarshalAny)object).marshal(this, (OOAnyHolder)objectArray[n2], false);
                                    break;
                                }
                                throw new ODecodeException();
                            }
                            case 23: {
                                throw new OUnoSystemException();
                            }
                        }
                    }
                    ++n2;
                }
            }
            --this.m_inUnmarshal;
        }
        catch (ClassCastException classCastException) {
            throw new OUnoSystemException("error while unmarshaling request");
        }
        return true;
    }

    public int getRid() {
        return this.m_rid;
    }

    public boolean isReply() {
        return (this.m_flags & 0x40000000) != 0;
    }

    public boolean isSync() {
        return (this.m_flags & Integer.MIN_VALUE) == 0;
    }

    public boolean isSysRequest() {
        return this.m_cid.isInvalid() && this.m_signature > 1;
    }

    public void putReply(ORequest oRequest) {
        this.m_trash = this.m_data;
        this.m_data = oRequest.m_data;
        this.m_userException = oRequest.m_userException;
        this.m_systemException = oRequest.m_systemException;
        oRequest.m_data = null;
    }

    public void acquireContext() {
        OContext.getContext(this.m_cid).acquire();
    }

    public void releaseContext() {
        OContext.getContext(this.m_cid).release();
    }

    public boolean execute() {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        try {
            if ((this.m_flags & 0x20000000) != 0) {
                boolean bl2 = false;
                this.m_flags &= 0xDFFFFFFF;
                this.m_flags |= 0x40000000;
                if (OContext.getActualCallContext((Thread)thread).m_serverId == 0) {
                    OContext.setActualCallContext(this.m_threadCallContext, thread);
                    bl2 = true;
                }
                if (this.m_cid.isInvalid()) {
                    bl = this.sysDispatch(this.m_signature);
                } else {
                    OContext oContext = OContext.getContext(this.m_cid);
                    if (oContext != null) {
                        try {
                            if (this.m_userException != null) {
                                throw this.m_userException;
                            }
                            if (this.m_systemException != null) {
                                throw this.m_systemException;
                            }
                            bl = oContext.getStub().dispatch(this.m_signature, this);
                        }
                        catch (OUnoUserException oUnoUserException) {
                            this.m_userException = oUnoUserException;
                            this.execute();
                        }
                        catch (OUnoSystemException oUnoSystemException) {
                            this.m_systemException = oUnoSystemException;
                            this.execute();
                        }
                        catch (ODecodeException oDecodeException) {
                            this.m_systemException = new OUnoSystemException("error while unmarshaling arguments");
                            this.execute();
                        }
                        catch (OEncodeException oEncodeException) {
                            this.m_systemException = new OUnoSystemException("error while marshaling arguments");
                            this.execute();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.out);
                            this.m_systemException = new OUnoSystemException("unknown exception: " + exception);
                            this.execute();
                        }
                    } else {
                        bl = false;
                    }
                    if (bl2) {
                        OContext.setActualCallContext(OThreadCallContext.NULL_CONTEXT, thread);
                    }
                }
            } else {
                if (!this.isReply() || this.isSync()) {
                    boolean bl3 = false;
                    this.m_threadCallContext = OContext.getActualCallContext(thread);
                    if (this.m_threadCallContext.m_serverId == 0) {
                        bl3 = true;
                        this.m_threadCallContext = new OThreadCallContext(OThreadCallContext.getNewThreadId(), 1);
                        OContext.setActualCallContext(this.m_threadCallContext, thread);
                    }
                    int n = this.m_broker.getServer().mapOutgoingServerId(this.m_threadCallContext.m_serverId);
                    this.m_encoder.encodeULong(this.m_head, this.m_rid);
                    this.m_encoder.encodeULong(this.m_head, n);
                    this.m_encoder.encodeULong(this.m_head, this.m_threadCallContext.m_threadId);
                    this.m_encoder.encodeCid(this.m_head, this.m_cid);
                    this.m_encoder.encodeUShort(this.m_head, this.m_signature);
                    this.m_encoder.encodeULong(this.m_head, this.m_flags);
                    this.marshalException();
                    this.m_head.setSize(this.m_head.getWritePos());
                    this.m_data.setSize(this.m_data.getWritePos());
                    this.m_broker.putRequest(this, -1);
                    if (bl3) {
                        OContext.setActualCallContext(OThreadCallContext.NULL_CONTEXT, thread);
                    }
                    if (!this.isReply() && this.m_systemException != null) {
                        OUnoSystemException oUnoSystemException = this.m_systemException;
                        this.m_systemException = null;
                        throw oUnoSystemException;
                    }
                }
                bl = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return bl;
    }

    protected boolean encodeSequence(OObjectHolder oObjectHolder, IMarshalFunction iMarshalFunction) {
        Object object;
        Class<?> clazz;
        int n = 127;
        try {
            clazz = (OArrayHolder)oObjectHolder;
            n = ((OArrayHolder)((Object)clazz)).getType();
        }
        catch (ClassCastException classCastException) {
            clazz = null;
            if (oObjectHolder.value == null) {
                if (iMarshalFunction == null) {
                    throw new OEncodeException();
                }
                try {
                    clazz = iMarshalFunction.getClass();
                    String string = clazz.getName();
                    int n2 = string.lastIndexOf(m_marshalPrefix);
                    object = String.valueOf(string.substring(0, n2 + 1)) + string.substring(n2 + m_marshalPrefix.length());
                    clazz = Class.forName((String)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new OEncodeException();
                }
            } else {
                clazz = oObjectHolder.value.getClass().getComponentType();
            }
            n = clazz.isArray() ? 19 : (XInterface.CLASS.isAssignableFrom(clazz) ? 20 : (Enum.CLASS.isAssignableFrom(clazz) ? 16 : 17));
        }
        int n3 = 0;
        switch (n) {
            case 2: {
                byte[] byArray = ((OByteArrayHolder)oObjectHolder).getValue();
                if (byArray != null) {
                    n3 = byArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeOctetArray(this.m_data, byArray, n3);
                return true;
            }
            case 3: {
                byte[] byArray = ((OByteArrayHolder)oObjectHolder).getValue();
                if (byArray != null) {
                    n3 = byArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeByteArray(this.m_data, byArray, n3);
                return true;
            }
            case 4: {
                char[] cArray = ((OCharArrayHolder)oObjectHolder).getValue();
                if (cArray != null) {
                    n3 = cArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeCharArray(this.m_data, cArray, n3);
                return true;
            }
            case 5: {
                int[] nArray = ((OIntArrayHolder)oObjectHolder).getValue();
                if (nArray != null) {
                    n3 = nArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeLongArray(this.m_data, nArray, n3);
                return true;
            }
            case 6: {
                int[] nArray = ((OIntArrayHolder)oObjectHolder).getValue();
                if (nArray != null) {
                    n3 = nArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULongArray(this.m_data, nArray, n3);
                return true;
            }
            case 7: {
                short[] sArray = ((OShortArrayHolder)oObjectHolder).getValue();
                if (sArray != null) {
                    n3 = sArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeShortArray(this.m_data, sArray, n3);
                return true;
            }
            case 8: {
                short[] sArray = ((OShortArrayHolder)oObjectHolder).getValue();
                if (sArray != null) {
                    n3 = sArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeUShortArray(this.m_data, sArray, n3);
                return true;
            }
            case 9: {
                int[] nArray = (int[])((OArrayHolder)oObjectHolder).value;
                if (nArray != null) {
                    n3 = nArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeLongArray(this.m_data, nArray, n3);
                return true;
            }
            case 10: {
                int[] nArray = ((OIntArrayHolder)oObjectHolder).getValue();
                if (nArray != null) {
                    n3 = nArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULongArray(this.m_data, nArray, n3);
                return true;
            }
            case 11: {
                long[] lArray = ((OLongArrayHolder)oObjectHolder).getValue();
                if (lArray != null) {
                    n3 = lArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeHyperArray(this.m_data, lArray, n3);
                return true;
            }
            case 12: {
                long[] lArray = ((OLongArrayHolder)oObjectHolder).getValue();
                if (lArray != null) {
                    n3 = lArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeUHyperArray(this.m_data, lArray, n3);
                return true;
            }
            case 13: {
                float[] fArray = ((OFloatArrayHolder)oObjectHolder).getValue();
                if (fArray != null) {
                    n3 = fArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeFloatArray(this.m_data, fArray, n3);
                return true;
            }
            case 14: {
                double[] dArray = ((ODoubleArrayHolder)oObjectHolder).getValue();
                if (dArray != null) {
                    n3 = dArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeDoubleArray(this.m_data, dArray, n3);
                return true;
            }
            case 15: {
                boolean[] blArray = ((OBooleanArrayHolder)oObjectHolder).getValue();
                if (blArray != null) {
                    n3 = blArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeBooleanArray(this.m_data, blArray, n3);
                return true;
            }
            case 16: {
                Object[] objectArray = (Object[])oObjectHolder.value;
                if (objectArray != null) {
                    n3 = objectArray.length;
                }
                object = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    object[n4] = ((Enum)objectArray[n4]).getValue();
                    ++n4;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeEnumArray(this.m_data, (int[])object, n3);
                return true;
            }
            case 18: {
                String[] stringArray = (String[])oObjectHolder.value;
                if (stringArray != null) {
                    n3 = stringArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeStringArray(this.m_data, stringArray, n3);
                return true;
            }
            case 17: {
                Object[] objectArray = (Object[])oObjectHolder.value;
                object = new OObjectHolder();
                if (objectArray != null) {
                    n3 = objectArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULong(this.m_data, n3);
                int n5 = 0;
                while (n5 < n3) {
                    ((OObjectHolder)object).value = objectArray[n5];
                    iMarshalFunction.marshal(this, (OObjectHolder)object, true);
                    ++n5;
                }
                return true;
            }
            case 20: {
                Object[] objectArray = (Object[])oObjectHolder.value;
                object = new OObjectHolder();
                if (objectArray != null) {
                    n3 = objectArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULong(this.m_data, n3);
                int n6 = 0;
                while (n6 < n3) {
                    ((OObjectHolder)object).value = objectArray[n6];
                    iMarshalFunction.marshal(this, (OObjectHolder)object, true);
                    ++n6;
                }
                return true;
            }
            case 21: {
                int[] nArray = (int[])oObjectHolder.value;
                if (nArray != null) {
                    n3 = nArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULong(this.m_data, n3);
                int n7 = 0;
                while (n7 < n3) {
                    this.m_encoder.encodeULong(this.m_data, nArray[n7]);
                    ++n7;
                }
                return true;
            }
            case 19: {
                Object[] objectArray = (Object[])oObjectHolder.value;
                if (objectArray != null) {
                    n3 = objectArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULong(this.m_data, n3);
                int n8 = 0;
                while (n8 < n3) {
                    object = new OConcreteArrayHolder(objectArray[n8]);
                    this.encodeSequence((OObjectHolder)object, iMarshalFunction);
                    ++n8;
                }
                return true;
            }
            case 22: {
                Object[] objectArray = (Object[])oObjectHolder.value;
                object = new OOAnyHolder();
                if (objectArray != null) {
                    n3 = objectArray.length;
                }
                this.m_encoder.encodeEnum(this.m_data, n);
                this.m_encoder.encodeULong(this.m_data, n3);
                this.m_encoder.encodeULong(this.m_data, n3);
                int n9 = 0;
                while (n9 < n3) {
                    ((OOAnyHolder)object).value = (OAny)objectArray[n9];
                    m_anyMarshalFunction.marshal(this, (OOAnyHolder)object, true);
                    ++n9;
                }
                return true;
            }
        }
        throw new OEncodeException();
    }

    protected boolean decodeSequence(OObjectHolder oObjectHolder, IMarshalFunction iMarshalFunction) {
        int n = this.m_decoder.decodeEnum(this.m_data);
        int n2 = this.m_decoder.decodeULong(this.m_data);
        switch (n) {
            case 2: {
                byte[] byArray = new byte[n2];
                this.m_decoder.decodeOctetArray(this.m_data, byArray);
                oObjectHolder.value = byArray;
                return true;
            }
            case 3: {
                byte[] byArray = new byte[n2];
                this.m_decoder.decodeByteArray(this.m_data, byArray);
                oObjectHolder.value = byArray;
                return true;
            }
            case 4: {
                byte[] byArray = new byte[n2];
                this.m_decoder.decodeCharArray(this.m_data, byArray);
                oObjectHolder.value = byArray;
                return true;
            }
            case 5: {
                int[] nArray = new int[n2];
                this.m_decoder.decodeLongArray(this.m_data, nArray);
                oObjectHolder.value = nArray;
                return true;
            }
            case 6: {
                int[] nArray = new int[n2];
                this.m_decoder.decodeULongArray(this.m_data, nArray);
                oObjectHolder.value = nArray;
                return true;
            }
            case 9: {
                int[] nArray = new int[n2];
                this.m_decoder.decodeLongArray(this.m_data, nArray);
                oObjectHolder.value = nArray;
                return true;
            }
            case 10: {
                int[] nArray = new int[n2];
                this.m_decoder.decodeULongArray(this.m_data, nArray);
                oObjectHolder.value = nArray;
                return true;
            }
            case 7: {
                short[] sArray = new short[n2];
                this.m_decoder.decodeShortArray(this.m_data, sArray);
                oObjectHolder.value = sArray;
                return true;
            }
            case 8: {
                short[] sArray = new short[n2];
                this.m_decoder.decodeUShortArray(this.m_data, sArray);
                oObjectHolder.value = sArray;
                return true;
            }
            case 11: {
                long[] lArray = new long[n2];
                this.m_decoder.decodeHyperArray(this.m_data, lArray);
                oObjectHolder.value = lArray;
                return true;
            }
            case 12: {
                long[] lArray = new long[n2];
                this.m_decoder.decodeUHyperArray(this.m_data, lArray);
                oObjectHolder.value = lArray;
                return true;
            }
            case 13: {
                float[] fArray = new float[n2];
                this.m_decoder.decodeFloatArray(this.m_data, fArray);
                oObjectHolder.value = fArray;
                return true;
            }
            case 14: {
                double[] dArray = new double[n2];
                this.m_decoder.decodeDoubleArray(this.m_data, dArray);
                oObjectHolder.value = dArray;
                return true;
            }
            case 15: {
                boolean[] blArray = new boolean[n2];
                this.m_decoder.decodeBooleanArray(this.m_data, blArray);
                oObjectHolder.value = blArray;
                return true;
            }
            case 16: {
                int[] nArray = new int[n2];
                this.m_decoder.decodeEnumArray(this.m_data, nArray);
                OObjectHolder oObjectHolder2 = new OObjectHolder();
                try {
                    int n3 = 0;
                    while (n3 < n2) {
                        oObjectHolder2.value = new Integer(nArray[n3]);
                        iMarshalFunction.marshal(this, oObjectHolder2, false);
                        if (n3 == 0) {
                            Class<?> clazz = oObjectHolder2.value.getClass();
                            oObjectHolder.value = Array.newInstance(clazz, n2);
                        }
                        Array.set(oObjectHolder.value, n3, oObjectHolder2.value);
                        ++n3;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new OUnoSystemException("error while unmarshal sequence of structs");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new OUnoSystemException("error while unmarshal sequence of structs");
                }
                return true;
            }
            case 18: {
                String[] stringArray = new String[n2];
                this.m_decoder.decodeStringArray(this.m_data, stringArray);
                oObjectHolder.value = stringArray;
                return true;
            }
            case 17: {
                boolean bl = false;
                OObjectHolder oObjectHolder3 = new OObjectHolder();
                n2 = this.m_decoder.decodeULong(this.m_data);
                try {
                    int n4 = 0;
                    while (n4 < n2) {
                        oObjectHolder3.value = null;
                        iMarshalFunction.marshal(this, oObjectHolder3, false);
                        if (!bl && n4 == 0) {
                            Class<?> clazz = oObjectHolder3.value.getClass();
                            oObjectHolder.value = Array.newInstance(clazz, n2);
                        }
                        Array.set(oObjectHolder.value, n4, oObjectHolder3.value);
                        ++n4;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new OUnoSystemException("error while unmarshal sequence of structs");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new OUnoSystemException("error while unmarshal sequence of structs");
                }
                return true;
            }
            case 20: {
                OObjectHolder oObjectHolder4;
                boolean bl = false;
                try {
                    oObjectHolder4 = (OObjectArrayHolder)oObjectHolder;
                    oObjectHolder4.createArray(n2);
                    bl = true;
                }
                catch (ClassCastException classCastException) {}
                oObjectHolder4 = new OObjectHolder();
                n2 = this.m_decoder.decodeULong(this.m_data);
                int n5 = 0;
                while (n5 < n2) {
                    iMarshalFunction.marshal(this, oObjectHolder4, false);
                    if (!bl && n5 == 0) {
                        Class<?> clazz = oObjectHolder4.value.getClass();
                        oObjectHolder.value = Array.newInstance(clazz, n2);
                    }
                    ((Object[])oObjectHolder.value)[n5] = oObjectHolder4.value;
                    ++n5;
                }
                return true;
            }
            case 21: {
                int[] nArray = new int[n2];
                n2 = this.m_decoder.decodeULong(this.m_data);
                int n6 = 0;
                while (n6 < n2) {
                    nArray[n6] = this.m_decoder.decodeULong(this.m_data);
                    ++n6;
                }
                return true;
            }
            case 19: {
                n2 = this.m_decoder.decodeULong(this.m_data);
                OConcreteArrayHolder oConcreteArrayHolder = new OConcreteArrayHolder();
                int n7 = 0;
                while (n7 < n2) {
                    this.decodeSequence(oConcreteArrayHolder, iMarshalFunction);
                    if (n7 == 0) {
                        oObjectHolder.value = oConcreteArrayHolder.createArrayOfThis(n2);
                    }
                    ((Object[])oObjectHolder.value)[n7] = oConcreteArrayHolder.value;
                    ++n7;
                }
                return true;
            }
            case 22: {
                OAny[] oAnyArray = new OAny[n2];
                OOAnyHolder oOAnyHolder = new OOAnyHolder();
                int n8 = 0;
                while (n8 < n2) {
                    oOAnyHolder.value = oAnyArray[n8];
                    m_anyMarshalFunction.marshal(this, oOAnyHolder, false);
                    ++n8;
                }
                oObjectHolder.value = oAnyArray;
                return true;
            }
        }
        throw new ODecodeException();
    }

    protected boolean sysDispatch(short s) {
        switch (s) {
            case 1: {
                OStringHolder oStringHolder = new OStringHolder();
                OUikHolder oUikHolder = new OUikHolder();
                OCidHolder oCidHolder = new OCidHolder();
                OBooleanHolder oBooleanHolder = new OBooleanHolder();
                OXInterfaceHolder oXInterfaceHolder = new OXInterfaceHolder();
                Object[] objectArray = new Object[]{oStringHolder, oUikHolder, new OObjectHolder(oCidHolder), oBooleanHolder};
                this.unmarshalArguments(sysDispatchTypes, objectArray, 1);
                oBooleanHolder.value = this.m_broker.getServer().createInstance(oStringHolder.value, oUikHolder.getValue(), oXInterfaceHolder);
                oCidHolder.value = oBooleanHolder.value ? OContext.createStubContext(this.m_broker, oXInterfaceHolder.getValue(), oUikHolder.getValue().getIFactory()).getCid() : OCid.invalidCid;
                this.marshalArguments(sysDispatchTypes, objectArray, 2);
                return this.execute();
            }
            case 2: {
                OIntHolder oIntHolder = new OIntHolder();
                Object[] objectArray = new Object[]{oIntHolder};
                this.unmarshalArguments(OServerStub.queryServerIdTypes, objectArray, 1);
                oIntHolder.value = this.m_broker.getServer().getServerId();
                this.marshalArguments(OServerStub.queryServerIdTypes, objectArray, 2);
                return this.execute();
            }
        }
        return false;
    }

    public OCid getCid() {
        return this.m_cid;
    }

    public ORequestBroker getBroker() {
        return this.m_broker;
    }

    protected boolean marshalException() {
        boolean bl = false;
        Exception exception = null;
        IMarshalFunction iMarshalFunction = null;
        String string = null;
        String string2 = null;
        if (this.m_systemException != null) {
            bl = true;
            exception = this.m_systemException;
            string = this.m_systemException.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                string2 = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            try {
                iMarshalFunction = (IMarshalFunction)exception.getClass().getField("m_marshalFunction").get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                iMarshalFunction = OUnoSystemException.m_marshalFunction;
            }
            catch (IllegalAccessException illegalAccessException) {
                iMarshalFunction = OUnoSystemException.m_marshalFunction;
            }
            this.m_systemException = null;
        } else if (this.m_userException != null) {
            bl = true;
            exception = this.m_userException;
            string = this.m_userException.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                string2 = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            try {
                iMarshalFunction = (IMarshalFunction)exception.getClass().getField("m_marshalFunction").get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                iMarshalFunction = OUnoUserException.m_marshalFunction;
            }
            catch (IllegalAccessException illegalAccessException) {
                iMarshalFunction = OUnoUserException.m_marshalFunction;
            }
            this.m_userException = null;
        }
        if (bl) {
            this.m_encoder.encodeBoolean(this.m_head, true);
            this.m_encoder.encodeString(this.m_head, string);
            this.m_encoder.encodeString(this.m_head, string2);
            iMarshalFunction.marshal(this, new OObjectHolder(exception), true);
        } else {
            this.m_encoder.encodeBoolean(this.m_head, false);
        }
        return bl;
    }

    protected boolean unmarshalException() {
        boolean bl = false;
        bl = this.m_decoder.decodeBoolean(this.m_data);
        if (bl) {
            String string = null;
            String string2 = null;
            string = this.m_decoder.decodeString(this.m_data);
            string2 = this.m_decoder.decodeString(this.m_data);
            if (string2 != null && string2.length() > 0) {
                string = String.valueOf(string2) + "." + string;
            }
            IMarshalFunction iMarshalFunction = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                iMarshalFunction = (IMarshalFunction)clazz.getField("m_marshalFunction").get(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (iMarshalFunction == null) {
                this.m_systemException = new OUnoSystemException("unknown exception");
            } else {
                OObjectHolder oObjectHolder = new OObjectHolder();
                iMarshalFunction.marshal(this, oObjectHolder, false);
                if (OUnoSystemException.CLASS.isAssignableFrom(clazz)) {
                    this.m_systemException = (OUnoSystemException)oObjectHolder.value;
                } else if (OUnoUserException.CLASS.isAssignableFrom(clazz)) {
                    this.m_userException = (OUnoUserException)oObjectHolder.value;
                } else {
                    this.m_systemException = new OUnoSystemException("unknown exception");
                }
            }
        }
        return bl;
    }

    public OThreadCallContext getThreadCallContext() {
        return this.m_threadCallContext;
    }

    public void setThreadCallContext(OThreadCallContext oThreadCallContext) {
        this.m_threadCallContext = oThreadCallContext;
    }
}

