/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.IConnectionCallback;
import stardiv.uno.sys.OUrl;
import stardiv.uno.sys.marshal.OBuffer;
import stardiv.uno.sys.marshal.OPacket;

public class ONativeConnection
implements IConnection {
    IConnectionCallback m_callback = null;
    ONativeOutputStream m_outputStream;
    ONativeInputStream m_inputStream;
    ONativeImpl m_impl = new ONativeImpl();
    int m_status = -1;
    OUrl m_localUrl = null;
    OUrl m_remoteUrl = null;
    OPacket m_buffer;
    String m_nativeModule;

    public ONativeConnection() {
        this.m_nativeModule = "uno514mi";
        this.m_outputStream = new ONativeOutputStream();
        this.m_inputStream = new ONativeInputStream();
        this.m_buffer = new OPacket(0);
        try {
            Runtime.getRuntime().load(this.m_nativeModule);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace(System.out);
            System.out.println(unsatisfiedLinkError);
            return;
        }
    }

    public ONativeConnection(String string) {
        this.m_nativeModule = string;
        this.m_outputStream = new ONativeOutputStream();
        this.m_inputStream = new ONativeInputStream();
        this.m_buffer = new OPacket(0);
        try {
            Runtime.getRuntime().load(this.m_nativeModule);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace(System.out);
            System.out.println(unsatisfiedLinkError);
            return;
        }
    }

    public boolean open(String string, IConnectionCallback iConnectionCallback) {
        boolean bl = false;
        int n = this.m_status;
        if (n != 2) {
            this.m_callback = iConnectionCallback;
            this.m_status = 2;
            bl = this.m_impl.openImpl(string, this.m_outputStream);
            if (!bl) {
                this.m_status = n;
            } else {
                this.m_localUrl = new OUrl(string, "", "native://", "");
                this.m_remoteUrl = new OUrl(string, "", "native://", "");
            }
        }
        return bl;
    }

    public void close() {
        this.m_impl.closeImpl();
        OPacket oPacket = this.m_buffer;
        synchronized (oPacket) {
            this.m_status = 4;
            this.m_buffer.notifyAll();
            return;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        OPacket oPacket = this.m_buffer;
        synchronized (oPacket) {
            this.m_status = n;
            this.m_buffer.notifyAll();
            return;
        }
    }

    public OUrl getLocalUrl() {
        return this.m_localUrl;
    }

    public OUrl getRemoteUrl() {
        return this.m_remoteUrl;
    }

    public boolean registerCallback(IConnectionCallback iConnectionCallback) {
        this.m_callback = iConnectionCallback;
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_impl;
    }

    public InputStream getInputStream() throws IOException {
        return this.m_inputStream;
    }

    protected class ONativeImpl
    extends OutputStream {
        protected long nativeImpl = 0L;

        public ONativeImpl() {
            ONativeConnection.this = ONativeConnection.this;
        }

        protected void finalize() {
            try {
                this.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        public native boolean openImpl(String var1, OutputStream var2);

        public native int writeImpl(byte[] var1, int var2, int var3);

        public native void closeImpl();

        public void close() throws IOException {
            this.closeImpl();
        }

        public void write(byte[] byArray) throws IOException {
            if (this.writeImpl(byArray, 0, byArray.length) != byArray.length) {
                throw new IOException();
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.writeImpl(byArray, n, n2) != n2) {
                throw new IOException();
            }
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            if (this.writeImpl(byArray, 0, 1) != 1) {
                throw new IOException();
            }
        }
    }

    protected class ONativeOutputStream
    extends OutputStream {
        public void close() throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
            OPacket oPacket = ONativeConnection.this.m_buffer;
            synchronized (oPacket) {
                ONativeConnection.this.m_buffer.pushBack(new OBuffer(byArray, 0, byArray.length));
                ONativeConnection.this.m_buffer.notifyAll();
            }
            ONativeConnection.this.m_callback.dataRecieved(byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            OPacket oPacket = ONativeConnection.this.m_buffer;
            synchronized (oPacket) {
                ONativeConnection.this.m_buffer.pushBack(new OBuffer(byArray, n, byArray.length));
                ONativeConnection.this.m_buffer.notifyAll();
            }
            ONativeConnection.this.m_callback.dataRecieved(n2);
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            OPacket oPacket = ONativeConnection.this.m_buffer;
            synchronized (oPacket) {
                ONativeConnection.this.m_buffer.pushBack(new OBuffer(byArray, 0, 1));
                ONativeConnection.this.m_buffer.notifyAll();
            }
            ONativeConnection.this.m_callback.dataRecieved(1);
        }

        protected ONativeOutputStream() {
            ONativeConnection.this = ONativeConnection.this;
        }
    }

    protected class ONativeInputStream
    extends InputStream {
        public int available() throws IOException {
            int n = 0;
            OPacket oPacket = ONativeConnection.this.m_buffer;
            synchronized (oPacket) {
                n = ONativeConnection.this.m_buffer.getLength();
            }
            return n;
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            this.read(byArray, 0, 1);
            return byArray[0];
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.read(byArray, 0, byArray.length);
            return n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            OPacket oPacket = ONativeConnection.this.m_buffer;
            synchronized (oPacket) {
                while (n3 != n2 && (ONativeConnection.this.m_status == 2 || ONativeConnection.this.m_status == 1)) {
                    OBuffer oBuffer = ONativeConnection.this.m_buffer.popFront();
                    if (oBuffer == null) {
                        try {
                            ONativeConnection.this.m_buffer.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    int n4 = oBuffer.getSize() - oBuffer.getReadPos();
                    if (n4 > n2) {
                        n4 = n2;
                    }
                    System.arraycopy(oBuffer.getData(), oBuffer.getReadPos(), byArray, n, n4);
                    oBuffer.incReadPos(n4);
                    if (oBuffer.getReadPos() < oBuffer.getSize()) {
                        ONativeConnection.this.m_buffer.pushFront(oBuffer);
                    }
                    n3 += n4;
                }
            }
            if (n3 != n2) {
                throw new IOException();
            }
            return n3;
        }

        protected ONativeInputStream() {
            ONativeConnection.this = ONativeConnection.this;
        }
    }
}

