/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.marshal;

public class OBuffer {
    protected static OBuffer[] m_bufferHeap = new OBuffer[256];
    protected static Object m_bufferHeapLock = new Object();
    protected static int m_bufferHeapTop = -1;
    protected int m_readPos;
    protected int m_writePos;
    protected int m_size;
    protected byte[] m_buffer;
    public static final int INITIALSIZE = 128;

    public OBuffer() {
        this.m_buffer = new byte[128];
        this.m_size = 0;
        this.m_readPos = 0;
        this.m_writePos = 0;
    }

    public OBuffer(int n) {
        this.m_buffer = new byte[Math.max(128, n)];
        this.m_size = n;
        this.m_readPos = 0;
        this.m_writePos = 0;
    }

    public OBuffer(byte[] byArray, int n, int n2) {
        this.m_buffer = new byte[Math.max(128, n2)];
        this.m_size = n2;
        this.m_readPos = 0;
        this.m_writePos = 0;
        System.arraycopy(byArray, n, this.m_buffer, 0, this.m_size);
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.setSize(n2);
        this.m_readPos = 0;
        this.m_writePos = 0;
        System.arraycopy(byArray, n, this.m_buffer, 0, this.m_size);
    }

    public byte[] getData() {
        return this.m_buffer;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getWritePos() {
        return this.m_writePos;
    }

    public int getReadPos() {
        return this.m_readPos;
    }

    public void reset() {
        this.m_readPos = 0;
        this.m_writePos = 0;
    }

    public void setSize(int n) {
        if (n > this.m_buffer.length) {
            byte[] byArray = new byte[Math.max(n, this.m_buffer.length * 2)];
            System.arraycopy(this.m_buffer, 0, byArray, 0, this.m_size);
            this.m_buffer = byArray;
        } else if (n < this.m_size) {
            this.m_readPos = Math.min(this.m_readPos, this.m_size - 1);
            this.m_writePos = Math.min(this.m_writePos, this.m_size - 1);
        }
        this.m_size = n;
    }

    public void ensureFreeSpace(int n) {
        int n2 = n + this.m_writePos;
        if (n2 > this.m_buffer.length) {
            byte[] byArray = new byte[Math.max(n2, this.m_buffer.length * 2)];
            System.arraycopy(this.m_buffer, 0, byArray, 0, this.m_size);
            this.m_buffer = byArray;
        }
        this.m_size = Math.max(n2, this.m_size);
    }

    public short read() {
        return (short)(this.m_buffer[this.m_readPos++] & 0xFF);
    }

    public void incReadPos(int n) {
        this.m_readPos += n;
    }

    public void incWritePos(int n) {
        this.m_writePos += n;
    }

    public void write(byte by) {
        this.ensureFreeSpace(1);
        this.m_buffer[this.m_writePos++] = by;
    }

    public void write(byte[] byArray) {
        this.ensureFreeSpace(byArray.length);
        System.arraycopy(byArray, 0, this.m_buffer, this.m_writePos, byArray.length);
        this.m_writePos += byArray.length;
    }

    public void write(byte[] byArray, int n) {
        this.ensureFreeSpace(n);
        System.arraycopy(byArray, 0, this.m_buffer, this.m_writePos, n);
        this.m_writePos += n;
    }
}

