/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.marshal;

import stardiv.uno.sys.marshal.OBuffer;

public class OBufferHeap {
    protected OBuffer[] m_bufferHeap = new OBuffer[1000];
    protected int m_bufferHeapTop = -1;

    public synchronized OBuffer getBuffer() {
        if (this.m_bufferHeapTop < 0) {
            return new OBuffer();
        }
        OBuffer oBuffer = this.m_bufferHeap[this.m_bufferHeapTop];
        this.m_bufferHeap[this.m_bufferHeapTop--] = null;
        oBuffer.setSize(0);
        oBuffer.m_readPos = 0;
        oBuffer.m_writePos = 0;
        return oBuffer;
    }

    public synchronized OBuffer getBuffer(int n) {
        if (this.m_bufferHeapTop < 0 || n > 128) {
            return new OBuffer(n);
        }
        OBuffer oBuffer = this.m_bufferHeap[this.m_bufferHeapTop];
        this.m_bufferHeap[this.m_bufferHeapTop--] = null;
        oBuffer.setSize(n);
        oBuffer.m_readPos = 0;
        oBuffer.m_writePos = 0;
        return oBuffer;
    }

    public synchronized OBuffer getBuffer(byte[] byArray, int n, int n2) {
        if (this.m_bufferHeapTop < 0 || n2 > 128) {
            return new OBuffer(byArray, n, n2);
        }
        OBuffer oBuffer = this.m_bufferHeap[this.m_bufferHeapTop];
        this.m_bufferHeap[this.m_bufferHeapTop--] = null;
        oBuffer.setSize(n2);
        oBuffer.m_readPos = 0;
        oBuffer.m_writePos = 0;
        System.arraycopy(byArray, n, oBuffer.m_buffer, 0, oBuffer.m_size);
        return oBuffer;
    }

    public synchronized void putBuffer(OBuffer oBuffer) {
        if (oBuffer.getData().length <= 128 && this.m_bufferHeapTop < this.m_bufferHeap.length - 1) {
            this.m_bufferHeap[++this.m_bufferHeapTop] = oBuffer;
        }
    }
}

