/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.marshal;

import stardiv.uno.OServer;
import stardiv.uno.sys.OCid;
import stardiv.uno.sys.marshal.OBuffer;

public class OCdrEncoder {
    protected byte m_byteOrder;
    protected OServer m_server;

    public OCdrEncoder(OServer oServer) {
        this.m_server = oServer;
        this.m_byteOrder = 1;
    }

    public OCdrEncoder(OServer oServer, byte by) {
        this.m_server = oServer;
        this.m_byteOrder = by;
    }

    public void encodeShort(OBuffer oBuffer, short s) {
        oBuffer.ensureFreeSpace(3);
        oBuffer.write((byte)7);
        oBuffer.write((byte)(s >> 8 & 0xFF));
        oBuffer.write((byte)(s & 0xFF));
    }

    public void encodeLong(OBuffer oBuffer, int n) {
        oBuffer.ensureFreeSpace(5);
        oBuffer.write((byte)9);
        oBuffer.write((byte)(n >> 24 & 0xFF));
        oBuffer.write((byte)(n >> 16 & 0xFF));
        oBuffer.write((byte)(n >> 8 & 0xFF));
        oBuffer.write((byte)(n & 0xFF));
    }

    public void encodeHyper(OBuffer oBuffer, long l) {
        oBuffer.ensureFreeSpace(9);
        oBuffer.write((byte)11);
        oBuffer.write((byte)(l >> 56 & 0xFFL));
        oBuffer.write((byte)(l >> 48 & 0xFFL));
        oBuffer.write((byte)(l >> 40 & 0xFFL));
        oBuffer.write((byte)(l >> 32 & 0xFFL));
        oBuffer.write((byte)(l >> 24 & 0xFFL));
        oBuffer.write((byte)(l >> 16 & 0xFFL));
        oBuffer.write((byte)(l >> 8 & 0xFFL));
        oBuffer.write((byte)(l & 0xFFL));
    }

    public void encodeUShort(OBuffer oBuffer, short s) {
        oBuffer.ensureFreeSpace(3);
        oBuffer.write((byte)8);
        oBuffer.write((byte)(s >> 8 & 0xFF));
        oBuffer.write((byte)(s & 0xFF));
    }

    public void encodeULong(OBuffer oBuffer, int n) {
        oBuffer.ensureFreeSpace(5);
        oBuffer.write((byte)10);
        oBuffer.write((byte)(n >> 24 & 0xFF));
        oBuffer.write((byte)(n >> 16 & 0xFF));
        oBuffer.write((byte)(n >> 8 & 0xFF));
        oBuffer.write((byte)(n & 0xFF));
    }

    public void encodeUHyper(OBuffer oBuffer, long l) {
        oBuffer.ensureFreeSpace(9);
        oBuffer.write((byte)12);
        oBuffer.write((byte)(l >> 56 & 0xFFL));
        oBuffer.write((byte)(l >> 48 & 0xFFL));
        oBuffer.write((byte)(l >> 40 & 0xFFL));
        oBuffer.write((byte)(l >> 32 & 0xFFL));
        oBuffer.write((byte)(l >> 24 & 0xFFL));
        oBuffer.write((byte)(l >> 16 & 0xFFL));
        oBuffer.write((byte)(l >> 8 & 0xFFL));
        oBuffer.write((byte)(l & 0xFFL));
    }

    public void encodeFloat(OBuffer oBuffer, float f) {
        int n = Float.floatToIntBits(f);
        oBuffer.ensureFreeSpace(5);
        oBuffer.write((byte)13);
        oBuffer.write((byte)(n >> 24 & 0xFF));
        oBuffer.write((byte)(n >> 16 & 0xFF));
        oBuffer.write((byte)(n >> 8 & 0xFF));
        oBuffer.write((byte)(n & 0xFF));
    }

    public void encodeDouble(OBuffer oBuffer, double d) {
        long l = Double.doubleToLongBits(d);
        oBuffer.ensureFreeSpace(9);
        oBuffer.write((byte)14);
        oBuffer.write((byte)(l >> 56 & 0xFFL));
        oBuffer.write((byte)(l >> 48 & 0xFFL));
        oBuffer.write((byte)(l >> 40 & 0xFFL));
        oBuffer.write((byte)(l >> 32 & 0xFFL));
        oBuffer.write((byte)(l >> 24 & 0xFFL));
        oBuffer.write((byte)(l >> 16 & 0xFFL));
        oBuffer.write((byte)(l >> 8 & 0xFFL));
        oBuffer.write((byte)(l & 0xFFL));
    }

    public void encodeChar(OBuffer oBuffer, char c) {
        oBuffer.ensureFreeSpace(2);
        oBuffer.write((byte)4);
        oBuffer.write((byte)c);
    }

    public void encodeByte(OBuffer oBuffer, byte by) {
        oBuffer.ensureFreeSpace(2);
        oBuffer.write((byte)3);
        oBuffer.write(by);
    }

    public void encodeString(OBuffer oBuffer, String string) {
        short s = 0;
        if (string != null) {
            s = (short)string.length();
        }
        oBuffer.ensureFreeSpace(3 + s * 2);
        oBuffer.write((byte)18);
        oBuffer.write((byte)(s >> 8 & 0xFF));
        oBuffer.write((byte)(s & 0xFF));
        short s2 = 0;
        while (s2 < s) {
            char c = string.charAt(s2);
            oBuffer.write((byte)(c >> 8 & 0xFF));
            oBuffer.write((byte)(c & 0xFF));
            s2 = (short)(s2 + 1);
        }
    }

    public void encodeBoolean(OBuffer oBuffer, boolean bl) {
        oBuffer.ensureFreeSpace(2);
        oBuffer.write((byte)15);
        if (bl) {
            oBuffer.write((byte)1);
            return;
        }
        oBuffer.write((byte)0);
    }

    public void encodeEnum(OBuffer oBuffer, int n) {
        oBuffer.ensureFreeSpace(5);
        oBuffer.write((byte)16);
        oBuffer.write((byte)(n >> 8 & 0xFF));
        oBuffer.write((byte)(n & 0xFF));
    }

    public void encodeOctet(OBuffer oBuffer, byte by) {
        oBuffer.ensureFreeSpace(2);
        oBuffer.write((byte)2);
        oBuffer.write(by);
    }

    public void encodeCid(OBuffer oBuffer, OCid oCid) {
        oBuffer.ensureFreeSpace(1);
        oBuffer.write((byte)21);
        this.encodeULong(oBuffer, oCid.m_oid);
        this.encodeByte(oBuffer, oCid.m_sidLen);
        if (oCid.m_sidLen == 1) {
            this.encodeULong(oBuffer, this.m_server.mapOutgoingServerId(oCid.m_shortSid));
            return;
        }
        this.encodeULongArray(oBuffer, oCid.m_longSid, oCid.m_sidLen);
    }

    public void encodeShortArray(OBuffer oBuffer, short[] sArray, int n) {
        this.encodeEnum(oBuffer, 134);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 2);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(sArray[n2] >> 8 & 0xFF));
            oBuffer.write((byte)(sArray[n2] & 0xFF));
            ++n2;
        }
    }

    public void encodeLongArray(OBuffer oBuffer, int[] nArray, int n) {
        this.encodeEnum(oBuffer, 136);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 4);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(nArray[n2] >> 24 & 0xFF));
            oBuffer.write((byte)(nArray[n2] >> 16 & 0xFF));
            oBuffer.write((byte)(nArray[n2] >> 8 & 0xFF));
            oBuffer.write((byte)(nArray[n2] & 0xFF));
            ++n2;
        }
    }

    public void encodeHyperArray(OBuffer oBuffer, long[] lArray, int n) {
        this.encodeEnum(oBuffer, 138);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 8);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(lArray[n2] >> 56 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 48 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 40 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 32 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 24 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 16 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 8 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] & 0xFFL));
            ++n2;
        }
    }

    public void encodeUShortArray(OBuffer oBuffer, short[] sArray, int n) {
        this.encodeEnum(oBuffer, 135);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 2);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(sArray[n2] >> 8 & 0xFF));
            oBuffer.write((byte)(sArray[n2] & 0xFF));
            ++n2;
        }
    }

    public void encodeULongArray(OBuffer oBuffer, int[] nArray, int n) {
        this.encodeEnum(oBuffer, 137);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 4);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(nArray[n2] >> 24 & 0xFF));
            oBuffer.write((byte)(nArray[n2] >> 16 & 0xFF));
            oBuffer.write((byte)(nArray[n2] >> 8 & 0xFF));
            oBuffer.write((byte)(nArray[n2] & 0xFF));
            ++n2;
        }
    }

    public void encodeUHyperArray(OBuffer oBuffer, long[] lArray, int n) {
        this.encodeEnum(oBuffer, 139);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 8);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(lArray[n2] >> 56 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 48 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 40 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 32 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 24 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 16 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] >> 8 & 0xFFL));
            oBuffer.write((byte)(lArray[n2] & 0xFFL));
            ++n2;
        }
    }

    public void encodeFloatArray(OBuffer oBuffer, float[] fArray, int n) {
        this.encodeEnum(oBuffer, 140);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 4);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Float.floatToIntBits(fArray[n2]);
            oBuffer.write((byte)(n3 >> 24 & 0xFF));
            oBuffer.write((byte)(n3 >> 16 & 0xFF));
            oBuffer.write((byte)(n3 >> 8 & 0xFF));
            oBuffer.write((byte)(n3 & 0xFF));
            ++n2;
        }
    }

    public void encodeDoubleArray(OBuffer oBuffer, double[] dArray, int n) {
        this.encodeEnum(oBuffer, 141);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 8);
        int n2 = 0;
        while (n2 < n) {
            long l = Double.doubleToLongBits(dArray[n2]);
            oBuffer.write((byte)(l >> 56 & 0xFFL));
            oBuffer.write((byte)(l >> 48 & 0xFFL));
            oBuffer.write((byte)(l >> 40 & 0xFFL));
            oBuffer.write((byte)(l >> 32 & 0xFFL));
            oBuffer.write((byte)(l >> 24 & 0xFFL));
            oBuffer.write((byte)(l >> 16 & 0xFFL));
            oBuffer.write((byte)(l >> 8 & 0xFFL));
            oBuffer.write((byte)(l & 0xFFL));
            ++n2;
        }
    }

    public void encodeCharArray(OBuffer oBuffer, char[] cArray, int n) {
        this.encodeEnum(oBuffer, 131);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)cArray[n2]);
            ++n2;
        }
    }

    public void encodeByteArray(OBuffer oBuffer, byte[] byArray, int n) {
        this.encodeEnum(oBuffer, 130);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n);
        if (n > 0) {
            System.arraycopy(byArray, 0, oBuffer.getData(), oBuffer.getWritePos(), n);
        }
        oBuffer.incWritePos(n);
    }

    public void encodeStringArray(OBuffer oBuffer, String[] stringArray, int n) {
        this.encodeEnum(oBuffer, 145);
        this.encodeULong(oBuffer, n);
        int n2 = 0;
        while (n2 < n) {
            short s = (short)stringArray[n2].length();
            oBuffer.ensureFreeSpace(2 + s * 2);
            oBuffer.write((byte)(s >> 8 & 0xFF));
            oBuffer.write((byte)(s & 0xFF));
            short s2 = 0;
            while (s2 < s) {
                char c = stringArray[n2].charAt(s2);
                oBuffer.write((byte)(c >> 8 & 0xFF));
                oBuffer.write((byte)(c & 0xFF));
                s2 = (short)(s2 + 1);
            }
            ++n2;
        }
    }

    public void encodeBooleanArray(OBuffer oBuffer, boolean[] blArray, int n) {
        this.encodeEnum(oBuffer, 142);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n);
        int n2 = 0;
        while (n2 < n) {
            if (blArray[n2]) {
                oBuffer.write((byte)1);
            } else {
                oBuffer.write((byte)0);
            }
            ++n2;
        }
    }

    public void encodeEnumArray(OBuffer oBuffer, int[] nArray, int n) {
        this.encodeEnum(oBuffer, 143);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n * 2);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write((byte)(nArray[n2] >> 8 & 0xFF));
            oBuffer.write((byte)(nArray[n2] & 0xFF));
            ++n2;
        }
    }

    public void encodeOctetArray(OBuffer oBuffer, byte[] byArray, int n) {
        this.encodeEnum(oBuffer, 129);
        this.encodeULong(oBuffer, n);
        oBuffer.ensureFreeSpace(n);
        int n2 = 0;
        while (n2 < n) {
            oBuffer.write(byArray[n2]);
            ++n2;
        }
    }

    protected void finalize() {
    }
}

