/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.marshal;

import stardiv.uno.sys.marshal.OBuffer;

public class OPacket {
    public static final byte PacketTypeNormal = 0;
    public static final byte PacketTypeControl = 1;
    public static final byte PacketTypeData = 2;
    public static final byte PacketTypePriority = -128;
    public static final byte PacketTypeTerminate = 4;
    public static final byte PacketTypeUnknown = -1;
    protected byte m_type;
    public int m_front;
    public int m_back;
    public OBuffer[] m_buffers;

    public OPacket(byte by, OBuffer oBuffer) {
        this.m_buffers = new OBuffer[16];
        this.m_buffers[8] = oBuffer;
        this.m_front = 8;
        this.m_back = 8;
        this.m_type = by;
    }

    public OPacket(byte by) {
        this.m_front = -1;
        this.m_back = -1;
        this.m_type = by;
        this.m_buffers = null;
    }

    public OPacket(byte by, OBuffer[] oBufferArray) {
        this.m_type = by;
        this.m_buffers = oBufferArray;
        if (this.m_buffers == null) {
            this.m_front = -1;
            this.m_back = -1;
            return;
        }
        this.m_front = 0;
        this.m_back = this.m_buffers.length - 1;
    }

    public byte getType() {
        return this.m_type;
    }

    public int getLength() {
        if (this.m_buffers == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.m_front;
        while (n2 <= this.m_back) {
            n += this.m_buffers[n2].getSize();
            ++n2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.m_buffers == null || this.m_front == -1;
    }

    public void pushFront(OBuffer oBuffer) {
        if (this.m_buffers == null) {
            this.m_buffers = new OBuffer[16];
            this.m_buffers[8] = oBuffer;
            this.m_front = 8;
            this.m_back = 8;
            return;
        }
        if (this.m_front == -1) {
            this.m_front = this.m_back = this.m_buffers.length / 2;
            this.m_buffers[this.m_front] = oBuffer;
            return;
        }
        if (this.m_front == 0) {
            int n = this.m_back + 1;
            OBuffer[] oBufferArray = this.m_buffers.length >= n * 2 ? this.m_buffers : new OBuffer[n * 2];
            System.arraycopy(this.m_buffers, this.m_front, this.m_buffers, n, n);
            this.m_front += n;
            this.m_back += n;
            this.m_buffers = oBufferArray;
            this.m_buffers[--this.m_front] = oBuffer;
            return;
        }
        this.m_buffers[--this.m_front] = oBuffer;
    }

    public void pushBack(OBuffer oBuffer) {
        if (this.m_buffers == null) {
            this.m_buffers = new OBuffer[16];
            this.m_buffers[8] = oBuffer;
            this.m_front = 8;
            this.m_back = 8;
            return;
        }
        if (this.m_back == -1) {
            this.m_front = this.m_back = this.m_buffers.length / 2;
            this.m_buffers[this.m_front] = oBuffer;
            return;
        }
        if (this.m_back == this.m_buffers.length - 1) {
            int n = this.m_back + 1 - this.m_front;
            OBuffer[] oBufferArray = this.m_buffers.length >= n * 2 ? this.m_buffers : new OBuffer[n * 2];
            System.arraycopy(this.m_buffers, this.m_front, oBufferArray, 0, n);
            this.m_front = 0;
            this.m_back = n - 1;
            this.m_buffers = oBufferArray;
            this.m_buffers[++this.m_back] = oBuffer;
            return;
        }
        this.m_buffers[++this.m_back] = oBuffer;
    }

    public OBuffer popFront() {
        if (this.m_buffers == null || this.m_front == -1) {
            return null;
        }
        OBuffer oBuffer = this.m_buffers[this.m_front];
        this.m_buffers[this.m_front++] = null;
        if (this.m_front > this.m_back) {
            this.m_front = -1;
            this.m_back = -1;
        }
        return oBuffer;
    }

    public OBuffer popBack() {
        if (this.m_buffers == null || this.m_back == -1) {
            return null;
        }
        OBuffer oBuffer = this.m_buffers[this.m_back];
        this.m_buffers[this.m_back--] = null;
        if (this.m_back < this.m_front) {
            this.m_front = -1;
            this.m_back = -1;
        }
        return oBuffer;
    }

    protected void finalize() {
    }
}

