/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.server;

import stardiv.uno.IExitListener;
import stardiv.uno.OEnvironment;
import stardiv.uno.OServer;
import stardiv.uno.OUikHolder;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.Uik;
import stardiv.uno.XFactory;
import stardiv.uno.holder.OBooleanHolder;
import stardiv.uno.holder.OCidHolder;
import stardiv.uno.holder.OObjectHolder;
import stardiv.uno.holder.OStringHolder;
import stardiv.uno.sys.OChannel;
import stardiv.uno.sys.OContext;
import stardiv.uno.sys.ODynMarshalXInterface;
import stardiv.uno.sys.OMarshalType;
import stardiv.uno.sys.ORequest;
import stardiv.uno.sys.ORequestBroker;
import stardiv.uno.sys.OSemaphore;
import stardiv.uno.sys.OUrl;

public class OServerProxy
extends OServer {
    protected OSemaphore m_requestSem;
    protected OChannel m_channel;
    protected ORequestBroker m_requestBroker;
    protected int m_myServerId;
    protected static ODynMarshalXInterface m_dynMarshal = new ODynMarshalXInterface();
    protected static OMarshalType[] types = new OMarshalType[]{new OMarshalType(18, 1, null), new OMarshalType(17, 1, Uik.m_marshalFunction), new OMarshalType(20, 2, m_dynMarshal), new OMarshalType(15, 2, null)};

    public OServerProxy(String string, OEnvironment oEnvironment, OSemaphore oSemaphore) {
        super(string, oEnvironment);
        this.m_requestSem = oSemaphore;
        this.m_myServerId = OContext.getNewServerId();
    }

    public boolean isDisconnectAble() {
        return false;
    }

    public boolean isConnected() {
        if (this.m_requestBroker == null) {
            return false;
        }
        return this.m_requestBroker.isConnected();
    }

    public boolean connect() {
        boolean bl = false;
        this.m_channel = new OChannel(this);
        OUrl oUrl = new OUrl(this.m_url);
        if (oUrl.getProtocol().equals("native")) {
            this.m_requestBroker = new ORequestBroker(this, this.m_channel, this.m_requestSem, true);
            bl = this.m_channel.connect(oUrl, this.m_requestBroker.getConnectionCallback());
        } else if (this.m_channel.connect(oUrl, null)) {
            this.m_requestBroker = new ORequestBroker(this, this.m_channel, this.m_requestSem, false);
            bl = true;
        }
        if (!bl) {
            this.m_channel.disconnect();
            this.m_channel = null;
            this.m_requestBroker = null;
        }
        return bl;
    }

    public boolean disconnect() {
        block5: {
            try {
                if (this.m_requestBroker != null) {
                    OContext.invalidateContexts(this.m_requestBroker);
                }
                if (this.m_channel != null) {
                    this.m_channel.disconnect();
                    this.m_channel = null;
                }
                if (this.m_requestBroker != null) {
                    this.m_requestBroker.destroy();
                    this.m_requestBroker = null;
                }
            }
            catch (OUnoSystemException oUnoSystemException) {
                IExitListener iExitListener = this.m_environ.getExitListener();
                if (iExitListener == null) break block5;
                iExitListener.exit(0);
            }
        }
        return true;
    }

    public void enterBlockMode(int n) {
        if (this.m_channel != null) {
            this.m_channel.enterBlockMode(n);
        }
    }

    public void leaveBlockMode() {
        if (this.m_channel != null) {
            this.m_channel.leaveBlockMode();
        }
    }

    public void flushBlock() {
        if (this.m_channel != null) {
            this.m_channel.flushBlock();
        }
    }

    public boolean dispatch(int n) {
        if (this.m_requestBroker == null) {
            return false;
        }
        return this.m_requestBroker.dispatch(n);
    }

    public boolean dispatchAll(int n) {
        if (this.m_requestBroker == null) {
            return false;
        }
        return this.m_requestBroker.dispatchAll(n);
    }

    public boolean isRequestPending() {
        if (this.m_requestBroker == null) {
            return false;
        }
        return this.m_requestBroker.isRequestPending();
    }

    public boolean sendRequest(ORequest oRequest, int n) {
        if (this.m_requestBroker == null) {
            return false;
        }
        return this.m_requestBroker.putRequest(oRequest, n);
    }

    public String getLocalHostName() {
        if (this.m_channel == null) {
            return null;
        }
        return this.m_channel.getLocalHostName();
    }

    public boolean registerFactory(String string, XFactory xFactory) {
        return false;
    }

    public boolean deregisterFactory(String string, XFactory xFactory) {
        return false;
    }

    public boolean createInstance(String string, Uik uik, OObjectHolder oObjectHolder) {
        OCidHolder oCidHolder = new OCidHolder();
        OBooleanHolder oBooleanHolder = new OBooleanHolder();
        Object[] objectArray = new Object[]{new OStringHolder(string), new OUikHolder(uik), new OObjectHolder(oCidHolder), oBooleanHolder};
        ORequest oRequest = new ORequest(this.m_requestBroker, 1, 0);
        oRequest.marshalArguments(types, objectArray, 1);
        oRequest.execute();
        oRequest.unmarshalArguments(types, objectArray, 2);
        if (oBooleanHolder.value) {
            oObjectHolder.value = OContext.createProxyContext(this.m_requestBroker, oCidHolder.getValue(), uik, uik.getIFactory());
        }
        return oBooleanHolder.value;
    }

    public int getServerId() {
        return this.m_myServerId;
    }

    public void addToServerIdMap(int n, int n2) {
    }

    public int mapIncomingServerId(int n) {
        return n;
    }

    public int mapOutgoingServerId(int n) {
        return n;
    }
}

