/*
 * Decompiled with CFR 0.152.
 */
package stardiv.uno.sys.transport;

import java.io.IOException;
import java.io.OutputStream;
import stardiv.uno.OUnoSystemException;
import stardiv.uno.sys.BlockingInputStream;
import stardiv.uno.sys.IConnection;
import stardiv.uno.sys.ITransport;
import stardiv.uno.sys.OSemaphore;
import stardiv.uno.sys.OTransportException;
import stardiv.uno.sys.marshal.OBuffer;
import stardiv.uno.sys.marshal.OBufferHeap;
import stardiv.uno.sys.marshal.OCdrDecoder;
import stardiv.uno.sys.marshal.OCdrEncoder;
import stardiv.uno.sys.marshal.OPacket;

public class OStreamTransport
implements ITransport {
    protected IConnection m_connection;
    protected OutputStream m_oStream;
    protected BlockingInputStream m_iStream;
    protected OCdrDecoder m_decoder;
    protected OCdrEncoder m_encoder;
    protected int m_blockMode;
    protected byte[] m_recvBuffer;
    protected boolean m_isTerminated;
    protected OSemaphore m_blockBeginSem;
    protected OBuffer m_sendHeader;
    protected OBuffer m_recvHeader;
    protected OBuffer m_recvHeader2;
    protected OBufferHeap m_bufferHeap;
    protected static final int STANDARDHEADERLEN = 12;
    protected static final int BlockBeginFlag = 0x10000000;

    public OStreamTransport(IConnection iConnection, OSemaphore oSemaphore, OCdrEncoder oCdrEncoder, OCdrDecoder oCdrDecoder, OBufferHeap oBufferHeap) {
        this.m_bufferHeap = oBufferHeap;
        this.m_connection = iConnection;
        this.m_encoder = oCdrEncoder;
        this.m_decoder = oCdrDecoder;
        this.m_blockMode = 0;
        this.m_recvBuffer = new byte[32768];
        this.m_recvHeader = this.m_bufferHeap.getBuffer(12);
        this.m_recvHeader2 = this.m_bufferHeap.getBuffer();
        this.m_sendHeader = this.m_bufferHeap.getBuffer(12);
        try {
            this.m_oStream = this.m_connection.getOutputStream();
            this.m_iStream = new BlockingInputStream(this.m_connection.getInputStream());
            return;
        }
        catch (IOException iOException) {
            throw new OUnoSystemException("Initializing remote connection failed.");
        }
    }

    protected void finalize() {
        if (this.m_recvHeader != null) {
            this.m_bufferHeap.putBuffer(this.m_recvHeader);
        }
        if (this.m_recvHeader2 != null) {
            this.m_bufferHeap.putBuffer(this.m_recvHeader2);
        }
    }

    public void close() {
        this.m_connection.close();
    }

    public synchronized void sendPacket(OPacket oPacket) throws OTransportException {
        this.m_sendHeader.reset();
        try {
            int n = 12 + oPacket.getLength();
            byte by = oPacket.getType();
            this.m_encoder.encodeULong(this.m_sendHeader, n);
            this.m_encoder.encodeULong(this.m_sendHeader, 12);
            this.m_encoder.encodeOctet(this.m_sendHeader, by);
            oPacket.pushFront(this.m_sendHeader);
            if (this.m_blockMode <= 0) {
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = oPacket.m_front;
                while (n3 <= oPacket.m_back) {
                    System.arraycopy(oPacket.m_buffers[n3].getData(), 0, byArray, n2, oPacket.m_buffers[n3].getSize());
                    n2 += oPacket.m_buffers[n3].getSize();
                    ++n3;
                }
                this.m_oStream.write(byArray, 0, n);
                return;
            }
        }
        catch (IOException iOException) {
            this.m_isTerminated = true;
            throw new OUnoSystemException("Send packet failed. " + iOException);
        }
    }

    public void recvPacket(OPacket oPacket) throws OTransportException {
        try {
            int n = 0;
            boolean bl = false;
            this.m_recvHeader.reset();
            this.m_iStream.read(this.m_recvHeader.getData(), this.m_recvHeader.getSize());
            int n2 = this.m_decoder.decodeULong(this.m_recvHeader);
            int n3 = this.m_decoder.decodeULong(this.m_recvHeader);
            byte by = this.m_decoder.decodeOctet(this.m_recvHeader);
            if (n3 - 12 < 0 || n2 - n3 < 0) {
                throw new OTransportException();
            }
            if (n3 - 12 > 0) {
                this.m_recvHeader2.setSize(n3 - 12);
                this.m_recvHeader2.reset();
                this.m_iStream.read(this.m_recvHeader2.getData(), n3 - 12);
                int n4 = this.m_decoder.decodeULong(this.m_recvHeader2);
                if ((n4 & 0x10000000) > 0) {
                    n = this.m_decoder.decodeULong(this.m_recvHeader2);
                    n -= n3;
                    bl = true;
                }
            }
            if ((by & 4) > 0) {
                throw new OTransportException();
            }
            if (bl) {
                if (n >= this.m_recvBuffer.length) {
                    this.m_recvBuffer = new byte[n];
                }
                this.m_iStream.read(this.m_recvBuffer, n);
                int n5 = 0;
                int n6 = n2 - n3;
                do {
                    if (n6 > 0) {
                        OBuffer oBuffer = this.m_bufferHeap.getBuffer(this.m_recvBuffer, n5, n6);
                        oPacket.pushBack(oBuffer);
                        n5 += n6;
                    }
                    if (n5 >= n) continue;
                    this.m_recvHeader2.setData(this.m_recvBuffer, n5, 12);
                    n2 = this.m_decoder.decodeULong(this.m_recvHeader2);
                    n3 = this.m_decoder.decodeULong(this.m_recvHeader2);
                    by = this.m_decoder.decodeOctet(this.m_recvHeader2);
                    if (n3 - 12 < 0 || n2 - n3 < 0) {
                        throw new OTransportException();
                    }
                    n5 += n3;
                    n6 = n2 - n3;
                } while (n5 < n);
                return;
            }
            if (n2 - n3 > 0) {
                OBuffer oBuffer = this.m_bufferHeap.getBuffer(n2 - n3);
                this.m_iStream.read(oBuffer.getData(), oBuffer.getSize());
                oPacket.pushFront(oBuffer);
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("terminating tranport " + iOException);
            this.m_isTerminated = true;
            throw new OTransportException();
        }
    }

    public synchronized void terminateTransport() {
        try {
            if (!this.m_isTerminated) {
                this.m_isTerminated = true;
                OBuffer oBuffer = this.m_bufferHeap.getBuffer(12);
                this.m_encoder.encodeULong(oBuffer, 12);
                this.m_encoder.encodeULong(oBuffer, 12);
                this.m_encoder.encodeOctet(oBuffer, (byte)4);
                oBuffer.setSize(oBuffer.getWritePos());
                this.m_oStream.write(oBuffer.getData(), 0, oBuffer.getSize());
                this.m_bufferHeap.putBuffer(oBuffer);
                return;
            }
        }
        catch (IOException iOException) {
            throw new OUnoSystemException("Terminating remote connection failed. " + iOException);
        }
    }

    public void enterBlockMode(int n) {
    }

    public void leaveBlockMode() {
    }

    public void flushBlock() {
    }
}

