/************************************************************/
/*     Star Office Service Manager Installation OS/2        */
/*                     ==================                   */
/*                      Version: 1.0.0                      */
/*                        08.03.1999                        */
/*                                                          */
/*                      (C) StarDivision                    */
/*                           1999                           */
/*                                                          */
/************************************************************/

'@ECHO OFF'

/* Load REXXUTIL-Functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* get command line parameter */
command_args = ARG(1)
mode = WORD(command_args, 1)
sdaemon_source = WORD(command_args, 2)

IF sdaemon_source <> "" THEN
    sdaemon_source = (sdaemon_source)"\service\sdaemon.exe"

/* initialize path and file names */
os2_drive    = FILESPEC("drive",VALUE(SYSTEM_INI,,OS2ENVIRONMENT))
os2_path     = FILESPEC("path",VALUE(SYSTEM_INI,,OS2ENVIRONMENT))
startup_name = (os2_drive)"\startup.cmd"
sdaemon_name = (os2_drive)(os2_path)"sdaemon.exe"

/* test command line parameter */
SELECT
    WHEN mode = "start" then CALL start_sdaemon
    WHEN mode = "stop" then CALL stop_sdaemon
    WHEN mode = "install" then CALL install_sdaemon
    WHEN mode = "uninstall" then CALL uninstall_sdaemon
    WHEN mode = "reset" then CALL reset_sdaemon
    OTHERWISE CALL show_usage
END

CALL SysDropFuncs

EXIT

/* shows the command line usage */
show_usage:
    SAY ""
    SAY "usage:"
    SAY "  sdaemon.cmd start              (start sdaemon.exe process)"
    SAY "  sdaemon.cmd stop               (stop sdaemon.exe process)"
    SAY "  sdaemon.cmd reset              (reset sdaemon.exe process)"
    SAY "  sdaemon.cmd install <oficedir> (install sdaemon.exe in system directory)"
    SAY "  sdaemon.cmd uninstall          (uninstall sdaemon.exe from system directory)"
    SAY " "    
return

/* start the installed daemon */
start_sdaemon:
    start sdaemon_name
    ret = SysSleep(10)
return


/* stop the running daemon */
stop_sdaemon:
    start sdaemon_name "-shutdown"
return

/* kills the running daemon */
reset_sdaemon:
    start sdaemon_name "-shutdown"
return
    
/* installs the daemon in OS/2 directory and append it to startup.cmd */
install_sdaemon:
    if sdaemon_source = "" THEN DO
        CALL show_usage
        RETURN
    END
    
    copy sdaemon_source sdaemon_name

    ret = STREAM(startup_name, "C", "QUERY EXISTS")

    IF ret = "" THEN DO
        rc = LINEOUT(startup_name, "ifconfig lo 127.0.0.1")
        rc = LINEOUT(startup_name, "start "sdaemon_name)
        rc = LINEOUT(startup_name, "EXIT")
        rc = STREAM(startup_name,"C",CLOSE)
        END
    ELSE DO
        tmp_name = SysTempFileName(os2_drive"\startup.???")
        rc = LINEOUT(tmp_name, "ifconfig lo 127.0.0.1")
        rc = LINEOUT(tmp_name, "start "sdaemon_name)
        allready_installed = 0
        DO WHILE LINES(startup_name) > 0
            aLine = LINEIN(startup_name)
            IF WORDPOS(sdaemon_name, aLine) > 0 THEN
                allready_installed = 1
            rc = LINEOUT(tmp_name, aLine)
        END
        
        rc = STREAM(startup_name,"C",CLOSE)
        rc = STREAM(tmp_name,"C",CLOSE)
        
        if allready_installed == 0 then
            copy tmp_name startup_name
        
        rc = SysFileDelete(tmp_name)
     END
RETURN

/* removes the daemon from OS/2 directory and erase it from startup.cmd */
uninstall_sdaemon:
    if SysFileDelete(sdaemon_name) = 32 THEN DO
        call reset_sdaemon
        SAY "waiting 5 seconds for shutdown sdaemon.exe..."
        rc = SysSleep(5)
        rc = SysFileDelete(sdaemon_name)
    END
    
    
    ret = STREAM(startup_name, "C", "QUERY EXISTS")

    IF ret <> "" THEN DO
        tmp_name = SysTempFileName(os2_drive"\startup.???")
        was_installed = 0
        DO WHILE LINES(startup_name) > 0
            aLine = LINEIN(startup_name)
            IF WORDPOS(sdaemon_name, aLine) == 0 THEN 
                rc = LINEOUT(tmp_name, aLine)
            ELSE
                was_installed = 1
        END
        
        rc = STREAM(startup_name,"C",CLOSE)
        rc = STREAM(tmp_name,"C",CLOSE)
        
        if was_installed = 1 THEN
            copy tmp_name startup_name
        
        rc = SysFileDelete(tmp_name)
     END
return

