#ifdef WIN32
// OpenCP Module Player
// copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
//
// Routines for screen output (win32 edition)
//
// revision history: (please note changes here)
//  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
//    -first release
//  -kb980717  Tammo Hinrichs <kb@nwn.de>
//    -did a LOT to avoid redundant mode switching (really needed with
//     today's monitors)
//    -added color look-up table for redefining the palette
//    -added MDA output mode for all Hercules enthusiasts out there
//     (really rocks in Windows 95 background :)
//  -fd981016
//    -ported to win32 (yeah, i AM crazy :)

#define NO_POUTPUT_IMPORT

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include "err.h"
#include "pmain.h"
#include "psetting.h"
#include "imsrtns.h"
#include "poutput.h"

static int Initialized=0;
static int KeyBuf[32];

char *plVidMem=(char*)0xA0000;
int plLFB=0;

int plScreenChanged;

short plScrHeight;
short plScrWidth;

int plScrMode;
char plVidType;

unsigned char plScrType;
unsigned short plScrRowBytes;

extern unsigned char plFont816[256][16];
extern unsigned char plFont88[256][8];
//static unsigned char lastgraphpage;
//static unsigned char pagefactor;

static int plActualMode=0xFF;

static char plpalette[256];

static void vgaMakePal()
{
  int pal[16];
  char palstr[1024];
  strcpy(palstr,cfGetProfileString2(cfScreenSec, "screen", "palette", "0 1 2 3 4 5 6 7 8 9 A B C D E F"));

  int bg,fg;

  for (bg=0; bg<16; bg++)
    pal[bg]=bg;

  bg=0;
  char scol[4];
  char const *ps2=palstr;
  while (cfGetSpaceListEntry(scol, ps2, 2) && bg<16)
    pal[bg++]=strtol(scol,0,16)&0x0f;

  for (bg=0; bg<16; bg++)
    for (fg=0; fg<16; fg++)
      plpalette[16*bg+fg]=16*pal[bg]+pal[fg];

}

static unsigned char bartops[18]="\xB5\xB6\xB7\xB8\xBD\xBE\xC6\xC7\xCF\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7";

static int poutwinInit();
static void poutwinClose();
static int poutwinSetMode(int x, int y);
static int poutwinInvalidate(int x0, int y0, int x1, int x2);

static short *videomem=0, *videomemold=0;

static int poutwinWinWidth, poutwinWinHeight;
static int poutwinFontWidth=8, poutwinFontHeight=16;

static HWND hwin;
static HINSTANCE hinst;
static char *pixelmem;

static const char *classname="OpenCPWin32";

HWND getHWND()
{
  return hwin;
}

long WINAPI poutwinWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
    {
    case WM_CREATE:
      //   unsigned long tid;
      //   CreateThread(0, 4096, newthread, 0, 0, &tid);
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      return(0);
#if 0
    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
      {
	for(int i=0; i<buttons; i++)
	  button[i]->Mouse(hWnd, LOWORD(lParam), HIWORD(lParam), wParam);
	break;
      } 
#endif
    case WM_KEYDOWN:
      {
	// insert key in selfmade keyboard buffer, which is read by egetch
	printf("WM_KEYDOWN: %08X\n", lParam);
	int k=lParam>>16;
	if(k==0x148) k=0x4800; // cursor up
	else if(k==0x150) k=0x5000; // cursor down
	else if(k==0x1c) k=13; // enter
	else if(k==0x1) k=27; // esc
	else if(k==0xf) k=9; // tab
	else if(k==0x39) k=32; // space
	else if(k==0x149) k=0x4900; // pg up
	else if(k==0x151) k=0x5100; // pg down
	else if(k==0x147) k=0x4700; // home
	else if(k==0x14f) k=0x4f00; // end
	else if(k==0x14d) k=0x4d00; // right
	else if(k==0x152) k=0x5200; // add
	else if(k==0x14b) k=0x4b00; // left
	else if(k==0x153) k=0x5300; // del
	for(int i=0; i<sizeof(KeyBuf)/sizeof(int); i++)
	  if(KeyBuf[i]==0)
	    {
	      KeyBuf[i]=k;
	      break;
	    }
      }
      break;
    case WM_PAINT:
      {
	RGBQUAD pal[16]= { 
 {0,0,0, 0},
 {168, 0, 0, 0},
 {0, 168, 0, 0},
 {168, 168, 0, 0},
 {0, 0, 168, 0},
 {168, 0, 168, 0},
 {0, 84, 168, 0},
 {168, 168, 168, 0},
 {84, 84, 84, 0},
 {255, 84, 84, 0},
 {84, 255, 84, 0},
 {255, 255, 84, 0},
 {84, 84, 255, 0},
 {255, 84, 255, 0},
 {84, 255, 255, 0},
 {255, 255, 255, 0}
	};

	char bibuf[sizeof(BITMAPINFOHEADER)+sizeof(pal)];
	BITMAPINFO *bi=(BITMAPINFO*)bibuf;
	memcpy(bi->bmiColors, pal, sizeof(pal));
	BITMAPINFOHEADER &bih=bi->bmiHeader;
	bih.biSize=sizeof(bih);
	bih.biWidth=poutwinWinWidth;
	bih.biHeight=-poutwinWinHeight;
	bih.biPlanes=1;
	bih.biBitCount=4;
	bih.biCompression=BI_RGB;
	bih.biSizeImage=0;
	bih.biXPelsPerMeter=0;
	bih.biYPelsPerMeter=0;
	bih.biClrUsed=0;
	bih.biClrImportant=0;
	// RECT r;
	// GetUpdateRect(hwin, &r, TRUE);
	HDC dc=GetDC(hwin);
	StretchDIBits(dc, 0, 0, poutwinWinWidth, poutwinWinHeight, 0, 0, poutwinWinWidth, poutwinWinHeight, pixelmem, bi, DIB_RGB_COLORS, SRCCOPY);
	ReleaseDC(hwin, dc);

	break;
      }
    case WM_SIZE:
      break;
    }
  return DefWindowProc(hWnd, message, wParam, lParam);
}

static volatile int endrequest=0;

static void PeekEvents()
{
  MSG msg;
  if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  else
    Sleep(0);
}

static int poutwinInit()
{
  if(Initialized)
    return 0;

  for(int i=0; i<sizeof(KeyBuf)/sizeof(int); i++)
    KeyBuf[i]=0;

  vgaMakePal();

  hinst=win32GetHInstance();

  WNDCLASS wc;

  wc.style=CS_HREDRAW|CS_VREDRAW;
  wc.lpfnWndProc=poutwinWndProc;
  wc.cbClsExtra=0;
  wc.cbWndExtra=0;
  wc.hInstance=hinst;
  // wc.hIcon=LoadIcon(hinst, MAKEINTRESOURCE(150));
  wc.hIcon=0;
  wc.hCursor=0;
  wc.hbrBackground=0;
  wc.lpszMenuName=0;
  wc.lpszClassName=classname;
  RegisterClass(&wc);

  RECT r;
  r.top=CW_USEDEFAULT;
  r.left=CW_USEDEFAULT;
  r.right=poutwinWinWidth=10;
  r.bottom=(poutwinWinHeight=10)+GetSystemMetrics(SM_CYCAPTION);
  unsigned long style=WS_CAPTION|WS_SYSMENU;
  unsigned long styleex=WS_EX_ACCEPTFILES;

  hwin=CreateWindowEx(styleex, classname, "OpenCP Win32", style, r.left, r.top, r.right, r.bottom, 0, 0, wc.hInstance, 0);
  if(!hwin)
    MessageBoxA(0, "sorry, cannot create output window...", "OpenCP", MB_TASKMODAL);

  pixelmem=new char[poutwinWinWidth*poutwinWinHeight/2];

  ShowWindow(hwin, 1);
  UpdateWindow(hwin);

  // unsigned long tid;
  // CreateThread(0, 4096, poutwinMessageThread, 0, 0, &tid);

  Initialized=1;

  InvalidateRect(hwin, 0, FALSE);

  videomem=videomemold=0;
  plSetTextMode(0);

  return(0);
}

static void poutwinClose()
{
  endrequest=1;
  DestroyWindow(hwin);
  if(pixelmem)
    delete[] pixelmem;
  UnregisterClass(classname, hinst);

  Initialized=0;
}

static int poutwinSetMode(int x, int y)
{
  if(videomem)
    delete[] videomem;
  videomem=new short[x*y];
  if(!videomem)
    return(errAllocMem);
  memset(videomem, 0, x*y*2);

  if(videomemold)
    delete [] videomemold;
  videomemold=new short[x*y];
  if(!videomemold)
    return(errAllocMem);
  memset(videomemold, 0, x*y*2);

  poutwinWinWidth=x*poutwinFontWidth;
  poutwinWinHeight=y*poutwinFontHeight;
  plScrWidth=x;
  plScrHeight=y;
  plScrRowBytes=2*plScrWidth;
  if(pixelmem)
    delete[] pixelmem;
  pixelmem=new char[poutwinWinWidth*poutwinWinHeight/2];
  if(!pixelmem)
    return(errAllocMem);

  SetWindowPos(hwin, HWND_TOP, 0, 0, poutwinWinWidth+2, poutwinWinHeight+GetSystemMetrics(SM_CYCAPTION), SWP_NOMOVE);
  return(0);
  // resize window, allocate new memory etc.
}


static int poutwinInvalidate(int x0, int y0, int x1, int y1)
{
  if(!Initialized)
    poutwinInit();

  // correct parameters
  if(x0>=plScrWidth) x0=plScrWidth-1;
  if(y0>=plScrHeight) y0=plScrHeight-1;
  if(x1>=plScrWidth) x1=plScrWidth-1;
  if(y1>=plScrHeight) y1=plScrHeight-1;

  // check against local rect
  static int xx0=100, yy0=100, xx1=0, yy1=0;
  if(x0<xx0)
    xx0=x0;
  if(y0<yy0)
    yy0=y0;
  if(x1>xx1)
    xx1=x1;
  if(y1>yy1)
    yy1=y1;

  // only update every 25ms
  static DWORD lasttime=0;
  const DWORD time=GetTickCount();
  if(time-lasttime < 1000/25)
    return 0;

  lasttime=time;

  for(int y=yy0; y<=yy1; y++)
    for(int x=xx0; x<=xx1; x++)
      {
	const int i=y*plScrWidth+x;
	short cc=videomem[i];
	if(cc!=videomemold[i])
	  {
	    videomemold[i]=cc;
	    char *m=pixelmem+((y*poutwinFontHeight)* poutwinWinWidth+x*poutwinFontWidth)/2;
	    char c=cc&0xFF;        // current char
	    int a=((unsigned)cc)>>8;      // current attrib
	    int fore=plpalette[a&0xF];
	    int back=plpalette[(a>>4)&0xF];
	    
	    unsigned char *font=plFont816[c];
	    for(int ay=0; ay<16; ay++)
	      {
		for(int ax=0; ax<8; ax+=2)
		  {
		    *m=(*font&(1<<(7-ax)))?fore:back;
		    *m++|=((*font&(1<<((7-ax)+1)))?fore:back)<<4;
		  }
		m+=(poutwinWinWidth-poutwinFontWidth)/2;
		font++;
	      }
	  }
      }

  RECT r;
  r.left=xx0*poutwinFontWidth;
  r.top=yy0*poutwinFontHeight;
  r.right=(xx1+1)*poutwinFontWidth-1;
  r.bottom=(yy1+1)*poutwinFontHeight-1;

  InvalidateRect(hwin, &r, FALSE);

  xx0=plScrWidth;
  yy0=plScrHeight;
  xx1=yy1=0;
  return(0);
}

void plTestEnhanced()
{
  printf("enhanced testing of the poutput-stuff..\n");
  printf("init..\n");
  poutwinInit();
  displaystr(3, 1, 0x1F, "hello...", 8);
  egetch();
  printf("close..\n");
  poutwinClose();
  printf("done..\n");
}

int ekbhit()            // TEMPORARY HACK!
{
  if(KeyBuf[0])
    return KeyBuf[0];
  PeekEvents();
  return(kbhit());
}

int egetch()            // TEMPORARY HACK!
{
  if(KeyBuf[0])
    {
      int k=KeyBuf[0];
      for(int i=0; i<sizeof(KeyBuf)/sizeof(int)-1 && KeyBuf[i]; i++)
	KeyBuf[i]=KeyBuf[i+1];
      KeyBuf[i]=0;
      return k;
    }

  while(!kbhit())
    PeekEvents();
  int code=getch();
  if(!code) code=getch()<<8;
  return(code);
}

void plSetBarFont()
{
  for (int i=0; i<=16; i++)
    for (int j=0; j<16; j++)
      plFont816["\xB5\xB6\xB7\xB8\xBD\xBE\xC6\xC7\xCF\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7"[i]][j]=((15-j)<i)?0xFE:0;

  // modify font
}

void plClearTextScreen()
{
  if(videomem)
    {
      memset(videomem, 0, plScrHeight*plScrWidth*2);
      poutwinInvalidate(0, 0, plScrWidth-1, plScrHeight-1);
    }
}


void plSetTextMode(unsigned char t)
{
  if(t=='T') { plTestEnhanced(); return; }
  int l43=0;
  plScrType=t&7;

  plScreenChanged=0;
  plScrMode=0;
  plActualMode=plScrType;

  int dx=(plScrType&8)?40:(plScrType&4)?132:80;
  int dy=(plScrType&1)?((plScrType&2)?60:30):((plScrType&2)?(l43?l43:50):25);
  poutwinSetMode(dx, dy);

  plClearTextScreen();
}

int plSetGraphPage(unsigned char p)
{
  return 0;
}


void plClearGraphScreen()
{
}


void plSetGraphMode(unsigned char size)
{
}

char *convnum(unsigned long num, char *buf, unsigned char radix, unsigned short len, char clip0)
{
  unsigned short i;
  for (i=0; i<len; i++)
    {
      buf[len-1-i]="0123456789ABCDEF"[num%radix];
      num/=radix;
    }
  buf[len]=0;
  if (clip0)
    for (i=0; i<(len-1); i++)
      {
	if (buf[i]!='0')
	  break;
	buf[i]=' ';
      }
  return buf;
}

void writenum(short *buf, unsigned short ofs, unsigned char attr, unsigned long num, unsigned char radix, unsigned short len, char clip0)
{
  char convbuf[20];
  char *p=(char *)buf+ofs*2;
  char *cp=convbuf+len;
  unsigned short i;
  for (i=0; i<len; i++)
    {
      *--cp="0123456789ABCDEF"[num%radix];
      num/=radix;
    }
  for (i=0; i<len; i++)
    {
      if (clip0&&(convbuf[i]=='0')&&(i!=(len-1)))
	{
	  *p++=' ';
	  cp++;
	}
      else
	{
	  *p++=*cp++;
	  clip0=0;
	}
      *p++=attr;
    }
}


void writestring(short *buf, unsigned short ofs, unsigned char attr, const char *str, unsigned short len)
{
  char *p=((char *)buf)+ofs*2;
  unsigned short i;
  for (i=0; i<len; i++)
    {
      *p++=*str;
      *p++=attr;
      if (*str)
	str++;
    }
}


void writestringattr(short *buf, unsigned short ofs, const void *str, unsigned short len)
{
  memcpyb(((char *)buf)+ofs*2, (void *)str, len*2);
}


void markstring(short *buf, unsigned short ofs, unsigned short len)
{
  buf+=ofs;
  short i;
  for (i=0; i<len; i++)
    *buf++^=0x8000;
}



void displaystr(unsigned short y, unsigned short x, unsigned char attr, const char *str, unsigned short len)
{
  if((y*plScrWidth+x+len)>(plScrWidth*plScrHeight))
    {
      printf("illegal displaystr: %d,%d -> %d bytes, %s\n", x, y, len, str);
      return;
    }
  char *p=((char*)videomem)+(y*plScrRowBytes+x*2);
  attr=plpalette[attr];
  unsigned short i;
  int changed=0;
  for (i=0; i<len; i++)
    {
      if(*p!=*str)
	changed=1;
      *p++=*str;
      if(*str)
	str++;
      if(*p!=attr)
	changed=1;
      *p++=attr;
    }
  if(changed) poutwinInvalidate(x, y, x+len, y);
}


void displaystrattr(unsigned short y, unsigned short x, const short *buf, unsigned short len)
{
  if((y*plScrWidth+x+len)>(plScrWidth*plScrHeight))
    {
      printf("illegal displaystrattr: %d,%d -> %d bytes, %c%c%c%c\n", x, y, len, buf[0], buf[2], buf[4], buf[6]);
      return;
    }
  char *p=((char*)videomem)+(y*plScrRowBytes+x*2);
  char *b=(char *)buf;
  int changed=0;
  for (int i=0; i<len*2; i+=2)
    {
      if(p[i]!=b[i]);
      changed=1;
      p[i]=b[i];
      if(p[i+1]!=plpalette[b[i+1]])
	changed=1;
      p[i+1]=plpalette[b[i+1]];
    }
  if(changed) poutwinInvalidate(x, y, x+len, y);
}


void displaystrattrdi(unsigned short y, unsigned short x, const unsigned char *txt, const unsigned char *attr, unsigned short len)
{
  if((y*plScrWidth+x+len)>(plScrWidth*plScrHeight))
    {
      printf("illegal displaystrattrdi: %d,%d -> %d bytes, %s\n", x, y, len, txt);
      return;
    }
  char *p=((char*)videomem)+(y*plScrRowBytes+x*2);
  unsigned short i;
  int changed=0;
  for (i=0; i<len; i++)
    {
      if(*p!=*txt)
	changed=1;
      *p++=*txt++;
      if(*p!=plpalette[*attr]) changed=1;
      *p++=plpalette[*attr++];
    }
  if(changed) poutwinInvalidate(x, y, x+len, y);
}


void displayvoid(unsigned short y, unsigned short x, unsigned short len)
{
  if((y*plScrWidth+x+len)>(plScrWidth*plScrHeight))
    {
      //printf("illegal displayvoid: %d,%d -> %d bytes\n", x, y, len);
      return;
    }
  char *addr=((char*)videomem)+y*plScrRowBytes+x*2;
  int changed=0;
  while (len--)
    {
      if(*addr) changed=1;
      *addr++=0;
      if((*addr)&0xF0) changed=1;
      *addr++=plpalette[0];
    }
  if(changed) poutwinInvalidate(x, y, x+len, y);
}

void gdrawchar(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b)
{
}

void gdrawchart(unsigned short x, unsigned short y, unsigned char c, unsigned char f)
{
}

void gdrawcharp(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp)
{
}

void gdrawchar8(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b)
{
}

void gdrawchar8t(unsigned short x, unsigned short y, unsigned char c, unsigned char f)
{
}

void gdrawchar8p(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp)
{
}

void gdrawstr(unsigned short y, unsigned short x, const char *str, unsigned short len, unsigned char f, unsigned char b)
{
}

void gupdatestr(unsigned short y, unsigned short x, const short *str, unsigned short len, short *old)
{
}

void drawbar(unsigned short x, unsigned short yb, unsigned short yh, unsigned long hgt, unsigned long c)
{
  if(yh>60)
    yh=60;
  if (hgt>((yh*16)-4))
    hgt=(yh*16)-4;
  char buf[60];
  short i;
  for (i=0; i<yh; i++)
    {
      if (hgt>=16)
	{
	  buf[i]=bartops[16];
	  hgt-=16;
	}
      else
	{
	  buf[i]=bartops[hgt];
	  hgt=0;
	}
    }
  char *scrptr=((char*)videomem)+(2*x+yb*plScrRowBytes);
  short yh1=(yh+2)/3;
  short yh2=(yh+yh1+1)/2;
  for (i=0; i<yh1; i++, scrptr-=plScrRowBytes)
    {
      scrptr[0]='X';//buf[i];
      scrptr[1]=plpalette[c&0xFF];
    }
  c>>=8;
  for (; i<yh2; i++, scrptr-=plScrRowBytes)
    {
      scrptr[0]='x';//buf[i];
      scrptr[1]=plpalette[c&0xFF];
    }
  c>>=8;
  for (; i<yh; i++, scrptr-=plScrRowBytes)
    {
      scrptr[0]=' ';//buf[i];
      scrptr[1]=plpalette[c&0xFF];
    }

  poutwinInvalidate(x, yb-yh, x, yb);
}

extern "C"
{
  initcloseregstruct outReg = {poutwinInit, poutwinClose};
  char *dllinfo = "preinitclose _outReg";
};
#else
#error please compile under Win32.
#endif
