/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for OS/2.
 *  Copyright (c) IBM Corp. 1990, 1993.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 ******************************************************************************
 ******************************************************************************
 */

#define  MAX_CONTROLFILE   0x1000

#define  PORTFLGS_MAIL           0x00000001
#define  PORTFLGS_BANNER         0x00000002
#define  PORTFLGS_PASS_SPARAMS   0x00000004     /* Pass SProcParams     */
#define  PORTFLGS_PASS_QPARAMS   0x00000008     /* Pass QProcParams     */
#define  PORTFLGS_PASS_NPARAMS   0x00000010     /* Pass NProcParams     */
#define  PORTFLGS_DIALOGONPRINT  0x00000020     /* display dialog every job */
#define  PORTFLGS_DATAFILTER     0x00000040     /* Enable data filter   */

typedef struct _LPDPORT {
  CHAR PortName[16];     /* Actual port name of this port       */
  CHAR Server[128];      /* Host where job is to be sent to     */
  CHAR Printer[128];     /* Printer where job is to be printed  */
  CHAR Source[32];       /* Host generating job  */
  CHAR User[32];         /* User generating job  */
  CHAR MailTo[32];       /* User to receive mail on job completion */
  CHAR Class[32];        /* Class for banner page   */
  CHAR DataFilter[256];  /* Command line for data filter */
  ULONG Flags;
  PSZ  ControlFile;      /* Pointer to control file data */
  PSZ  SpoolerParamPrefix;
  PSZ  QueueParamPrefix;
  PSZ  NetworkParamPrefix;
} LPDPORT;
typedef LPDPORT *PLPDPORT;
