/*************************************************************************/
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1995.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/* Program calls  nbjdstat to try to determine UAA.  If found, it
    stores the results in the protocol.ini file.  If not, it returns
    an error to the program.  */

call RxFuncAdd "SysGetMessage", "RexxUtil", "SysGetMessage"
call RxFuncAdd 'GetBootDrive', 'RLANUTIL', 'GetBootDrive'
call RxFuncAdd "SysFileDelete", "RexxUtil", "SysFileDelete"

parse source with . cmdname
grpdrive = substr(cmdname,1,2)

parse arg logname rspfile

msgfile = 'NPINST.MSG'

logname = strip(logname)
rspfile = strip(rspfile)

dpathstr = value("DPATH",,"OS2ENVIRONMENT")
dpathstr = translate(dpathstr)
parse var dpathstr first '\IBMCOM' .
ibmcomdrv = right(first,2)
os2drv = GetBootDrive()

lantranlog = ibmcomdrv'\IBMCOM\LANTRAN.LOG'

/* List of adapter numbers */
adapstring = ''

/* Number of adapters found in lantran.log */
uniqadapters = 0

/* Read the lantran.log, search for adapter addresses */
do while lines(lantranlog) > 0
   /* Upper case and strip off blanks and terminating period */
   line1 = strip(strip(translate(linein(lantranlog))),,'.')
   num = ''; address = ''
   do i = 1 to words(line1)
      word1 = word(line1, i)
      if datatype(word1, 'N') & (length(word1) < 3) then num = word1
      else if (length(word1) = 12) & datatype(word1, 'X') then do
        address = word1
        leave  /* Use only 1st address in the line */
      end /* then..do */
      else if (length(word1) = 13) & datatype(strip(word1,,'.'), 'X') then do
        /* The address might have a '.' appended to it due to English grammar. */
        address = strip(word1,,'.')
        leave  /* Use only 1st address in the line */
      end /* then..do */
   end /* do */
   if num \= '' & address \= '' then do
      adapter.num = strip(address)
      /* Add the adapter number to the string of unique adapters found if it's
          not already in the string.  Increment the adapter counter */
      foundnum = 0
      do i = 1 to words(adapstring)
         if strip(num) = strip(word(adapstring,i)) then foundnum = 1
      end /* do */
      if foundnum = 0 then do
         adapstring = adapstring || num' '
         uniqadapters = uniqadapters + 1
      end /* Do */
   end  /* Do */
end /* do */
call stream lantranlog, 'C', 'CLOSE'

rspfile = stream(rspfile, 'C', 'QUERY EXISTS')

/* If the response file is there, read it in, storing off the location of the
    ODI2NDI netaddress line */
if rspfile \= '' then do
   netaddress_index = ''; in_odi_sec = 0; i = 0
   do while lines(rspfile) > 0
     i = i + 1
     nwmptsrsp.i = linein(rspfile)
     parse var nwmptsrsp.i kw '=' kwval
     if translate(kwval) = 'ODI2NDI.NIF' then in_odi_sec = 1
     else if strip(nwmptsrsp.i) = ')' then in_odi_sec = 0
     if in_odi_sec then do
        if translate(kw) = 'NETADDRESS' then netaddress_index = i
     end  /* Do */
   end /* Do while lines */
   nwmptsrsp.0 = i
   call stream rspfile, 'C', 'CLOSE'
end
/* If we can't find the response file, bail */
else do
   err1.1 = SysGetMessage(10, msgfile, rspfile)
   err1.2 = SysGetMessage(11, msgfile)
   call errout 10
end  /* Do */

/* Read the MPTS response file for NetWare, find the bindings line for ODI2NDI and
    build a new netaddress line */
first_time = 1
do i =1 to nwmptsrsp.0
   parse upper var nwmptsrsp.i kw '=' kwval

   /* The first bindings statement will be for ODI2NDI */
   if translate(strip(kw)) = 'BINDINGS' & first_time then do
      first_time = 0
      adaptoadd = ''
      bindline = kwval

      /* Count the number of commas for each nif that is bound */
      do while length(strip(bindline)) > 0
         parse var bindline first '_NIF' bindline
         tmpnum = countem(first, ',')
         adaptoadd = adaptoadd' 'tmpnum

         /* Account for duplicate nif names like ibmtok_nif2. */
         if(left(bindline,1)) \= ',' & length(strip(bindline)) > 0 then do
            bindline = substr(bindline,2,length(bindline)-1)
         end  /* Do */

      end /* do */

      /* Null the value of the address string we're going to build */
      odiaddressstring = ''

      /* For each binding, add the address, filling in the appropriate commas */
      do j = 1 to words(adaptoadd)
         tmpnum = word(adaptoadd,j)
         if length(strip(adapter.tmpnum)) \= 12 then adapter.tmpnum = ''
         newaddress = '"' || strip(adapter.tmpnum) || '"'
         commas = copies(',',tmpnum)
         if length(strip(commas)) = 0 then odiaddressstring = newaddress || odiaddressstring
         else odiaddressstring = odiaddressstring || commas || newaddress
      end /* do */

      /* If there was no netaddress found, save the index so we know where to insert
          the netaddress */
      if netaddress_index = '' then insert_blank = i
      else insert_blank = ''

      /* We have all we need, so we can end the loop */
      i = nwmptsrsp.0

   end /* do */
end /* do */

/* If there isn't a netaddress line, insert a blank to make room for one */
if insert_blank \= '' then do
   do i = 1 to insert_blank
      tmpstem.i = nwmptsrsp.i
   end /* do */
   tmpstem.i = ''
   do j = i to nwmptsrsp.0
      bump = j + 1
      tmpstem.bump = nwmptsrsp.j
   end /* do */
   do i = 1 to j
      nwmptsrsp.i = tmpstem.i
   end /* do */
end  /* Do */

/* If there is a previous netaddress, use it */
if netaddress_index \= '' then do
   parse var nwmptsrsp.netaddress_index kw'='netaddress

   /* If it's only bound to 0, strip off parse out the built string, replacing
       everything before the first comma with the netaddress */
   if pos(',', netaddress) = 0 then do
      nwmptsrsp.netaddress_index = '  NETADDRESS = 'netaddress
      parse var odiaddressstring first','last
      nwmptsrsp.netaddress_index = nwmptsrsp.netaddress_index || last
   end

   /* If not, merge it */
   else do

      /* Initialize a temp stem */
      do k = 0 to 3
         tmpstem.k = ''
      end /* do */

      /* Fill in the values of the tmpstem */
      counter = 0; tmpstring = ''
      do k = 1 to length(odiaddressstring)
         thischar = substr(odiaddressstring, k, 1)
         if thischar = ',' then do
            tmpstem.counter = tmpstring
            counter = counter + 1
            tmpstring = ''
         end
         else tmpstring = tmpstring || thischar
      end /* do */
      tmpstem.counter = tmpstring

      /* Overlay the values of the tmpstem */
      counter = 0; tmpstring = ''
      do k = 1 to length(netaddress)
         thischar = substr(netaddress, k, 1)
         if thischar = ',' then do
            tmpstem.counter = tmpstring
            counter = counter + 1
            tmpstring = ''
         end
         else tmpstring = tmpstring || thischar
      end /* do */
      tmpstem.counter = tmpstring

      /* Build the new string */
      commacount = 0; tmpstring = ''
      do k = 0 to 3
         tmpstring = tmpstem.k || tmpstring || ','
      end /* do */

      /* Strip off any trailing commas */
      do until right(strip(tmpstring),1) \= ','
         if right(strip(tmpstring),1) = ',' then tmpstring = substr(tmpstring, 1, length(tmpstring)-1)
      end /* do */

      /* Assign the tmpstring back */
      nwmptsrsp.netaddress_index = '  NETADDRESS = 'tmpstring
   end  /* Do */
end  /* Do */

/* If there wasn't a netaddress, then use the one that was built */
else do
   netaddress_index = insert_blank + 1
   nwmptsrsp.netaddress_index = '  NETADDRESS = 'odiaddressstring
end  /* Do */

/* Delete the old response file */
call SysFileDelete rspfile

/* Write the new one */
do i = 1 to nwmptsrsp.0
   call lineout rspfile, nwmptsrsp.i
end /* do */
call stream rspfile, 'C', 'CLOSE'

RETURN 0

/* COUNTEM */
/*
    Called by:
    Calls: None
    Dependencies: None
*/
/* Count the number of objects in the target */
countem:

  parse arg target, object

  index1 = 1; countit = 0; foundit = ''
  do while foundit \= 0
    foundit = POS(object, target, index1)
    if foundit \= 0 then do
       countit = countit + 1
       index1 = foundit + 1
    end  /* Do */
  end /* do */

RETURN countit

/* ERROUT */
/*
    Called by: Any error or completion
    Calls: None
    Dependencies: err1. logname
*/
/* Function to write log file */

errout:

if logname = '' then logname = 'C:\ERROR.OUT'
parse arg retc

if retc \= 0 then do
   say err1.1
   say err1.2
end  /* Do */

err1.0 = 2
rc =  stream(logname, 'C', 'QUERY EXISTS')
if rc \= '' then call sysfiledelete logname

do i = 1 to err1.0
   call lineout logname, err1.i
end /* do */

call lineout logname

EXIT retc
