/*************************************************************************/
/* Licensed Materials - Property of IBM                                   */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1995.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/***********************************************************************/
/* CHKLANLK.CMD                                                        */
/* This command file will check config.sys for the ibmlanlk drives and */
/* if found remove the drives and merge the list file with previous    */
/* list files.                                                         */
/***********************************************************************/
parse ARG bootdrive cddrive .
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

configsys = bootdrive || '\CONFIG.SYS'
Temp_LANLK_List_File = bootdrive || '\OS2\INSTALL\CLTLANLK.LST'
Found_IBMLANLK = 0

/* Added retry to see if config.sys is being used by someone else */
rc = stream(configsys, 'C', 'OPEN')
if rc \= 'READY:' then do
   sleepcnt = 0
   do until rc = 'READY:' | sleepcnt > 12
      say ''
      call SysSleep 5
      sleepcnt = sleepcnt + 1
      rc = stream(configsys, 'C', 'OPEN')
   end /* do */
end  /* Do */
call stream configsys, 'C', 'CLOSE'
if rc \= 'READY:' then RETURN 40

Do Until ((Lines(configsys) = 0) | (Found_IBMLANLK = 1))
   lin = LineIn(configsys)
   parse upper var lin test LstFile
   tst = Pos('IBMLANLK',test)
   If tst > 0 then
      Do
         LK_List_File = LstFile
         parse upper var test 'DEVICE='driverpath '\IBMLANLK'.
         if(driverpath = "") then
           do
             parse upper var test 'RUN='driverpath '\IBMLANLK'.
             Found_IBMLANLK = 1
           end
         else
           do
             Found_IBMLANLK = 1
           end
      End
End
rc = LineOut(configsys)

/* Remove the ibmlanlk lines from config.sys */
if(Found_IBMLANLK = 1) then
  Do
    s = 0
    do while Lines(configsys) > 0
      s = s + 1
      Csys.s = LineIn(configsys)
    end
    Csys.0 = s
    rc = LineOut(configsys)
    '@' || cddrive || '\CID\EXE\OS2\attrib -r 'configsys' 1>nul 2>nul'

    '@erase' configsys' 1>nul 2>nul'
    if rc \= 0 then do
      sleepcnt = 0
      do until rc = 0 | sleepcnt > 30
         say ''
        call SysSleep 5
        sleepcnt = sleepcnt + 1
        '@erase' configsys' 1>nul 2>nul '
      end /* do */
    end  /* Do */
    if rc \= 0 then RETURN 40

    do s = 1 to Csys.0
      parse upper var Csys.s test
      tst = Pos('IBMLANLK',test)
      If tst = 0 then
        rc = LineOut(configsys, Csys.s)
    end
    rc = LineOut(configsys)

    /* copy/merge the list file */
    call SysFileTree Temp_LANLK_List_File, file, F

    if file.0 = 0 then         /* add the drive path to first line */
      rc = LineOut(Temp_LANLK_List_File, DriverPath)

    do while Lines(LK_List_File) > 0
      ThisLine = LineIn(LK_List_File)
      rc = LineOut(Temp_LANLK_List_File, ThisLine)
    end
    rc = LineOut(LK_List_File)
    rc = LineOut(Temp_LANLK_List_File)
    '@erase' LK_List_File' 1>nul 2>nul'

  End
return
