/*************************************************************************/
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1996.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/* This program will install MPTS given the boot drive */

/* Load function to determine disk space */
call RxFuncAdd 'QLDrives', 'RLANUTIL', 'QLDrives'
call RxFuncAdd 'QuerySingleSyslevel', 'RLANUTIL', 'QuerySingleSyslevel'

curr_mpts_level = '5.10'

/* Get the boot drive */
parse upper arg Boot_Drive

Boot_Drive = left(Boot_Drive,1)||':'

rspfile = Boot_Drive'\OS2\INSTALL\NETBMPTS.RSP'

/* Get the values that are set out of the environment */
adapname = value('ADAPTER_NIF',,'OS2ENVIRONMENT')
srvname = value('SRVNAME1',,'OS2ENVIRONMENT')
adapinfo = value('ADAPTER_INFO',,'OS2ENVIRONMENT')
nbprotocol = value('NBPROTOCOL',,'OS2ENVIRONMENT')

/* If the protocol isn't defined in the environment, use NETBEUI */
if nbprotocol = '' then nbprotocol = 'NETBEUI'

/* Find the adapter file */
adapname = strip(adapname)
adapfile = 'Z:\CID\NIFS\MACS\'adapname

if stream(adapfile, 'C', 'QUERY EXISTS') = '' then
   adapfile = 'W:\IBMCOM\MACS\'adapname

/* If we found the adapter file, look for the driver name */
if stream(adapfile, 'C', 'QUERY EXISTS') \= '' then do
   adap.drvname = ''
   Do Until lines(adapfile) = 0 | adap.drvname \= ''
      rline = LineIn(adapfile)
      parse upper var rline parmname '=' .
      if strip(parmname) = "DRIVERNAME" then do
         parse var rline parmname'='valname'^'.
         adap.drvname = strip(valname)
      end  /* Do */
   end /* Do */
   call stream adapfile, 'C', 'CLOSE'
end  /* Do */

/* If we couldn't find it, return an error */
else RETURN 7

/* Go to the config.sys, walk the path statement looking for \IBMCOM */

csys = Boot_Drive'\config.sys'
MPTS_drive = ''
foundit = 0

do while lines(csys) > 0 & foundit = 0
   line1 = translate(linein(csys))
   parse upper var line1 . kw'='kwval
   if strip(kw) = 'PATH' then do
      foundit = 1
      if pos('\IBMCOM', line1) > 0 then do
         parse var line1 first'\IBMCOM'.
         MPTS_drive = right(first,2)
      end  /* Do */
   end /* Do */
end /* do */

call stream csys, 'C', 'CLOSE'

/* If no \ibmcom was found then the boot drive is the MPTS drive */
if MPTS_drive = '' then do
  MPTS_drive = Boot_Drive
  dasd_needed = 6500000
end


/* Check to see if it's an update or re-config only.  If it's
   config only, the dasd_needed is 0. */

else do

  mptslevel = 0

  /* Read the syslevel file, convert it to a version number */
  syslevelfile = stream(MPTS_Drive'\IBMCOM\SYSLEVEL.TRP', 'C', 'query exists')
  if syslevelfile \= '' then do
     call QuerySingleSyslevel syslevelfile, "syslevelstem"
     mptslevel = syslevelstem.1.MajorVersion||'.'||syslevelstem.1.MinorVersion
  end  /* Do */

  if mptslevel < curr_mpts_level then
     dasd_needed = 0
  else
     dasd_needed = 3200000

end

/* Get the drive info */
Call QLDrives 'drvstem'

freespace = 0

/* Walk the drives, list, find the right drive and
   check for the available size */
do i =1 to drvstem.0
   if strip(drvstem.i.Drive) = MPTS_Drive then
      freespace = drvstem.i.DASDRemain * 1000000
end /* do */

/* If there isn't enough space, return an error */
if freespace < dasd_needed then
   RETURN 30

/* Go build the response file */
mrc = makeresp()
if mrc \= 0 then
    return mrc

cidimgdir = 'z:\cid\img'

/* If there is a response file, run the MPTS install */
/* Note: The rsp file will have a minimum of 5 lines. */
if mptsrsp.0 > 5 then do

   cidimgdir'\MPTS\MPTS ',
     ' /e:MAINT',
     ' /s:'cidimgdir'\MPTS',
     ' /t:'MPTS_drive,
     ' /tu:'Boot_Drive,
     ' /l1:'Boot_Drive'\OS2\INSTALL\INSTMPTS.LOG',
     ' /r:'rspfile

     if rc \= -512 then
       return rc
end /* do */


/* For test */
temp = value('ALIAS_CDROM',,'OS2ENVIRONMENT')
if temp = '' then
  alias = 'CDROM'
else
  alias = temp

/* Run thinifs for the CD-ROM Connection */
'Z:\CID\SRVIFS\THINIFS ',
' /T:'Boot_Drive'\SRVIFSRQ',
' /TU:'Boot_Drive,
' /S:Z:\CID\SRVIFS',
' /SRV:\\'srvname'\'||alias,
' /REQ:*',
' /W',
' /D:Z'

if rc \= -512 then
   return rc

temp = value('ALIAS_STATUS',,'OS2ENVIRONMENT')
if temp = '' then
  alias = 'STATUS'
else
  alias = temp

/* Run thinifs for the Status Connection */
'Z:\CID\SRVIFS\THINIFS ',
' /T:'Boot_Drive'\SRVIFSRQ',
' /TU:'Boot_Drive,
' /S:Z:\CID\SRVIFS',
' /SRV:\\'srvname'\'||alias,
' /REQ:*',
' /W',
' /D:W'

if rc \= -512 then
   return rc

/* Turn off the readonly attributes for SRVIFSRQ */
'Z:\CID\EXE\OS2\ATTRIB -r 'Boot_Drive'\SRVIFSRQ\*'

if value('CAS_STATE',,'OS2ENVIRONMENT') = '' then do
/* Run CASINSTL to set up the LCU stuff */
'Z:\CID\LOCINSTU\CASINSTL ',
  ' /REQ:LOCAL',
  ' /TU:'Boot_Drive,
  ' /CMD:'Boot_Drive'\IBMINST\RSP\LOCAL ',
  ' /L1:'Boot_Drive'\IBMINST\LOGS\LOCINSTU\INSTMPTS.L2 ',
  ' /PL:'Boot_Drive'\IBMINST ',
' /D',
' /PA:Z:\CID\LOCINSTU',
' /0'
end /* if */
else call moveSrvrexx

/* Append the necessary stuff to the config.sys */
call lineout csys, 'REM IBMINST: REMOVE NEXT LINE'
call lineout csys, 'SET RESTARTOBJECTS=NO'
call lineout csys

RETURN 0

/* This will create the appropriate response file for MPTS */
makeresp:

   /* Define the section name */
   adapsec = translate(adapname, '_','.')

   foundnb = 0; foundadap = 0

   /* If MPTS is installed, go look at the protocol.ini to see if we
      can find NetBEUI */

   if mptslevel > 0 then do

      protfile = MPTS_Drive'\IBMCOM\PROTOCOL.INI'

      do while lines(protfile) > 0
         line1 = linein(protfile)

         if lastpos('[VLAN_KERNEL]', translate(line1)) \= 0 then do
               /* Tell CONINST that LAN Distance is installed. */
               return 213
         end /* if */

         parse upper var line1 kw'='kwval
         if strip(kw) = 'DRIVERNAME' & strip(kwval) = nbprotocol'$' then
            foundnb = 1
         else if strip(kw) = 'DRIVERNAME' & strip(kwval) = adap.drvname then
            foundadap = 1
      end /* do */

      call stream protfile, 'C', 'CLOSE'

   end  /* if */

   /* Delete the old response file */
   '@del 'rspfile' >nul 2>nul'


   lc = 0

   /* always do an install section */

     /* Header section */
     mptsrsp.1 = "INST_SECTION = ("
     mptsrsp.2 = "  UPGRADE_LEVEL = SAME"
     mptsrsp.3 = "  INSTALL = PRODUCT"
     mptsrsp.4 = ")"
     mptsrsp.5 = ""
     lc = 5

   if \ foundnb then do

      lc = lc + 1
      mptsrsp.lc = ""
      lc = lc + 1
      mptsrsp.lc = "PROT_SECTION = ("
      lc = lc + 1
      mptsrsp.lc = "  NIF = "nbprotocol".NIF"
      lc = lc + 1
      mptsrsp.lc = "  SECTION_name = "nbprotocol"_NIF"
      lc = lc + 1
      mptsrsp.lc = "  DRIVERNAME = "nbprotocol"$"
      lc = lc + 1
      mptsrsp.lc = "  BINDINGS = "adapsec
      lc = lc + 1
      mptsrsp.lc = ")"
      lc = lc + 1
      mptsrsp.lc = ""

   end

   if \ foundadap & \ foundnb then do

      lc = lc + 1
      mptsrsp.lc = "PROT_SECTION = ("
      lc = lc + 1
      mptsrsp.lc = "  NIF = "adapname
      lc = lc + 1
      mptsrsp.lc = "  SECTION_name = "adapsec
      lc = lc + 1
      mptsrsp.lc = "  DRIVERNAME = "adap.drvname
      lc = lc + 1
      mptsrsp.lc = ")"
      lc = lc + 1
      mptsrsp.lc = ""

   end
   mptsrsp.0 = lc

   if lc > 0 then do
      do i = 1 to lc
         call lineout rspfile, mptsrsp.i
      end /* do */
      call stream rspfile, 'C', 'CLOSE'
   end

RETURN 0


moveSrvrexx:

/* Move SRVREXX.EXE call to the end of CONFIG.SYS
   to ensure it's called after the SRVATTACH.   */
csys = Boot_Drive||'\CONFIG.SYS'

lc = 0
foundit = 0

do while lines(csys) > 0
   line1 = linein(csys)
   if pos('\CID\LOCINSTU\SRVREXX.EXE', translate(line1)) > 0  then do
      foundit = 1
      srvLine = line1;
      end  /* Do */
   else do
      lc = lc + 1
      newcsys.lc = line1
   end
end /* do */

call stream csys, 'C', 'CLOSE'

if foundit > 0 then do
   newfile = Boot_Drive||'\OS2TCSYS'
   do i = 1 to lc
       call lineout newfile, newcsys.i
   end /* do */
   call lineout newfile, srvLine
   call stream newfile, 'C', 'CLOSE'
   '@del '||csys||' >nul 2>nul'
   '@ren '||newfile||' CONFIG.SYS >nul 2>nul'
end

return
