/*************************************************************************/
/* Licensed Materials - Property of IBM                                  */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1995.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/* 38709  CM  07/16/96  Add path to ibmlanlk.sys to locked file list     */
/*                                                                       */
/*************************************************************************/
parse ARG os2_drive

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  os2_drive = os2_drive||':'

  configfile = os2_drive||'\os2\install\config.sav'
  lanlkfile = os2_drive||'\OS2\INSTALL\CLTLANLK.LST'
  lanlk_index = 0

  /* remove lines from config.sav and add file to lanlk.lst */
  call process_config_sav


process_config_sav:
  /* read config.sav into a stem */
  call stream configfile, 'c', 'open read'
  index=0
  do while lines( configfile )
    index=index+1
    config_lines.index = linein( configfile )
  end
  config_lines.0=index
  call stream configfile, 'c', 'close'

  /* remove old config.sav and write updated version */
  call SysFileDelete configfile
  call stream configfile, 'c', 'open write'
  do index=1 to config_lines.0
    select
      when pos( 'START OF THINLAPS', translate(config_lines.index))>0 then
        call clean_thinlaps
      when pos( ':\SRV', translate(config_lines.index))>0 then
        do
          if clean_srvifs(config_lines.index)=0 then
            call lineout configfile, config_lines.index
        end
      when pos( 'Z:\CID\LOCINSTU\SRVREXX.EXE', translate(config_lines.index))>0 then
        do
          NOP  /* don't write this line to config.sav */
        end
      when pos( '=\REFPART.SYS', translate(config_lines.index))>0 then /* 19078 */
        do
          NOP  /* don't write this line to config.sav */
        end
      otherwise
        call lineout configfile, config_lines.index
    end
  end
  call stream configfile, 'c', 'close'

  /* append existing lanlock file to lock stem */
  call stream lanlkfile, 'c', 'open read'
  if lines(lanlkfile) then
  do
    do until pos(d2c(26), lanlk_lines.index) | lines(lanlkfile)=0
      call add_lanlk_line linein( lanlkfile )
    end
  end
  call stream lanlkfile, 'c', 'close'

  /* append misc/SRVIFS files in root dir to lock stem */
  call add_lanlk_line os2_drive||'\OS2\INSTALL'
  call add_lanlk_line 'DEL '||os2_drive||'\SRVATTCH.EXE'
  call add_lanlk_line 'DEL '||os2_drive||'\SRVIFSC.IFS'
  call add_lanlk_line 'DEL '||os2_drive||'\SRVIFS.SYS'
  call add_lanlk_line 'DEL '||os2_drive||'\PROTOCOL.INI'
  call add_lanlk_line 'DEL '||os2_drive||'\PRO.MSG'
  call add_lanlk_line 'DEL '||os2_drive||'\OSCINST.MSG'
  call add_lanlk_line 'DEL '||os2_drive||'\LANMSGDL.DLL'
  call add_lanlk_line 'DEL '||os2_drive||'\ACSNETB.DLL'
  call add_lanlk_line 'DEL '||os2_drive||'\XI1.MSG'
  call add_lanlk_line 'DEL '||os2_drive||'\LANTRAN.LOG'
  call add_lanlk_line 'DEL '||os2_drive||'\PRO.MSG'
  call add_lanlk_line 'DEL '||os2_drive||'\LT0.MSG'
  call add_lanlk_line 'DEL '||os2_drive||'\UNPACK.EXE'
  call add_lanlk_line 'DEL '||os2_drive||'\UNPACK2.EXE'
  /* 19078 */
  call add_lanlk_line 'DEL '||os2_drive||'\REFPART.SYS'


  /* append EOF marker to lock stem */
  call add_lanlk_line d2c(26)

  /* delete old file and write out new IBMLANLK.LST file */
  lanlk_lines.0=lanlk_index
  call SysFileDelete lanlkfile
  call stream lanlkfile, 'c', 'open write'
  do index=1 to lanlk_lines.0
    call lineout lanlkfile, lanlk_lines.index
  end
  call stream lanlkfile, 'c', 'close'
return

clean_srvifs:
  parse arg test_line
  parse upper var test_line . ':\' filename ' ' .
  code = 0
  filename=strip(filename)
  if filename='SRVATTCH.EXE' | filename='SRVIFSC.IFS' | filename='SRVIFS.SYS' then
    code=1
return code

clean_thinlaps:
  index=index+1
  parse upper value config_lines.index with key '=' filename
  do until pos( 'END OF THINLAPS', key )>0
    /* add filename to lan lock list if file exists */
    full=os2_drive'\'strip(filename)
    if stream(bootfile, 'C', 'QUERY EXISTS') \= '' & strip(filename)<>'' then
      call add_lanlk_line 'DEL '||full
    index=index+1
    parse upper value config_lines.index with key '=' filename
  end
return

add_lanlk_line:
  parse arg lanline
  lanlk_index=lanlk_index+1
  lanlk_lines.lanlk_index = lanline
return


