/*************************************************************************/
/* Licensed Materials - Property of IBM                                   */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1996.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/*cleanup.cmd*/

call RxFuncAdd 'GetBootDrive', 'RLANUTIL', 'GetBootDrive'

parse arg bootdrive

bootdrive=left(strip(bootdrive),1) || ':'

if bootdrive = ':' then
  bootdrive = GetBootDrive()

startup = bootdrive'\startup.cmd'
csys = bootdrive'\config.sys'

/* Rename the tutorial */
'@ren 'bootdrive'\OS2\TUTORIAL.EXX TUTORIAL.EXE 1>nul 2>nul'

/* Delete all the files we stick in different places */
'@del 'bootdrive'\OS2\PROGRESS.EXE 1>nul 2>nul'
'@del 'bootdrive'\OS2\WRAPPER.EXE 1>nul 2>nul'
'@del 'bootdrive'\CONINST.EXE 1>nul 2>nul'
'@del 'bootdrive'\tmp\coninst.exe 1>nul 2>nul'
'@del 'bootdrive'\startup.bak 1>nul 2>nul'
'@del 'bootdrive'\startup.ws 1>nul 2>nul'
'@del 'bootdrive'\chkforcd.cmd 1>nul 2>nul'
'@del 'bootdrive'\wspcnt.cpt 1>nul 2>nul'


bkdir = '\OS2\INSTALL\IBMINST.BAK'
currdir = directory()

/* Have to be in the correct directory to move */
call directory bootdrive'\'

/* Move the backup files to the IBMINST.bak directory */
'@move \config.00? 'bkdir' >nul 2>nul'
'@move \config.mpt 'bkdir' >nul 2>nul'
'@move \config.tcp 'bkdir' >nul 2>nul'
'@move \config.epw 'bkdir' >nul 2>nul'
'@move \startup.00? 'bkdir' >nul 2>nul'
'@move dump.out 'bkdir' >nul 2>nul'

call directory currdir

/* If the startup file exists, open it */
if stream(startup, 'C', 'QUERY EXISTS') \= '' then call stream startup, 'C', 'OPEN'
i = 0
do while lines(startup) > 0
   i = i + 1
   startup.i = strip(linein(startup))
end /* do */
call stream startup, 'C', 'CLOSE'
startup.0 = i

/* Set the variable for the backup file */
startbak = bootdrive'\wsrvstr1.cmd'

/* Do for each line of the startup.cmd */
startup_has_lines = 0
do j = 1 to startup.0
   writeline = 1

   /* Look for wrapper.exe */
   if lastpos('WRAPPER.EXE', translate(startup.j)) > 0 then writeline = 0

   /* Look for ishield.exe */
   if lastpos('ISHIELD.EXE', translate(startup.j)) > 0 then writeline = 0

   /* Look for \IBMINST */
   if lastpos(' \IBMINST', translate(startup.j)) > 0 then writeline = 0

   /* Look for the casagent line */
   else if lastpos('CASAGENT', startup.j) > 0 then writeline = 0

   /* Look for call to CD */
   else if lastpos('CHKFORCD', translate(startup.j)) > 0 then writeline = 0

   else if strip(startup.j) = '@echo off' then writeline = 0

   /* Strip out CMD's and EXIT's */
   else if strip(startup.j) = 'CMD' then writeline = 0
   else if strip(translate(startup.j)) = 'EXIT' then writeline = 0

   /* If the line should be written, then write it */
   if writeline then do
      call lineout startbak, strip(startup.j)
      startup_has_lines = 1
   end
end /* do */

/* Append a final exit if the file is not 0 length */
if startup_has_lines then do
   call lineout startbak, 'EXIT'
   call stream startbak, 'C', 'CLOSE'
   '@copy 'startbak startup' 1>nul 2>nul'
   '@del 'startbak' 1>nul 2>nul'
end

else '@del 'startup' 1>nul 2>nul'

/* Open the config.sys */
if stream(csys, 'C', 'QUERY EXISTS') \= '' then call stream csys, 'C', 'OPEN'

/* Read it into a stem */
i = 0
do while lines(csys) > 0
   i = i + 1
   csys.i = linein(csys)
end /* do */
call stream csys, 'C', 'CLOSE'
csys.0 = i

/* Set the Removeobject found flag */
rmindex = 0

/* Set the flag to not update the config.sys */
update_csys = 0

/* Set the backup file */
cbak = bootdrive'\wscfgsys.tmp'

/* Do set up for NetFinity filter */
lc = 0; nfdasdindex = 0; ibm2scsiindex = 0

do j = 1 to csys.0
   writeline = 1
   parse var csys.j sw1 kw'='kwval

   /* Find the DPATH */
   if kw = 'DPATH' then do
      kwval = translate(kwval)
      csys.j = translate(csys.j)

      /* Pull out SRVIFSRQ if it exists */
      if pos('\SRVIFSRQ', kwval) > 0 then do
         parse var kwval first '\SRVIFSRQ;' last
         kwval = left(first, length(first)-2)||last
         csys.j = sw1' 'kw'='kwval
         update_csys = 1
      end

      /* Pull out \LOCINSTU, if it exists */
      if lastpos('\LOCINSTU;', csys.j) > 0 then do
         parse var kwval first ':\CID\LOCINSTU;' last
         first = left(first, length(first)-1)
         csys.j = sw1' 'kw'='first || last
         update_csys = 1
      end  /* Do */

      /* Pull out \CID\DLL\OS2, if it exists */
      if lastpos('\CID\DLL\OS2;', csys.j) > 0 then do
         parse var kwval first ':\CID\DLL\OS2;' last
         first = left(first, length(first)-1)
         csys.j = sw1' 'kw'='first || last
         update_csys = 1
      end  /* Do */
   end /* Do */

   /* Find the LIBPATH */
   else if left(strip(csys.j),7) = 'LIBPATH' then do
      parse upper var csys.j kw'='kwval

      /* Remove \CID\LOCINSTU */
      if lastpos(':\CID\LOCINSTU;', kwval) > 0 then do
         parse var kwval first ':\CID\LOCINSTU;' last
         first = left(first, length(first)-1)
         csys.j = kw'='first || last
         update_csys = 1
      end  /* Do */

      /* Remove \OS2\DLL */
      if lastpos(';\OS2\DLL;', kwval) > 0 then do
         parse var kwval first ';\OS2\DLL' last
         csys.j = kw'='first||last
         update_csys = 1
      end  /* Do */
      if lastpos('\CID\DLL\OS2', kwval) > 0 then do
         parse var kwval first '\CID\DLL\OS2' last
         csys.j = kw'='first||last
         update_csys = 1
      end  /* Do */
   end  /* Do */

   /* Remove all the junk that CAS, THINLAPS, and THINIFS put in */
   else if lastpos('CAS_', csys.j) > 0 then writeline = 0
   else if lastpos('SRVREXX', translate(csys.j)) > 0 then writeline = 0

   else if strip(csys.j) = 'REM IBMINST: REMOVE NEXT LINE' then do
      rmindex = j
      writeline = 0
   end  /* Do */

   else if lastpos('RESTARTOBJECTS=NO', translate(csys.j)) > 0 & j = rmindex + 1 then
      writeline = 0

   else if translate(left(strip(csys.j),7)) = 'THREADS' & kwval < 1024 then do
      csys.j = 'THREADS=1024'
      update_csys = 1
   end  /* Do */

   else if pos('NFDASD.FLT', translate(csys.j)) > 0 & left(strip(translate(csys.j)),3) \= 'REM' then
      nfdasdindex = lc + 1

   else if pos('IBM2SCSI.ADD', translate(csys.j)) > 0 & left(strip(translate(csys.i)),j) \= 'REM' then
      ibm2scsiindex = lc + 1

   if writeline then do

      lc = lc + 1
      cbakfil.lc = csys.j

   end

   else update_csys = 1

end /* do */

if nfdasdindex > 0 & ibm2scsiindex = 0 then do
   cbakfil.nfdasdindex = 'REM ' || cbakfil.nfdasdindex
   update_csys = 1
end

if update_csys then do

   do j = 1 to lc
      call lineout cbak, cbakfil.j
   end /* do */

   call stream cbak, 'C', 'CLOSE'

   '@copy 'cbak csys' >nul 2>&1'
   '@del 'cbak' 1>nul 2>nul'

end

RETURN 0
