/*************************************************************************/
/* Licensed Materials - Property of IBM                                   */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1995.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/* RMVNSC.CMD */

/* This program will remove NSC from the machine */

call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
call RxFuncAdd "SysGetMessage", "RexxUtil", "SysGetMessage"
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysRmDir', 'RexxUtil', 'SysRmDir'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

dpathstr = value("DPATH",,"OS2ENVIRONMENT")
dpathstr = translate(dpathstr)
parse var dpathstr first '\OS2\' .
os2drv = right(first,2)

csys = os2drv'\config.sys'

foundnsc = 0
i = 0
call stream csys, 'C', 'open'
do while lines(csys) \= 0
   i = i + 1
   cfil.i = linein(csys)
   inline = translate(cfil.i)
   if lastpos('LIBPATH',inline) > 0 & lastpos('NSC', inline) > 0 then do
      parse var cfil.i first':\NSC\DLL;'last
      nscdrv = right(first,1)||':'
      first = left(first, length(first)-2)
      cfil.i = first';'last
      foundnsc = 1
   end  /* Do */
   else if lastpos('SET PATH',inline) \ = 0 & lastpos('NSC', inline) > 0 then do
      parse var cfil.i first':\NSC;'last
      first = left(first, length(first)-2)
      cfil.i = first';'last
      foundnsc = 1
   end  /* Do */
   else if lastpos('SET DPATH',inline) \ = 0 & lastpos('NSC', inline) > 0 then do
      parse var cfil.i first':\NSC;'last
      first = left(first, length(first)-2)
      cfil.i = first';'last
      foundnsc = 1
   end /* Do */
end /* do */
cfil.0 = i
call lineout csys

/* Never, never, never ask anyone to explain the following, they do,
    however, work... */
/* DO NOT!!! Touch the next 5 lines */
msg1 = SysGetMessage(57, "NPINST.MSG")
msg1 = strip(msg1,,D2C(10))
msg1 = strip(msg1,,D2C(13))
msg1 = strip(msg1,,D2C(13))
msg1 = strip(msg1,,D2C(10))


titlebar = strip(strip(SysGetMessage(54, "NPINST.MSG"),,D2C(13)),,D2C(10))
'@popup " 'msg1' "  "'titlebar'" '

call SysFileTree nscdrv'\NSC\*.*', 'fstem', 'SFO'
call SysFileTree nscdrv'\NSC\*.*', 'dstem', 'SDO'

if foundnsc = 1 then do
   locked=0
   do i = 1 to fstem.0
      rc=SysFileDelete(fstem.i)
      if rc \= 0 then locked = 1
   end
   do i = 1 to dstem.0
      rc=SysRmDir(dstem.i)
      if rc \= 0 then locked = 1
   end
   rc = SysRmDir(nscdrv'\NSC')
   if rc \= 0 then locked = 1
end

if locked = 1 then do
   lanlkfil = os2drv'\OS2\INSTALL\NSCLK.LOG'
   line2='RUN='os2drv'\OS2\INSTALL\IBMLANLK.EXE 'lanlkfil
   line3='RMTREE 'nscdrv'\NSC'
   eofline = d2c(26)
   index = 2
   do i = 1 to cfil.0
      line1 = translate(cfil.i)
      if pos('HPFS', cfil.i) > 0 & pos('.IFS', cfil.i) > 0 then index = i
   end /* do */
   do i = 1 to index
      nfil.i = cfil.i
   end /* do */
   nfil.i = line2
   startc = index + 1
   do i = startc to cfil.0
      bump = i + 1
      nfil.bump = cfil.i
   end /* do */

   do i = 1 to bump
      cfil.i = nfil.i
   end /* do */
   cfil.0 = bump

   /* Write the LANLK file */
   call stream lanlkfil, 'C', 'OPEN'
   call lineout lanlkfil, line3
   call lineout lanlkfil, eofline
   call lineout lanlkfil
end  /* Do */

/* Delete the config.sys, re-write it */
'@del 'csys '1>nul 2>nul'
call stream csys, 'C', 'OPEN'
do j = 1 to cfil.0
  call lineout csys, cfil.j
end /* do */
call lineout csys

call SysDestroyObject '<NSC_RETRY>'
call SysDestroyObject '<NSC_REF>'
call SysDestroyObject '<NSC_PM>'
call SysDestroyObject '<NSC_SERVER>'
call SysDestroyObject '<NSC_FOLDER>'
call SysDestroyObject '<NSC_REMOVE>'

RETURN 0
