/*************************************************************************/
/* Licensed Materials - Property of IBM                                   */
/*                                                                       */
/* XXXX-XXX                                                              */
/*                                                                       */
/* (C) Copyright IBM Corp. 1995.  All Rights Reserved.                   */
/*                                                                       */
/* US Government Users Restricted - Use, duplication, or                 */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.     */
/*                                                                       */
/*************************************************************************/

/***********************************************************************/
/* RSTLANLK.CMD                                                        */
/* This command file will take the merged ibmlanlk.lst file and put    */
/* it back into the config.sys                                         */
/***********************************************************************/
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

parse ARG bootdrive cddrive state .

configsys = bootdrive || '\CONFIG.SYS'
Temp_LANLK_List_File = bootdrive || '\OS2\INSTALL\CLTLANLK.LST'
LK_List_File = bootdrive || '\OS2\INSTALL\IBMLANLK.LST'

/* Added retry to see if config.sys is being used by someone else */
rc = stream(configsys, 'C', 'OPEN')
if rc \= 'READY:' then do
   sleepcnt = 0
   do until rc = 'READY:' | sleepcnt > 12
      say ''
      call SysSleep 5
      sleepcnt = sleepcnt + 1
      rc = stream(configsys, 'C', 'OPEN')
   end /* do */
end  /* Do */
call stream configsys, 'C', 'CLOSE'
if rc \= 'READY:' then RETURN 40

call SysFileTree Temp_LANLK_List_File, file, F
if file.0 > 0 then
Do
  ThisLine = LineIn(Temp_LANLK_List_File)      /* Get Path to ibmlanlk.sys   */
  parse upper var ThisLine DriverPath

  do while Lines(Temp_LANLK_List_File) > 0     /* Copy merged list file back */
    ThisLine = LineIn(Temp_LANLK_List_File)
    rc = LineOut(LK_List_File, ThisLine)
  end

  if translate(left(strip(cddrive),1)) = 'Z' & state = 1 then do
     rc = Lineout(LK_List_File,'RMTREE 'bootdrive'\SRVIFSRQ')
  end  /* Do */

  rc = LineOut(Temp_LANLK_List_File)
  '@' || cddrive || '\CID\EXE\OS2\attrib -r 'configsys'  '
  '@erase' Temp_LANLK_List_File' 1>nul 2>nul '

  s = 0
  Found_HPFS386 = 0

  Do Until (Lines(configsys) = 0)              /* Read in config.sys and     */
     s = s + 1                                 /* Look for ifs=hpfs          */
     csys.s = LineIn(configsys)
     tst = Pos('HPFS',csys.s)
     tst2 = Pos('IFS',csys.s)
     If ((tst > 0) & (tst2 > 0)) then Found_HPFS386 = 1
  End
  csys.0 = s
  rc = LineOut(configsys)

  '@erase' configsys' 1>nul 2>nul '
  if rc \= 0 then do
    sleepcnt = 0
    do until rc = 0 | sleepcnt > 30
       say ''
      call SysSleep 5
      sleepcnt = sleepcnt + 1
      '@erase' configsys' 1>nul 2>nul '
    end /* do */
  end  /* Do */
  if rc \= 0 then RETURN 40


                                   /* Put IBMLANLK line back into config.sys */
  if (Found_HPFS386 = 0) then                  /* Put lines at top of file   */
    Do
      Found_GrpWare = 0
      Found_OS2clnt = 0
      rc = lineout(configsys, 'DEVICE='|| DriverPath || '\IBMLANLK.SYS '|| LK_List_File)
      rc = lineout(configsys, 'RUN='|| DriverPath || '\IBMLANLK.EXE '|| LK_List_File)
      do s = 1 to Csys.0
        line = translate(Csys.s)
        tst = pos(':\GRPWARE', line)
        if (tst > 0) then
          do
            Found_GrpWare = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\GRPWARE' .
            GrpWareDrive = right(first, 2)
            drop line
            drop first
          end
        line = translate(Csys.s)
        tst = pos(':\OS2CLNT', line)
        if (tst > 0) then
          do
            Found_OS2clnt = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\OS2CLNT' .
            OS2clntDrive = right(first, 2)
            drop line
            drop first
          end
        rc = lineout(configsys, Csys.s)
      end
      rc = lineout(configsys)

    End
  else                                          /* put lines after hpfs line */
    Do
      csys_Changed = 0
      Found_GrpWare = 0
      Found_OS2clnt = 0
      do s = 1 to Csys.0
        line = translate(Csys.s)
        tst = pos(':\GRPWARE', line)
        if (tst > 0) then
          do
            Found_GrpWare = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\GRPWARE' .
            GrpWareDrive = right(first, 2)
            drop line
            drop first
          end
        line = translate(Csys.s)
        tst = pos(':\OS2CLNT', line)
        if (tst > 0) then
          do
            Found_OS2clnt = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\OS2CLNT' .
            OS2clntDrive = right(first, 2)
            drop line
            drop first
          end
        rc = lineout(configsys, Csys.s)
        tst = Pos('HPFS',csys.s)
        tst2 = Pos('IFS',csys.s)
        If ((tst > 0) & (tst2 > 0) & (csys_Changed = 0)) then
          do
            rc = lineout(configsys, 'DEVICE='|| DriverPath || '\IBMLANLK.SYS '|| LK_List_File)
            rc = lineout(configsys, 'RUN='|| DriverPath || '\IBMLANLK.EXE '|| LK_List_File)
            csys_Changed = 1
          end
      end
      rc = lineout(configsys)

    End
  if (Found_GrpWare = 1) then
  do
    rc = Lineout(LK_List_File,'RMTREE 'GrpWareDrive'\GRPWARE')
  end
  if (Found_OS2clnt = 1) then
  do
    rc = Lineout(LK_List_File,'RMTREE 'OS2clntDrive'\OS2CLNT')
  end
  rc = LineOut(LK_List_File,'1a'x)
  rc = LineOut(LK_List_File)
End

else if translate(left(strip(cddrive),1)) = 'Z' & state = 1 then do

  rc = Lineout(LK_List_File,'RMTREE 'bootdrive'\SRVIFSRQ')

  '@' || cddrive || '\CID\EXE\OS2\attrib -r 'configsys'  '

  DriverPath = bootdrive || '\OS2\INSTALL'

  s = 0
  Found_HPFS386 = 0

  Do Until (Lines(configsys) = 0)              /* Read in config.sys and     */
     s = s + 1                                 /* Look for ifs=hpfs          */
     csys.s = LineIn(configsys)
     tst = Pos('HPFS',csys.s)
     tst2 = Pos('IFS',csys.s)
     If ((tst > 0) & (tst2 > 0)) then Found_HPFS386 = 1
  End
  csys.0 = s
  rc = LineOut(configsys)

  '@erase' configsys' 1>nul 2>nul '

                                   /* Put IBMLANLK line back into config.sys */
  if (Found_HPFS386 = 0) then                  /* Put lines at top of file   */
    Do
      Found_GrpWare = 0
      Found_OS2clnt = 0
      rc = lineout(configsys, 'DEVICE='|| DriverPath || '\IBMLANLK.SYS '|| LK_List_File)
      rc = lineout(configsys, 'RUN='|| DriverPath || '\IBMLANLK.EXE '|| LK_List_File)
      do s = 1 to Csys.0
        line = translate(Csys.s)
        tst = pos(':\GRPWARE', line)
        if (tst > 0) then
          do
            Found_GrpWare = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\GRPWARE' .
            GrpWareDrive = right(first, 2)
            drop line
            drop first
          end
        line = translate(Csys.s)
        tst = pos(':\OS2CLNT', line)
        if (tst > 0) then
          do
            Found_OS2clnt = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\OS2CLNT' .
            OS2clntDrive = right(first, 2)
            drop line
            drop first
          end
        rc = lineout(configsys, Csys.s)
      end
      rc = lineout(configsys)

    End
  else                                          /* put lines after hpfs line */
    Do
      csys_Changed = 0
      Found_GrpWare = 0
      Found_OS2clnt = 0
      do s = 1 to Csys.0
        line = translate(Csys.s)
        tst = pos(':\GRPWARE', line)
        if (tst > 0) then
          do
            Found_GrpWare = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\GRPWARE' .
            GrpWareDrive = right(first, 2)
            drop line
            drop first
          end
        line = translate(Csys.s)
        tst = pos(':\OS2CLNT', line)
        if (tst > 0) then
          do
            Found_OS2clnt = 1
            Csys.s = substr(Csys.s,1,tst-1) || substr(Csys.s,tst +11)
            parse var line first'\OS2CLNT' .
            OS2clntDrive = right(first, 2)
            drop line
            drop first
          end
        rc = lineout(configsys, Csys.s)
        tst = Pos('HPFS',csys.s)
        tst2 = Pos('IFS',csys.s)
        If ((tst > 0) & (tst2 > 0) & (csys_Changed = 0)) then
        do
          rc = lineout(configsys, 'DEVICE='|| DriverPath || '\IBMLANLK.SYS '|| LK_List_File)
          rc = lineout(configsys, 'RUN='|| DriverPath || '\IBMLANLK.EXE '|| LK_List_File)
          csys_Changed = 1
        end
      end
      rc = lineout(configsys)

    End
  if (Found_GrpWare = 1) then
  do
    rc = Lineout(LK_List_File,'RMTREE 'GrpWareDrive'\GRPWARE')
  end
  if (Found_OS2clnt = 1) then
  do
    rc = Lineout(LK_List_File,'RMTREE 'OS2clntDrive'\OS2CLNT')
  end
  rc = LineOut(LK_List_File,'1a'x)
  rc = LineOut(LK_List_File)
End

RETURN 0

