/*     */
    /*
    * ********************************************************************
    * *             Copyright (c) IBM Corporation, 1995                  *
    * *                     All Rights Reserved                          *
    * ********************************************************************
    *
    *
    * DESCRIPTION: This REXX command file is to be used to make changes
    *              to CONFIG.SYS for IBM Microchannel PS/2's in order
    *              to install Microsoft applications that are in DMF
    *              format on your IBM PS/2 Microchannel system.
    *
    */

   /*      trace I */
    call init

    /* Get the version of the current OS/2 system. */
    version = SysOs2Ver()
    if version < '2.30' then  /* 2.30 represents Warp version. */
      do
        say 'This command file does not work with this version of OS/2.'
        say 'Program ended.'
        exit
      end
    "@cls"
    Say ' '
    Say ' '
    Say ' '
    Say 'This program enables users of OS/2 Warp running on IBM PS/2''s'
    Say 'to install software provided on diskettes formatted in the'
    Say 'non-standard DMF format.'
    Say ' '
    Say 'This program will modify your CONFIG.SYS file to allow DMF'
    Say 'diskettes to be read. Once the DMF software is installed you'
    Say 'should run this program again, using the R option to restore'
    Say 'your original CONFIG.SYS file.'
    Say ' '
    Say 'To modify your OS/2 Warp CONFIG.SYS file to provide support'
    Say 'for installing from DMF format diskettes, enter M for modify'
    Say ' '
    Say 'To undo any DMF-related changes to your OS/2 Warp CONFIG.SYS'
    Say 'file, enter R for Restore'
    Say ' '
    Say 'To exit this program without making changes, enter E for Exit'
    Say ' '
    Say 'Answer M (Modify), or R (Restore), or E (Exit).'

    parse upper pull answer .   /* Get the answer */

    if (answer='E' | answer='EXIT') then    /* If answer is exit then exit */
      say 'Exiting command file!'

    else if (answer='RESTORE' | answer='R') then
      call UNDO    /* If the answer is UNDO then go to the UNDO Subroutine */

    else if (answer='M' | answer = 'MODIFY') then
     do           /* If the answer is Modify then modify config.sys */
      '@cls'
      say ' '
      say ' '
      say ' '
      say 'On which drive is your OS/2 Warp system installed?'
      say 'Enter drive letter or path (example C:\)'
      say ''

        /* Check whether the given drive is valid. */
        call Checkdrive        /* GO to the Checkdrive subroutine */

        fname=drive'\config.sys' /* Assign drive letter and path for config.sys */

        /* Check whether config.sys exists. */
        call sysfiletree fname, 'files.', 'F'

        if files.0 < 1 then
          do
            say 'CONFIG.SYS file not found.'
            say 'Program ended.'
            exit
          end

        sname=drive'\config.dmf'  /* Assign drive letter and path to */
                                  /* config.sys back up file name */

        /* Check whether config.dmf exists. */
        call sysfiletree sname, 'files.', 'F'

        if files.0 >= 1 then
          do
            say 'Config.dmf exists. Do you want to overwrite it (Y/N)?'

            parse upper pull answer
            answer = left(answer,1)
            if answer = 'N' then
              do
                say 'Rename or delete config.dmf before rerunning dmf_ps2.'
                exit
              end
          end

        nname=drive'\config1.tmp'  /* Assign drive letter and path to */
                                   /* temporary file */

        say 'Running ........'
        say ' '
        "@copy" fname sname ">nul 2>nul" /* Backup config.sys */

        call lineout nname,,1
        do while lines(fname)   /* Parse through config.sys looking for */
           str = linein(fname)  /* the string to be modified */
           basedev = (substr(str,1,20))  /* Only need to look at first 20 */
                                         /* characters of the line */
           select
              when substr(basedev,1,20) == 'BASEDEV=IBM1FLPY.ADD' then do
                  if left(reverse(str), 4) \= 'ACM/' then do
                    call lineout nname, str '/MCA'  /* Add /MCA option to */
                    end                             /* IBM1FLPY.ADD driver */
                  else
                    call lineout nname, str
                    end
              when substr(basedev,1,20) == 'BASEDEV=IBM2FLPY.ADD' then do
                    call lineout nname, 'REM' str /* REM out the */
                    end                           /* IBM2FLPY.ADD driver */
              otherwise do
                    call lineout nname, str
                    end
           end
         end

         call lineout fname
         call lineout nname
         "@copy" nname fname ">nul 2>nul"
         "@erase" nname
         "@cls"


         say ''
         say ''
         say ''
         say ''
         say 'Changes made to file' fname
         say ''
         say 'Your CONFIG.SYS file has been modified. The original version'
         say 'has been backed up as CONFIG.DMF. In order for the changes to'
         say 'take effect, use the Shutdown command, then restart your system.'
         say ''
         say 'Once the DMF applications have been installed, please re-run'
         say 'DMF_PS2 with the R (Restore) option, to set the system back to'
         say 'its original state.'

      end
    else
        say 'Unknown answer.'
        say 'Program ended.'

exit

UNDO:
    '@cls'
    say ' '
    say ' '
    say ' '
    say 'On which drive is your OS/2 Warp system installed?'
    say 'Enter drive letter or path (example C:\)'
    say ' '

    call Checkdrive

    fname=drive'\config.sys'

    call sysfiletree fname, 'files.', 'F'
    if files.0 < 1 then
      do
        say 'CONFIG.SYS file not found.'
        say 'Program ended.'
        exit
      end

    nname=drive'\config1.tmp'

    do while lines(fname)            /* This section of code is to check the */
      str = linein(fname)            /* config.sys to see if the DMF changes */
      basedev = (substr(str,1,24))   /* need to be UNDone. */
      select
        when substr(basedev,1,20) == 'BASEDEV=IBM2FLPY.ADD' then do
             "@CLS"
             say ' '                  /* If it finds this then display */
             say ' '                  /* Message */
             say ' '
             say 'CONFIG.SYS does not contain DMF changes'
             say 'Nothing to UNDO'
             say 'Program ended.'
             call exit
             end
        when substr(basedev,1,24) == 'REM BASEDEV=IBM2FLPY.ADD' then do
             call lineout nname
             call lineout fname         /* If it finds this then lets */
             call undo2                 /* call undo2 to really undo the */
             end                        /* DMF changes */
        otherwise do
              call lineout nname, str
              end
    end
  end
EXIT:
    call lineout nname
    "@ERASE" nname
    exit

UNDO2:

   "@erase" nname

    nname=drive'\config1.tmp'

    call lineout nname,,1
    do while lines(fname)
      str = linein(fname)
      basedev = (substr(str,1,24))

      select
        when substr(basedev,1,24) == 'REM BASEDEV=IBM2FLPY.ADD' then do
              newstr = (subword(str,2))
              call lineout nname, newstr
              end
        when substr(basedev,1,20) == 'BASEDEV=IBM1FLPY.ADD' then do
              parse var str final remaining
              num_item = words(remaining)
              do p = 1 to num_item
                if strip(word(remaining, p)) \= '/MCA' then
                  final = final || ' 'word(remaining, p)
              end
              call lineout nname, final
              end
        otherwise do
              call lineout nname, str
              end
      end
    end
    call lineout fname
    call lineout nname
    "@copy" nname fname ">nul 2>nul"
    "@erase" nname
    "@cls"


    say ''
    say ''
    say ''
    say ''
    say 'Your CONFIG.SYS file has been restored. In order for the changes'
    say 'to take effect, use the shutdown command, then restart your system'
    say ''
exit

CheckDrive:
    /* Get all the local drive letters. */
    drivemap = sysdrivemap('c:', 'LOCAL')

    parse upper pull drive .

    drive = strip(translate(drive, ' ', '\'))
    num_item = words(drive)
    if num_item > 1 then
      do
        say 'Drive not recognized.'
        say 'Program ended.'
        exit
      end
    found = 'NO'
    do while drivemap \= ''
      parse var drivemap head tail
      drivemap = tail
      head = strip(head)
      if head = drive then
         found = 'YES'
    end

    if found = 'NO' then
      do
        say 'Drive not recognized.'
        say 'Program ended.'
      end
return

/* Load in the extra function library. WPW001 */
Init: Procedure

    /* Load in the extra function library */
    if RxFuncQuery('SysLoadFuncs') then do
        Call RXFuncAdd 'SysLoadFuncs','RexxUtil','SysloadFuncs'
    end
    Call SysLoadFuncs
return
