/* This program is a random number generator */
/* Written by: Raheem Rhemtulla */

/* The syntax to use this program is:
	=rexx("random.fnc",0,1,max)

	max - the maximum number. The program will calculate a random number between 0 and the maximum number.

If any incorrect data is entered, the program will return a value of -1. */

/* To use this program, ensure that Auto Recalc is turned off, otherwise the program will generate new random numbers every time the Spreadsheet updates */
/* Also do not sort the numbers, since the sort will recalculate the highllghted area and will cause the random number generator to produce new numbers. */

/* trace results */

parse arg max
/* This checks to make sure 'max' is composed only of numbers */
error_check = verify(max,'1234567890')
/* This if checks whether max is a valid number. */
if error_check = 0 then
  valid_max = 1
/* This if checks to make sure a number was entered */
if length(max) = 0 then
  valid_max = 0
/* This if checks to make sure the number is not too big. */
if (length(max) < 9) & (valid_max =1) then
   do
    number = random(max)
    return number
  end
else
 return -1

/* trace off */
