/*****************************************************************************/
/*                                                                           */
/*   IBM VoiceType Dictation System                                          */
/*   Licensed Materials -  Property of IBM                                   */
/*  (C) Copyright International Business Machine Corp, 1996.                 */
/*                                                                           */
/*****************************************************************************/

  Parse Upper Arg operation var1

  Signal On NOTREADY

  Call RXFUNCADD 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SYSLOADFUNCS
  '@echo off'
  CURDIR = directory()
  PATH_DATA = value(PATH,,os2environment)
  OLD_PATH = value('PATH_DATA')
  installdir = ""                     /* Software Installer puts stuff here   */
  finaldir = left(value(SPCH_RO,,os2environment),1)
  finaldir = finaldir || ":\vt\spch_ro\langs\"    /* The vocabs should finally  be here   */
  driveletter = "a:"                  /* vocabualaries are read from  here    */
  migrate = 0                         /* 0 - no need to migrate               */

  RUN_PATH = value(SPCH_RUN,,os2environment)
  if right(RUN_PATH,1) \= '\' then
     RUN_PATH = RUN_PATH || '\'

  ilmlogfile = RUN_PATH || 'ilm2.log'

  Call GetDriveLetter  driveletter packagefile catalogfile
  if (length(domain) = 5) then do
     Call GetVersionNumber driveletter catalogfile migrate
     if migrate > 0 then do
        rc = SysFileDelete(ilmlogfile)
        Call InstallVocabularies catalogfile ilmlogfile
        Call MigrateVocabularies installdir finaldir domain ilmlogfile
        call MigrateCleanup installdir
     end
  end
  call directory CURDIR

Return 0

/*****************************************************/
/* TRAP  on NOTREADY ( I/O errors reported here )    */
/*****************************************************/
NOTREADY:
Return -1


/*****************************************************************************/
/*                                                                           */
/* Function:    GetDriveLetter                                               */
/* Description: Get drive letter of the medium from media dialog             */
/*                                                                           */
/* Operation:                                                                */
/*   Media dialog writes out the drive letter/file name to vocdir.da_ file.  */
/*****************************************************************************/
GetDriveLetter: procedure expose driveletter packagefile catalogfile domain
  env = 'OS2ENVIRONMENT'
  InFile = ''
  InFile = value('SPCH_RUN',,env)
  if InFile \= '' then do
     if Right(InFile,1) \= '\' then
        InFile = InFile || '\'
  end
  InFile = InFile || "vocdir.da_"

  rc = SysFileDelete(InFile)

  'vocab'
                          /* show media dialog and get the drive letter*/
                               /* written to a file */
  catalogfile = ""

  call SysFileTree InFile, 'result', 'F'
  if result.0 \= 1 then do
     /* Must not have been successful...*/
     exit 98
  end

  do while Lines(InFile) > 0
     line1 = strip(Linein(InFile))
  end
  Rc = Lineout(InFile)        /* Close it */
  parse var line1 packagefile catalogfile domain
  driveletter = left(packagefile,2)

  catalogfile = driveletter || "\OS2\" || strip(catalogfile)
  domain = strip(domain)
return

/*****************************************************************************/
/*                                                                           */
/* Function:    GetVersionNumber                                             */
/* Description: Get version number from the catalog file                     */
/*                                                                           */
/* Inputs:      driveletter                                                  */
/*              catalogfile                                                  */
/* Output:      migrate        1 for migration                               */
/* Operation:                                                                */
/*   Scans the catalog file for the key word VRM and get the version number  */
/*   Return the migrate flag set to true for version 1.x                     */
/*****************************************************************************/
GetVersionNumber: procedure expose driveletter catalogfile migrate
  /* read version number from the catalog file and set migrate flag */
  do while Lines(catalogfile) > 0
     aline = strip(Linein(catalogfile))
     if (pos('VRM',aline)) = 1 then do
        if (pos('=',aline)) > 0 then do
           i = pos('=',aline)
           vrm = substr(aline,i+2,20)
           vrm = strip(vrm)
           migrate = 0
           if (vrm = "'010100',") | (vrm = "'010200',") then
              migrate = 1
        end

     end
  end
  Rc = Lineout(catalogfile)        /* Close it */
return


/*****************************************************************************/
/*                                                                           */
/* Function:    InstallVocabularies                                          */
/* Description: Installvocabularies from the medium to the machine           */
/*                                                                           */
/* Inputs:                                                                   */
/*              catalogfile                                                  */
/* Operation:                                                                */
/*   Saves current environment.                                              */
/*   Passes control to the Software Installer on the medium                  */
/*   Let the SI install the vocabularies in its old place. We will use this  */
/*   as the temporary directory.                                             */
/*   Assume the a:\os2 directory for the os2 stuff on the medium             */
/*****************************************************************************/
InstallVocabularies:  procedure expose catalogfile ilmlogfile
  CURDIR = directory()
  PATH_DATA = value(PATH,,os2environment)
  OLD_PATH = value('PATH_DATA')

  driveletter = left(catalogfile,2)
  installdir = driveletter || '\os2'
  INSTALLPATH = installdir || ';'

  installpgm = installdir || '\install.exe'
  call SysFileTree installdir||'\*.exe', 'result', 'F'
  do x = 1 to result.0 by 1
     if right(translate(word(result.x,5)),12) \= 'SPCIUPCK.EXE' then do
        installpgm = word(result.x,5)
        Leave
     end
  end

  '@'driveletter '& cd \os2'

  PATH_DATA = insert(value('INSTALLPATH'),value('PATH_DATA'),0,,)
  'set path ='value('PATH_DATA')

  '@'installpgm '/L2:'ilmlogfile

  call SysFileTree ilmlogfile, 'result', 'F'
  if result.0 \= 1 then do
     /* user must have canceled...*/
     exit 99
  end

  'set path ='value('OLD_PATH')
  call directory CURDIR

return

/*****************************************************************************/
/*                                                                           */
/* Function:    MigrateVocabularies                                          */
/* Description: Migrate vocabularies copied by the Software Installer        */
/*                                                                           */
/* Inputs:                                                                   */
/*              catalogfile                                                  */
/* Operation:                                                                */
/*   Call CNVTASK2 to migrate vocabularies                                   */
/*   Cleanup                                                                 */
/*****************************************************************************/
MigrateVocabularies:
  procedure expose installdir finaldir domain ilmlogfile
  starter = "start" || right(domain,2)           /* starter set for vocabularies */
/* scan the software installer log file for destination drive */
  installdir = ''
  LineCount = 0
  Do While Lines(ilmlogfile) > 0  /* Read ILM log into stem SLine. */
    LineCount = LineCount + 1
    SLine.LineCount = Linein(ilmlogfile)
    parse upper var SLine.LineCount tline
    if (pos('.TID',tline) > 0) then do
       if (pos('TARGET:',tline) > 0) then do
          tline = strip(tline)
          idir = word(tline,2)
          /* assume the .tid file is in the TASKS sub directory of the domain */
          i = lastpos('\',idir)
          installdir = left(idir,i-1)
          i = lastpos('\',installdir)
          installdir = left(idir,i-1)
          /* e.g.d:\spch_ro\langs\en_us  */

          /* Get the name of the .tid file, this is the domain of the vocabulary...*/
          i = lastpos('\',idir)
          vocabdomain = delstr(idir,1, i)
          vocabdomain = left(vocabdomain, length(vocabdomain) - 4)
          /* e.g. newsus */

          Leave
          end
       end
  End
  Rc = Lineout(ilmlogfile)        /* Close ILM log file               */

  outputdir = finaldir || domain

/* get the .act file from the spch_run directory */
  macro_file = ''
  macros = left(installdir,1) || ':\spch_run\*.act'
  call SysFileTree macros, 'result', 'F'
  if result.0 > 0 then do
     macro_file = word(result.1, 5)
  end

/* get the all<ll>.dct file from the spch_bin directory */
  globalmacros = value('SPCH_BIN',,'os2environment')
  globalmacros = globalmacros || '\all' || right(domain,2) || '.dct'

/* we must create the domain directory before calling cnvtask2....*/
  '@md 'outputdir'\tasks\'vocabdomain

/* call cnvtask2 for conversion of 1.x macros */
  if (installdir <> '') then do     /* a simple error check */
     'cnvtask2 ' installdir vocabdomain outputdir starter macro_file globalmacros
     call directory CURDIR
  end

  tmpindir = left(installdir,1) || ':\spch_run\*.act'
  tmpoutdir = outputdir || '\tasks\' || vocabdomain
  '@copy 'tmpindir' 'tmpoutdir
  tmpoutdir = value('SPCH_RUN',,'os2environment')
  '@copy 'tmpindir' 'tmpoutdir
return

/*****************************************************************************/
/*                                                                           */
/* Function:    MigrateCleanup                                               */
/* Description: Migrate vocabularies copied by the Software Installer        */
/*              are cleaned up here.                                         */
/* Inputs:                                                                   */
/*              installdir                                                   */
/* Operation:                                                                */
/*****************************************************************************/
MigrateCleanup:
  idir = arg(1)
  migdir =  substr(idir,1,3) || "spch_ro"
  call MigrateRemoveDirectory migdir
  migdir =  substr(idir,1,3) || "spch_run"
  call MigrateRemoveDirectory migdir
return

/*****************************************************************************/
/*                                                                           */
/* Function:    MigrateRemoveDirectory                                       */
/* Description: Delete the files and the directory and sub directories       */
/* Inputs:                                                                   */
/*              installdir                                                   */
/* Operation:                                                                */
/*****************************************************************************/
MigrateRemoveDirectory:
  migratedir = arg(1)
  /* delete all the files */
  migfiles = migratedir || "\*.*"
  call SysFileTree migfiles, 'filelist', 'FS'
  do i = filelist.0 to 1 by -1
     thisfile = word(filelist.i,5)
     rc = SysFileDelete(thisfile)
  end
  /* delete all the sub directories */
  migdirs = migratedir || "\*.*"
  call SysFileTree migdirs, 'dirlist', 'SD'
  do i = dirlist.0 to 1 by -1
     thisdir = word(dirlist.i,5)
     rc = SysRmDir(thisdir)
  end
  /* remove the root */
  rc = SysRmDir(migratedir)

return

