// OpenCP Module Player
// copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
//
// Inverse FDCT routines for MPEG audio encoding
//
// revision history: (please note changes here)
//  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
//    -first release

#include <math.h>

#define PI 3.14159265358979

static float cos_64[16];
static float cos_32[8];
static float cos_16[4];
static float cos_8[2];
static float cos_4[1];

void ifdct(float *ou, float *in)
{
  float p1[32];
  float p2[32];

  p1[0] =            in[0];
  p1[1] =cos_4[0]  *(in[16]);
  p1[2] =            in[8] -in[24];
  p1[3] =cos_4[0]  *(in[24]);
  p1[4] =            in[4] -in[12]+in[20]-in[28];
  p1[5] =cos_4[0]  *(in[20]-in[28]);
  p1[6] =            in[12]-in[20];
  p1[7] =cos_4[0]  *(in[28]);
  p1[8] =            in[2] -in[6] +in[10]-in[14]+in[18]-in[22]+in[26]-in[30];
  p1[9] =cos_4[0]  *(in[18]-in[22]+in[26]-in[30]);
  p1[10]=            in[10]-in[14]+in[18]-in[22];
  p1[11]=cos_4[0]  *(in[26]-in[30]);
  p1[12]=            in[6] -in[10]+in[22]-in[26];
  p1[13]=cos_4[0]  *(in[22]-in[26]);
  p1[14]=            in[14]-in[18];
  p1[15]=cos_4[0]  *(in[30]);
  p1[16]=            in[1] -in[3] +in[5] -in[7] +in[9] -in[11]+in[13]-in[15]+in[17]-in[19]+in[21]-in[23]+in[25]-in[27]+in[29]-in[31];
  p1[17]=cos_4[0]  *(in[17]-in[19]+in[21]-in[23]+in[25]-in[27]+in[29]-in[31]);
  p1[18]=            in[9] -in[11]+in[13]-in[15]+in[17]-in[19]+in[21]-in[23];
  p1[19]=cos_4[0]  *(in[25]-in[27]+in[29]-in[31]);
  p1[20]=            in[5] -in[7] +in[9] -in[11]+in[21]-in[23]+in[25]-in[27];
  p1[21]=cos_4[0]  *(in[21]-in[23]+in[25]-in[27]);
  p1[22]=            in[13]-in[15]+in[17]-in[19];
  p1[23]=cos_4[0]  *(in[29]-in[31]);
  p1[24]=            in[3] -in[5] +in[11]-in[13]+in[19]-in[21]+in[27]-in[29];
  p1[25]=cos_4[0]  *(in[19]-in[21]+in[27]-in[29]);
  p1[26]=            in[11]-in[13]+in[19]-in[21];
  p1[27]=cos_4[0]  *(in[27]-in[29]);
  p1[28]=            in[7] -in[9] +in[23]-in[25];
  p1[29]=cos_4[0]  *(in[23]-in[25]);
  p1[30]=            in[15]-in[17];
  p1[31]=cos_4[0]  *(in[31]);

  p2[0] =            p1[0] +p1[1];
  p2[1] =            p1[0] -p1[1];
  p2[2] =cos_8[0]  *(p1[2] +p1[3]);
  p2[3] =cos_8[1]  *(p1[2] -p1[3]);
  p2[4] =            p1[4] +p1[5];
  p2[5] =            p1[4] -p1[5];
  p2[6] =cos_8[0]  *(p1[6] +p1[7]);
  p2[7] =cos_8[1]  *(p1[6] -p1[7]);
  p2[8] =            p1[8] +p1[9];
  p2[9] =            p1[8] -p1[9];
  p2[10]=cos_8[0]  *(p1[10]+p1[11]);
  p2[11]=cos_8[1]  *(p1[10]-p1[11]);
  p2[12]=            p1[12]+p1[13];
  p2[13]=            p1[12]-p1[13];
  p2[14]=cos_8[0]  *(p1[14]+p1[15]);
  p2[15]=cos_8[1]  *(p1[14]-p1[15]);
  p2[16]=            p1[16]+p1[17];
  p2[17]=            p1[16]-p1[17];
  p2[18]=cos_8[0]  *(p1[18]+p1[19]);
  p2[19]=cos_8[1]  *(p1[18]-p1[19]);
  p2[20]=            p1[20]+p1[21];
  p2[21]=            p1[20]-p1[21];
  p2[22]=cos_8[0]  *(p1[22]+p1[23]);
  p2[23]=cos_8[1]  *(p1[22]-p1[23]);
  p2[24]=            p1[24]+p1[25];
  p2[25]=            p1[24]-p1[25];
  p2[26]=cos_8[0]  *(p1[26]+p1[27]);
  p2[27]=cos_8[1]  *(p1[26]-p1[27]);
  p2[28]=            p1[28]+p1[29];
  p2[29]=            p1[28]-p1[29];
  p2[30]=cos_8[0]  *(p1[30]+p1[31]);
  p2[31]=cos_8[1]  *(p1[30]-p1[31]);

  p1[0] =            p2[0] +p2[2];
  p1[1] =            p2[1] +p2[3];
  p1[2] =            p2[1] -p2[3];
  p1[3] =            p2[0] -p2[2];
  p1[4] =cos_16[0] *(p2[4] +p2[6]);
  p1[5] =cos_16[1] *(p2[5] +p2[7]);
  p1[6] =cos_16[2] *(p2[5] -p2[7]);
  p1[7] =cos_16[3] *(p2[4] -p2[6]);
  p1[8] =            p2[8] +p2[10];
  p1[9] =            p2[9] +p2[11];
  p1[10]=            p2[9] -p2[11];
  p1[11]=            p2[8] -p2[10];
  p1[12]=cos_16[0] *(p2[12]+p2[14]);
  p1[13]=cos_16[1] *(p2[13]+p2[15]);
  p1[14]=cos_16[2] *(p2[13]-p2[15]);
  p1[15]=cos_16[3] *(p2[12]-p2[14]);
  p1[16]=            p2[16]+p2[18];
  p1[17]=            p2[17]+p2[19];
  p1[18]=            p2[17]-p2[19];
  p1[19]=            p2[16]-p2[18];
  p1[20]=cos_16[0] *(p2[20]+p2[22]);
  p1[21]=cos_16[1] *(p2[21]+p2[23]);
  p1[22]=cos_16[2] *(p2[21]-p2[23]);
  p1[23]=cos_16[3] *(p2[20]-p2[22]);
  p1[24]=            p2[24]+p2[26];
  p1[25]=            p2[25]+p2[27];
  p1[26]=            p2[25]-p2[27];
  p1[27]=            p2[24]-p2[26];
  p1[28]=cos_16[0] *(p2[28]+p2[30]);
  p1[29]=cos_16[1] *(p2[29]+p2[31]);
  p1[30]=cos_16[2] *(p2[29]-p2[31]);
  p1[31]=cos_16[3] *(p2[28]-p2[30]);

  p2[0] =            p1[0] +p1[4];
  p2[1] =            p1[1] +p1[5];
  p2[2] =            p1[2] +p1[6];
  p2[3] =            p1[3] +p1[7];
  p2[4] =            p1[3] -p1[7];
  p2[5] =            p1[2] -p1[6];
  p2[6] =            p1[1] -p1[5];
  p2[7] =            p1[0] -p1[4];
  p2[8] =cos_32[0] *(p1[8] +p1[12]);
  p2[9] =cos_32[1] *(p1[9] +p1[13]);
  p2[10]=cos_32[2] *(p1[10]+p1[14]);
  p2[11]=cos_32[3] *(p1[11]+p1[15]);
  p2[12]=cos_32[4] *(p1[11]-p1[15]);
  p2[13]=cos_32[5] *(p1[10]-p1[14]);
  p2[14]=cos_32[6] *(p1[9] -p1[13]);
  p2[15]=cos_32[7] *(p1[8] -p1[12]);
  p2[16]=            p1[16]+p1[20];
  p2[17]=            p1[17]+p1[21];
  p2[18]=            p1[18]+p1[22];
  p2[19]=            p1[19]+p1[23];
  p2[20]=            p1[19]-p1[23];
  p2[21]=            p1[18]-p1[22];
  p2[22]=            p1[17]-p1[21];
  p2[23]=            p1[16]-p1[20];
  p2[24]=cos_32[0] *(p1[24]+p1[28]);
  p2[25]=cos_32[1] *(p1[25]+p1[29]);
  p2[26]=cos_32[2] *(p1[26]+p1[30]);
  p2[27]=cos_32[3] *(p1[27]+p1[31]);
  p2[28]=cos_32[4] *(p1[27]-p1[31]);
  p2[29]=cos_32[5] *(p1[26]-p1[30]);
  p2[30]=cos_32[6] *(p1[25]-p1[29]);
  p2[31]=cos_32[7] *(p1[24]-p1[28]);

  p1[0] =            p2[0] +p2[8];
  p1[1] =            p2[1] +p2[9];
  p1[2] =            p2[2] +p2[10];
  p1[3] =            p2[3] +p2[11];
  p1[4] =            p2[4] +p2[12];
  p1[5] =            p2[5] +p2[13];
  p1[6] =            p2[6] +p2[14];
  p1[7] =            p2[7] +p2[15];
  p1[8] =            p2[7] -p2[15];
  p1[9] =            p2[6] -p2[14];
  p1[10]=            p2[5] -p2[13];
  p1[11]=            p2[4] -p2[12];
  p1[12]=            p2[3] -p2[11];
  p1[13]=            p2[2] -p2[10];
  p1[14]=            p2[1] -p2[9];
  p1[15]=            p2[0] -p2[8];
  p1[16]=cos_64[0] *(p2[16]+p2[24]);
  p1[17]=cos_64[1] *(p2[17]+p2[25]);
  p1[18]=cos_64[2] *(p2[18]+p2[26]);
  p1[19]=cos_64[3] *(p2[19]+p2[27]);
  p1[20]=cos_64[4] *(p2[20]+p2[28]);
  p1[21]=cos_64[5] *(p2[21]+p2[29]);
  p1[22]=cos_64[6] *(p2[22]+p2[30]);
  p1[23]=cos_64[7] *(p2[23]+p2[31]);
  p1[24]=cos_64[8] *(p2[23]-p2[31]);
  p1[25]=cos_64[9] *(p2[22]-p2[30]);
  p1[26]=cos_64[10]*(p2[21]-p2[29]);
  p1[27]=cos_64[11]*(p2[20]-p2[28]);
  p1[28]=cos_64[12]*(p2[19]-p2[27]);
  p1[29]=cos_64[13]*(p2[18]-p2[26]);
  p1[30]=cos_64[14]*(p2[17]-p2[25]);
  p1[31]=cos_64[15]*(p2[16]-p2[24]);

  ou[0] =            p1[0] +p1[16];
  ou[1] =            p1[1] +p1[17];
  ou[2] =            p1[2] +p1[18];
  ou[3] =            p1[3] +p1[19];
  ou[4] =            p1[4] +p1[20];
  ou[5] =            p1[5] +p1[21];
  ou[6] =            p1[6] +p1[22];
  ou[7] =            p1[7] +p1[23];
  ou[8] =            p1[8] +p1[24];
  ou[9] =            p1[9] +p1[25];
  ou[10]=            p1[10]+p1[26];
  ou[11]=            p1[11]+p1[27];
  ou[12]=            p1[12]+p1[28];
  ou[13]=            p1[13]+p1[29];
  ou[14]=            p1[14]+p1[30];
  ou[15]=            p1[15]+p1[31];
  ou[16]=            p1[15]-p1[31];
  ou[17]=            p1[14]-p1[30];
  ou[18]=            p1[13]-p1[29];
  ou[19]=            p1[12]-p1[28];
  ou[20]=            p1[11]-p1[27];
  ou[21]=            p1[10]-p1[26];
  ou[22]=            p1[9] -p1[25];
  ou[23]=            p1[8] -p1[24];
  ou[24]=            p1[7] -p1[23];
  ou[25]=            p1[6] -p1[22];
  ou[26]=            p1[5] -p1[21];
  ou[27]=            p1[4] -p1[20];
  ou[28]=            p1[3] -p1[19];
  ou[29]=            p1[2] -p1[18];
  ou[30]=            p1[1] -p1[17];
  ou[31]=            p1[0] -p1[16];
}

void initifdct()
{
  int i;
  for (i=0; i<16; i++)
    cos_64[i]=cos(PI*(2*i+1)/64.0)*2;
  for (i=0; i<8; i++)
    cos_32[i]=cos(PI*(2*i+1)/32.0)*2;
  for (i=0; i<4; i++)
    cos_16[i]=cos(PI*(2*i+1)/16.0)*2;
  for (i=0; i<2; i++)
    cos_8[i]=cos(PI*(2*i+1)/8.0)*2;
  for (i=0; i<1; i++)
    cos_4[i]=cos(PI*(2*i+1)/4.0)*2;
}
