/*
 *      LOAD.CMD - V1.0 C.Langanke 1996
 *
 *      REXX sample for "Animated Mouse Pointer for OS/2"
 *
 *      Syntax: LOAD [n] name [/?]
 *
 *      LOAD loades an animation for one or all mouse pointers.
 *
 *      n     is the ordinal for a specific mouse pointer.  If that ordinal is
 *            not given, the animation resource is loaded for all mouse pointers
 *            n applies as follows:
 *      0 - arrow   2 - wait        4 - size we   6 - size nesw   8 - illegal
 *      1 - text    3 - size nwse   5 - move      7 - size ns
 *
 *      name  is the name of the animation resource either fully qualified or
 *            relative to the Animation File Path.  This path can also be set
 *            either via the mouse object or the settings string ANIMATIONPATH.
 *
 *      /?             displays this help text.
#*
 *      NOTE: "Animated Mouse Pointer for OS/2" must be 
 *            installed before executing this batch program.
 *
 *      Refer to WPAMPTR.INF for more information about how
 *      to use REXX setup strings to configure
 *      "Animated Mouse Pointer for OS/2"
 */
/* First comment is used as online help text. */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 /* OS/2 error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* show help */
 ARG Parm .
 IF ((Parm = '') | (POS('?', Parm) > 0)) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* get parms */
 PARSE ARG ordinal name
 IF (Name = '') THEN
 DO
    Ordinal = 'ALL';
    PARSE ARG Name
 END;

 /* verify commandline parms */
 IF (Ordinal \= 'ALL') THEN
 DO
    IF (DATATYPE(ordinal) \= 'NUM') THEN
    DO
       SAY CmdName': error: ordinal n must must be numeric.';
       EXIT(ERROR.INVALID_PARAMETER);
    END;

    IF ((ordinal < 0) | (ordinal > 8)) THEN
    DO
       SAY CmdName': error: ordinal n bust be in the range from 0 to 8.';
       EXIT(ERROR.INVALID_PARAMETER);
    END;
 END;

 /* load RexxUtil */ 
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;
     
 /* now setup the mouse object */
 setup    = 'POINTER='STRIP(Ordinal)','STRIP(Name)';';

 CALL CHAROUT, 'setup mouse object with "'setup'"   ... ';
 rc = SysSetObjectData( '<WP_MOUSE>', setup);
 IF (rc = 1) THEN
    SAY 'Ok.';
 ELSE
    SAY 'ERROR !';

 EXIT(ERROR.NO_ERROR);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE Title

 SAY;
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    IF (LEFT(ThisLine, 2) = '#*') THEN
    DO
       '@PAUSE';
       SAY '[A'D2C(13)'[K[A';
    END;
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file again */
 rc = LINEOUT(Thisfile);

 RETURN('');

