//FBCDef - FileBrowser Center API (c) 2001 by Christoph Bratschi (www.bratschi.net)
#if (!defined(H_FBCDef))
#define H_FBCDef

//Message
#define NIM_ADD    0x0
#define NIM_MODIFY 0x1
#define NIM_DELETE 0x2

//Flags
#define NIF_MESSAGE 0x1
#define NIF_ICON    0x2
#define NIF_TIP     0x4

//Default Icons ID's
#define DI_VOLUME 1
#define DI_FIRST  1
#define DI_LAST   1

//Function ID
#define ID_SHELLNOTIFYICON            = 20
#define ID_SHELLNOTIFYICONA           = 21
#define ID_SHELLISFBCENTERRUNNING     = 30
#define ID_SHELLDEFAULTNOTIFYICON     = 31
#define ID_SHELLINITMENU              = 32
#define ID_SHELLDONEMENU              = 33
#define ID_SHELLDEACTIVATEALWAYSONTOP = 34
#define ID_SHELLACTIVATEALWAYSONTOP   = 35

//Function Name
#define SHELL_NOTIFYICONNAME        "Shell_NotifyIcon"
#define SHELL_ISFBCENTERRUNNINGNAME "Shell_IsFBCenterRunning"
#define SHELL_DEFAULTNOTIFYICONNAME "Shell_DefaultNotifyIcon"
#define SHELL_INITMENUNAME          "Shell_InitMenu" /*call before displaying menu over FBCenter (always on top covers menu fix)*/
#define SHELL_DONEMENUNAME          "Shell_DoneMenu"
#define SHELL_DEACTIVATEALWAYSONTOP "Shell_DeactivateAlwaysOnTop"
#define SHELL_ACTIVATEALWAYSONTOP   "Shell_ActivateAlwaysOnTop"

//data types

typedef struct _NOTIFYICONDATA
{
  UINT cbSize;           //Structure size
  HWND HWnd;             //Associated window
  UINT uID;              //Icon ID
  UINT uFlags;           //Flags (nif_Message, nif_Icon, nif_Tip)
  UINT uCallbackMessage; //Callback message: mp1 = Message, mp2 = ID, result: 0 = not handled (calls DefWndProc), 1 = handled
  HPOINTER hIcon;        //Application must free icon after op_Delete/op_Modify and failed op_Add
  CHAR szTip[64];        //Tip text
} NOTIFYICONDATA,*PNOTIFYICONDATA;

//exported functions


#endif
