/*****************************************************************************
 *****************************************************************************
 Copyright (c) 2001 - 2002, VIA Technologies, Inc.

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of VIA Technologies, Inc. nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/
#ifndef _RHINE_PROC_H
#define _RHINE_PROC_H
#include "rhine.h"

#define RHINE_PROC_READ	0x0001
#define RHINE_PROC_WRITE	0x0002
#define RHINE_PROC_DIR		0x0004
#define RHINE_PROC_EOT		0xFFFF
#define RHINE_PROC_FILE		(RHINE_PROC_READ|RHINE_PROC_WRITE)

struct __rhine_info;
struct __rhine_proc_entry;

typedef int (*RHINE_PROC_READ_FUNC) (struct __rhine_proc_entry*, char* buf);
typedef int (*RHINE_PROC_WRITE_FUNC) (struct __rhine_proc_entry*, const char* buf, unsigned long len);

typedef struct __rhine_proc_entry {
	char								name[128];
	int									type;	
	RHINE_PROC_READ_FUNC				read_proc;
	RHINE_PROC_WRITE_FUNC				write_proc;	
	int									data;
	const struct __rhine_proc_entry*	childs;
	U8									byRevId;
	struct proc_dir_entry*				pOsEntry;	
	struct proc_dir_entry*				pOsParent;
	struct __rhine_info*				pInfo;
	const struct __rhine_proc_entry*	siblings;
} RHINE_PROC_ENTRY, *PRHINE_PROC_ENTRY;



BOOL	rhine_init_proc_fs(struct __rhine_info* pInfo);
BOOL	rhine_create_proc_entry(struct __rhine_info* pInfo);

void	rhine_free_proc_fs(struct __rhine_info* pInfo);
void	rhine_free_proc_entry(struct __rhine_info* pInfo);

#endif

