#!/bin/sh
#
# Install FIELDVIEW floating license files from CD-ROM.
#

if test $# -gt 1
then
    echo "$0: too many arguments" 1>&2
    exit 1
fi

if test $# -eq 0
then
    echo 'Enter the name of the directory where FIELDVIEW is installed:'
    read targetdir
    if test -z "$targetdir"
    then
	echo 'Empty directory name - aborting the installation.'
	exit 1
    fi
else
    targetdir=$1
fi

first_char=`echo $targetdir | sed -e 's/^\(.\).*/\1/'`
if test "$first_char" != "/"
then
    echo "'$targetdir' is not a complete path."
    echo "Please supply a complete path name, starting with '/'."
    exit 1
fi

# Strip off any trailing "/fv".

if test ! -d $targetdir
then
    echo "Directory $targetdir does not exist, or is not a directory."
    exit 1
fi

if test ! -d $targetdir/fv
then
    # Maybe the user appended "/fv" to the target directory.  Strip it off.
    targetdir=`echo $targetdir | sed -e 's;/fv$;;'`
    if test ! -d $targetdir/fv
    then
	echo "Warning: the directory you have chosen does not"
	echo "contain a FIELDVIEW installation area."
	echo "Continue anyway (answer y for yes) ?"
	read response
	case $response in
	[yY]*) ;;
	*) exit;;
	esac
    fi
fi

if test -d $targetdir/fv
then
    if test ! -w $targetdir/fv
    then
	echo "You do not have permission to write into directory $targetdir/fv."
	echo 'Aborting the installation.'
	exit 1
    fi
else
    if test ! -w $targetdir
    then
	echo "You do not have permission to write into directory $targetdir."
	echo 'Aborting the installation.'
	exit 1
    fi
fi

type zcat >/dev/null
if test $? -ne 0 ; then
    echo
    echo "Could not find the \"zcat\" command on your system." 1>&2
    echo "This command is needed to uncompress the FIELDVIEW" 1>&2
    echo "floating license files." 1>&2
    echo "See your system administrator." 1>&2
    exit 1
fi

echo
echo "Which platform will be running the floating license manager:"
echo
echo "    1. SGI Irix"
echo "    2. Sun Solaris"
echo "    3. IBM AIX"
echo "    4. Hewlett-Packard HP-UX"
echo "    5. Linux (Intel x86)"
echo "    6. Linux (Intel IA64)"
echo "    7. Linux (AMD 64, Intel EM64T)"
echo "    8. Mac OS X"
echo
echo "    9. none of the above"
echo
echo "Please enter a number from 1 to 9:"

while :
do
    read version
    case $version in
    1)  tarfile='[iI][rR][iI][sS]64_[lL].[zZ]*'
	server_dir=iris64
	break;;
    2)  tarfile='[sS][oO][lL][aA][rR][iI][sS]_[lL].[zZ]*'
	server_dir=solaris
	break;;
    3)  tarfile='[iI][bB][mM]_[rR][sS]_[lL].[zZ]*'
	server_dir=ibm_rs
	break;;
    4)  tarfile='[hH][pP]_700_[lL].[zZ]*'
	server_dir=hp_700
	break;;
    5)  tarfile='[lL][iI][nN][uU][xX]_[xX]86_[lL].[zZ]*'
	server_dir=linux_x86
	break;;
    6)  tarfile='[lL][iI][nN][uU][xX]_[iI][aA]64_[lL].[zZ]*'
	server_dir=linux_ia64
	break;;
    7)  tarfile='[lL][iI][nN][uU][xX]_[aA][mM][dD]64_[lL].[zZ]*'
	server_dir=linux_amd64
	break;;
    8)  tarfile='[mM][aA][cC]_[pP][pP][cC]_[lL].[zZ]*'
	server_dir=mac_ppc
	break;;
    9)  exit;;

    *) echo "Please enter a number from 1 to 9:"
    esac
done

if test ! -f $tarfile
then
    echo
    echo "Could not find the FIELDVIEW floating license archive"
    echo "file in the current directory."
    echo "Make sure you are in the CD-ROM directory that contains"
    echo "the Unix FIELDVIEW installation files."
    exit 1
fi

echo
echo "Restoring floating license files from archive..."
(curd=`pwd`; cd $targetdir; cat $curd/$tarfile | zcat | tar xvf - )
if test $? -ne 0 ; then
    echo
    echo "Error restoring floating license files." 1>&2
    exit 5
fi

echo
echo "Restore completed."

echo
echo 'The fv_server script contains an environment variable'
echo 'called FV_HOME that points to the subdirectory fv in the'
echo 'directory where FIELDVIEW is installed.'
echo 'This directory is apparently:'
echo "   $targetdir"
echo
echo 'The default value for the FV_HOME environment variable in the'
echo 'fv_server script will be set to this subdirectory.'
echo
echo 'If you move the installation, or if you simply wish to use'
echo 'a different name for this directory, you must edit the file'
echo "   $targetdir/fv/bin/fv_server"
echo 'and change the values of the variable FV_HOME.'
echo "If you move the installation you must also edit the file"
echo "   $targetdir/fv/data/license.dat"
echo "and update the pathname on the DAEMON line."
echo

ftmp=$targetdir/fv/bin/fv_server.template
sed -e "s;FV_HOME_VALUE;$targetdir;" $ftmp >$targetdir/fv/bin/fv_server
chmod +x $targetdir/fv/bin/fv_server
rm -f $ftmp

ftmp=$targetdir/fv/data/license.dat
if test -w $ftmp
then
    grep  '^DAEMON' $ftmp > /dev/null 2>&1
    if test $? -ne 0
    then
	echo "" >> $ftmp
	echo "DAEMON ilight $targetdir/fv/flexlm/$server_dir/ilight" >> $ftmp
    fi
fi

echo
echo "Floating license software installation completed."
echo
echo "Proceed with the Passwords section of the Installation Instructions."
echo
