(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10071,        350]
NotebookOptionsPosition[      7328,        261]
NotebookOutlinePosition[      8633,        298]
CellTagsIndexPosition[      8549,        293]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Exceptions in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#4946"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Exceptions in .NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GetNETException" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/GetNETException"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GetNETException\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$NETExceptionHandler", "ObjectName",
 CellID->17164],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$NETExceptionHandler"], "InlineFormula"],
     "\[LineSeparator]allows you to control how exceptions thrown in .NET are \
handled in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default behavior is for exceptions to appear as messages in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". To override this behavior (e.g., to temporarily silence messages from \
exceptions), assign a value to ",
 Cell[BoxData["$NETExceptionHandler"], "InlineFormula"],
 "."
}], "Notes",
 CellID->2022074813],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["$NETExceptionHandler"], "InlineFormula"],
 " is treated as a function that will be passed 3 arguments:"
}], "Notes",
 CellID->1082668316],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
    "symbol", " ", "associated", " ", "with", " ", "the", " ", "message"}], 
    Cell["usually the symbol NET", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"message", " ", "tag"}], Cell[TextData[{
     "typically ",
     StyleBox["\"netexceptn\"", "InlineCode"],
     " or ",
     StyleBox["\"netpexceptn\"", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"string", " ", "description"}], Cell[
    "a descriptive string associated with the exception", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->777445981],

Cell[TextData[{
 "The tag \"netexceptn\" generally is used for a typical exception, while the \
tag \"netpexceptn\" is used for exceptions generated by a manual return, \
where the exception occurs after the function has sent its result back to ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Notes",
 CellID->1746776941],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["GetNETException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetNETException"]], "InlineFormula"],
 " in a handler function to obtain the .NET exception object manually."
}], "Notes",
 CellID->1147967021],

Cell[TextData[{
 "Typically, ",
 Cell[BoxData["$NETExceptionHandler"], "InlineFormula"],
 " is assigned in a ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->81495440]
}, Closed]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->415422899],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->399489083],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NETLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159979121],

Cell["This silences messages:", "Notes",
 CellID->2067465573],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$NETExceptionHandler", "=", 
     RowBox[{"Null", "&"}]}], "}"}], ",", 
   RowBox[{"objName", "@", 
    RowBox[{"MethodName", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1608476951]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->15207],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["GetNETException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetNETException"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22191]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->27311],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Exceptions in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"]
}], "Tutorials",
 CellID->2028983154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$NETExceptionHandler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "$NETExceptionHandler", "summary" -> 
    "$NETExceptionHandler allows you to control how exceptions thrown in .NET \
are handled in Mathematica.", "uri" -> "NETLink/ref/$NETExceptionHandler", 
    "type" -> "Symbol", "label" -> "N E T Link Symbol", "paclet" -> "NETLink",
     "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {"exception handler"}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 15, 31.2350074}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5393, 180, 99, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->415422899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8408, 286}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1471, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2094, 67, 58, 1, 70, "ObjectName",
 CellID->17164],
Cell[2155, 70, 445, 14, 70, "Usage",
 CellID->20038]
}, Open  ]],
Cell[CellGroupData[{
Cell[2637, 89, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3096, 105, 339, 9, 70, "Notes",
 CellID->2022074813],
Cell[3438, 116, 186, 5, 70, "Notes",
 CellID->1082668316],
Cell[3627, 123, 850, 21, 70, "2ColumnTableMod",
 CellID->777445981],
Cell[4480, 146, 330, 7, 70, "Notes",
 CellID->1746776941],
Cell[4813, 155, 279, 8, 70, "Notes",
 CellID->1147967021],
Cell[5095, 165, 261, 10, 70, "Notes",
 CellID->81495440]
}, Closed]],
Cell[CellGroupData[{
Cell[5393, 180, 99, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->415422899],
Cell[CellGroupData[{
Cell[5517, 186, 148, 5, 70, "ExampleSection",
 CellID->399489083],
Cell[5668, 193, 130, 3, 70, "Input",
 CellID->159979121],
Cell[5801, 198, 61, 1, 70, "Notes",
 CellID->2067465573],
Cell[5865, 201, 281, 9, 70, "Input",
 CellID->1608476951]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6195, 216, 50, 1, 70, "SeeAlsoSection",
 CellID->15207],
Cell[6248, 219, 218, 6, 70, "SeeAlso",
 CellID->22191]
}, Open  ]],
Cell[CellGroupData[{
Cell[6503, 230, 53, 1, 70, "TutorialsSection",
 CellID->27311],
Cell[6559, 233, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6840, 244, 446, 12, 70, "Tutorials",
 CellID->2028983154]
}, Open  ]],
Cell[7301, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

