(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6809,        240]
NotebookOptionsPosition[      4921,        181]
NotebookOutlinePosition[      6042,        211]
CellTagsIndexPosition[      5999,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\".NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DefineDLLFunction" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/DefineDLLFunction"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DefineDLLFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CallingConvention", "ObjectName",
 CellID->3719],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["CallingConvention"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["DefineDLLFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
     
     " that specifies what calling convention the DLL function uses."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", which means use the platform default (",
 Cell[BoxData["\"\<StdCall\>\""], "InlineFormula"],
 " on all platforms except Windows CE, which is not supported by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "). ",
 "Most DLL functions use the ",
 Cell[BoxData["\"\<StdCall\>\""], "InlineFormula"],
 " convention."
}], "Notes",
 CellID->647417810],

Cell[TextData[{
 "The possible values are ",
 Cell[BoxData["\"\<StdCall\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<CDecl\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ThisCall\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<WinApi\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1998976968],

Cell[TextData[{
 "For more information on these values, see the .NET Framework documentation \
for the ",
 StyleBox["System.Runtime.InteropServices.CallingConvention", "InlineCode"],
 " enumeration."
}], "Notes",
 CellID->1571727508]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7633],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30290]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8113],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CallingConvention - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "CallingConvention", "summary" -> 
    "CallingConvention is an option to DefineDLLFunction that specifies what \
calling convention the DLL function uses.", "uri" -> 
    "NETLink/ref/CallingConvention", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"calling convention"}, "status" -> 
    "None", "built" -> "{2007, 4, 18, 11, 13, 21.7281274}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1265, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1888, 63, 54, 1, 70, "ObjectName",
 CellID->3719],
Cell[1945, 66, 561, 16, 70, "Usage",
 CellID->15469]
}, Open  ]],
Cell[CellGroupData[{
Cell[2543, 87, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3002, 103, 515, 16, 70, "Notes",
 CellID->647417810],
Cell[3520, 121, 442, 16, 70, "Notes",
 CellID->1998976968],
Cell[3965, 139, 233, 6, 70, "Notes",
 CellID->1571727508]
}, Closed]],
Cell[CellGroupData[{
Cell[4235, 150, 49, 1, 70, "SeeAlsoSection",
 CellID->7633],
Cell[4287, 153, 222, 6, 70, "SeeAlso",
 CellID->30290]
}, Open  ]],
Cell[CellGroupData[{
Cell[4546, 164, 52, 1, 70, "TutorialsSection",
 CellID->8113],
Cell[4601, 167, 278, 9, 70, "Tutorials",
 CellID->608907033]
}, Open  ]],
Cell[4894, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

