(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7440,        252]
NotebookOptionsPosition[      5496,        190]
NotebookOutlinePosition[      6552,        219]
CellTagsIndexPosition[      6509,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Casting in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#16712"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Casting in .NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseNETObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/ReleaseNETObject"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"ReleaseNETObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CastNETObject", "ObjectName",
 CellID->5578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CastNETObject", "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]casts the specified object to a different type."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14640]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The cast must be valid, meaning that the object must be an instance of the \
given class or interface type.\
\>", "Notes",
 CellID->1975368856],

Cell[TextData[{
 "The type can be specified by a fully qualified type name or as a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->2074663819],

Cell[TextData[{
 "There are two main situations where it is used: \"upcasting\" an object to \
call an inherited version of a method that is hidden by a version of the same \
method declared as \"new\" in a class lower in the \ninheritance hierarchy, \
or a \"raw\" COM object (these appear as ",
 StyleBox["<< NETObject[System.__ComObject] >>", "InlineCode"],
 " or ",
 StyleBox["<< NETObject[COMInterface[...]] >>", "InlineCode"],
 ") that can be successfully cast to a certain managed type"
}], "Notes",
 CellID->182829594],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " on an object will remove all of that object's casted references as well."
}], "Notes",
 CellID->30864285]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->26756],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7184]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20566],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Casting in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16712"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16712"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16712"]
}], "Tutorials",
 CellID->2028983154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CastNETObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "CastNETObject", "summary" -> 
    "CastNETObject[obj, type] casts the specified object to a different \
type.", "uri" -> "NETLink/ref/CastNETObject", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"cast object"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 13, 23.9616954}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1461, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2084, 66, 50, 1, 70, "ObjectName",
 CellID->5578],
Cell[2137, 69, 464, 14, 70, "Usage",
 CellID->14640]
}, Open  ]],
Cell[CellGroupData[{
Cell[2638, 88, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3097, 104, 153, 4, 70, "Notes",
 CellID->1975368856],
Cell[3253, 110, 260, 8, 70, "Notes",
 CellID->2074663819],
Cell[3516, 120, 526, 10, 70, "Notes",
 CellID->182829594],
Cell[4045, 132, 280, 8, 70, "Notes",
 CellID->30864285]
}, Closed]],
Cell[CellGroupData[{
Cell[4362, 145, 50, 1, 70, "SeeAlsoSection",
 CellID->26756],
Cell[4415, 148, 219, 6, 70, "SeeAlso",
 CellID->7184]
}, Open  ]],
Cell[CellGroupData[{
Cell[4671, 159, 53, 1, 70, "TutorialsSection",
 CellID->20566],
Cell[4727, 162, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[5008, 173, 446, 12, 70, "Tutorials",
 CellID->2028983154]
}, Open  ]],
Cell[5469, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

