(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6863,        236]
NotebookOptionsPosition[      5038,        178]
NotebookOutlinePosition[      6103,        207]
CellTagsIndexPosition[      6060,        204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Calling COM from Mathematica in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Calling COM from Mathematica in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseCOMObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/ReleaseCOMObject"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"ReleaseCOMObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CreateCOMObject", "ObjectName",
 CellID->8611],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CreateCOMObject", "[", 
       StyleBox["str", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a COM object specified by the string ",
     Cell[BoxData[
      StyleBox["str", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string can be either a ProgID (such as ",
 StyleBox["\"Excel.Application\"", "InlineCode"],
 ") or a CLSID (such as ",
 StyleBox["\"{8E27C92B-1264-101C-8A2F-040224009C02}\"", "InlineCode"],
 ")."
}], "Notes",
 CellID->18403],

Cell[TextData[{
 Cell[BoxData["CreateCOMObject"], "InlineFormula"],
 " is analogous to the COM API function ",
 StyleBox["CoCreateInstance", "InlineCode"],
 "."
}], "Notes",
 CellID->863015906]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1273],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->17723]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21948],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Calling COM from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]
}], "Tutorials",
 CellID->4200]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreateCOMObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "CreateCOMObject", "summary" -> 
    "CreateCOMObject[str] creates a COM object specified by the string str.", 
    "uri" -> "NETLink/ref/CreateCOMObject", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"create object"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 13, 26.0951034}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1504, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2127, 67, 52, 1, 70, "ObjectName",
 CellID->8611],
Cell[2182, 70, 484, 15, 70, "Usage",
 CellID->30316]
}, Open  ]],
Cell[CellGroupData[{
Cell[2703, 90, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3162, 106, 246, 7, 70, "Notes",
 CellID->18403],
Cell[3411, 115, 193, 6, 70, "Notes",
 CellID->863015906]
}, Closed]],
Cell[CellGroupData[{
Cell[3641, 126, 49, 1, 70, "SeeAlsoSection",
 CellID->1273],
Cell[3693, 129, 220, 6, 70, "SeeAlso",
 CellID->17723]
}, Open  ]],
Cell[CellGroupData[{
Cell[3950, 140, 53, 1, 70, "TutorialsSection",
 CellID->21948],
Cell[4006, 143, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[4287, 154, 709, 19, 70, "Tutorials",
 CellID->4200]
}, Open  ]],
Cell[5011, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

