(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7033,        235]
NotebookOptionsPosition[      5104,        176]
NotebookOutlinePosition[      6330,        208]
CellTagsIndexPosition[      6287,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Calling COM from Mathematica in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Calling COM from Mathematica in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateCOMObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/CreateCOMObject"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CreateCOMObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GetActiveCOMObject", "ObjectName",
 CellID->30585],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetActiveCOMObject", "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]acquires an already-running COM object specified by ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"],
     ", which can be either a ProgID (such as ",
     StyleBox["\"Excel.Application\"", "InlineCode"],
     ") or a CLSID (such as ",
     StyleBox["\"{8E27C92B-1264-101C-8A2F-040224009C02}\"", "InlineCode"],
     ")."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16702]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetActiveCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetActiveCOMObject"]], "InlineFormula"],
 " is analogous to the COM API function ",
 StyleBox["GetActiveObject", "InlineCode"],
 "."
}], "Notes",
 CellID->11073]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27954],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->17802]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9653],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Calling COM from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]
}], "Tutorials",
 CellID->8594]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetActiveCOMObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "GetActiveCOMObject", "summary" -> 
    "GetActiveCOMObject[string] acquires an already-running COM object \
specified by string, which can be either a ProgID (such as \
\"Excel.Application\") or a CLSID (such as \
\"{8E27C92B-1264-101C-8A2F-040224009C02}\").", "uri" -> 
    "NETLink/ref/GetActiveCOMObject", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"get active object"}, "status" -> "None",
     "built" -> "{2007, 4, 18, 11, 13, 44.7549114}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1501, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2124, 67, 56, 1, 70, "ObjectName",
 CellID->30585],
Cell[2183, 70, 710, 19, 70, "Usage",
 CellID->16702]
}, Open  ]],
Cell[CellGroupData[{
Cell[2930, 94, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3389, 110, 283, 9, 70, "Notes",
 CellID->11073]
}, Closed]],
Cell[CellGroupData[{
Cell[3709, 124, 50, 1, 70, "SeeAlsoSection",
 CellID->27954],
Cell[3762, 127, 218, 6, 70, "SeeAlso",
 CellID->17802]
}, Open  ]],
Cell[CellGroupData[{
Cell[4017, 138, 52, 1, 70, "TutorialsSection",
 CellID->9653],
Cell[4072, 141, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[4353, 152, 709, 19, 70, "Tutorials",
 CellID->8594]
}, Open  ]],
Cell[5077, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

