(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6766,        236]
NotebookOptionsPosition[      4889,        177]
NotebookOutlinePosition[      6003,        207]
CellTagsIndexPosition[      5960,        204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Exceptions in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#4946"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Exceptions in .NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$NETExceptionHandler" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/$NETExceptionHandler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$NETExceptionHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GetNETException", "ObjectName",
 CellID->26919],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetNETException", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the .NET exception object that was thrown in \
the most recent call from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " to .NET."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Returns",
 " ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if no exception was thrown in the most recent call."
}], "Notes",
 CellID->27148],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["GetNETException"], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"]], "InlineFormula"],
 " to implement a custom exception-handling scheme."
}], "Notes",
 CellID->177058341]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31330],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15281]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11160],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Exceptions in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"]
}], "Tutorials",
 CellID->1405]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetNETException - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "GetNETException", "summary" -> 
    "GetNETException[] returns the .NET exception object that was thrown in \
the most recent call from Mathematica to .NET.", "uri" -> 
    "NETLink/ref/GetNETException", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"get exception"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 13, 51.8662714}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1489, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2112, 67, 53, 1, 70, "ObjectName",
 CellID->26919],
Cell[2168, 70, 487, 15, 70, "Usage",
 CellID->27091]
}, Open  ]],
Cell[CellGroupData[{
Cell[2692, 90, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3151, 106, 229, 9, 70, "Notes",
 CellID->27148],
Cell[3383, 117, 332, 10, 70, "Notes",
 CellID->177058341]
}, Closed]],
Cell[CellGroupData[{
Cell[3752, 132, 50, 1, 70, "SeeAlsoSection",
 CellID->31330],
Cell[3805, 135, 228, 6, 70, "SeeAlso",
 CellID->15281]
}, Open  ]],
Cell[CellGroupData[{
Cell[4070, 146, 53, 1, 70, "TutorialsSection",
 CellID->11160],
Cell[4126, 149, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[4407, 160, 440, 12, 70, "Tutorials",
 CellID->1405]
}, Open  ]],
Cell[4862, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

