(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9557,        309]
NotebookOptionsPosition[      7428,        242]
NotebookOutlinePosition[      8559,        272]
CellTagsIndexPosition[      8516,        269]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Calling COM from Mathematica in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Calling COM from Mathematica in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NetTypeInfo" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NetTypeInfo"], 
          "CreateCOMObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/CreateCOMObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NetTypeInfo\"\>", 
       2->"\<\"CreateCOMObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LoadCOMTypeLibrary", "ObjectName",
 CellID->12444],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadCOMTypeLibrary", "[", 
       StyleBox["library", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a so-called \"interop\" assembly from the named \
type library and loads that assembly. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->23714],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[Cell[BoxData[
     ButtonBox["SaveAssemblyAs",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/SaveAssemblyAs"]], "InlineFormula"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]], "InlineFormula"]], "TableText"], Cell[
    "a full pathname to the assembly file you want", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[Cell[BoxData[
     ButtonBox["SafeArrayAsArray",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/SafeArrayAsArray"]], "InlineFormula"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]], "InlineFormula"]], "TableText"], Cell[
    TextData[{
     "whether to marshal SAFEARRAY types as ",
     StyleBox["System.Array", "InlineCode"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9924],

Cell["\<\
Once a type library has been loaded in this way, all its types will have \
managed equivalents created for them, so you can program with these types as \
if they were native .NET types.\
\>", "Notes",
 CellID->89233678],

Cell[TextData[{
 Cell[BoxData["LoadCOMTypeLibrary"], "InlineFormula"],
 " is the programmatic equivalent of running the ",
 StyleBox["tlbimp.exe", "MR"],
 " tool that is part of the .NET Framework SDK."
}], "Notes",
 CellID->25641438],

Cell[TextData[{
 "The assembly can optionally be saved to disk (using the ",
 Cell[BoxData[
  ButtonBox["SaveAssemblyAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SaveAssemblyAs"]], "InlineFormula"],
 " option) so that you do not have to call ",
 Cell[BoxData["LoadCOMTypeLibrary"], "InlineFormula"],
 " in the future."
}], "Notes",
 CellID->85560074],

Cell[TextData[{
 "If you plan to do more in-depth work with COM objects described in a given \
type library, it is recommended that you use ",
 Cell[BoxData["LoadCOMTypeLibrary"], "InlineFormula"],
 " or the ",
 StyleBox["tlbimp.exe", "MR"],
 " tool to create an interop assembly and then use that assembly."
}], "Notes",
 CellID->531471448]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->29772],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetTypeInfo",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NetTypeInfo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateCOMObject",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/CreateCOMObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5249]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9961],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Calling COM from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]
}], "Tutorials",
 CellID->29316]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LoadCOMTypeLibrary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "LoadCOMTypeLibrary", "summary" -> 
    "LoadCOMTypeLibrary[library] creates a so-called \"interop\" assembly \
from the named type library and loads that assembly. ", "uri" -> 
    "NETLink/ref/LoadCOMTypeLibrary", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"load type library"}, "status" -> "None",
     "built" -> "{2007, 4, 18, 11, 14, 7.0505274}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1626, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2249, 69, 56, 1, 70, "ObjectName",
 CellID->12444],
Cell[2308, 72, 465, 13, 70, "Usage",
 CellID->12415]
}, Open  ]],
Cell[CellGroupData[{
Cell[2810, 90, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3269, 106, 68, 1, 70, "Notes",
 CellID->23714],
Cell[3340, 109, 1204, 28, 70, "3ColumnTableMod",
 CellID->9924],
Cell[4547, 139, 229, 5, 70, "Notes",
 CellID->89233678],
Cell[4779, 146, 234, 6, 70, "Notes",
 CellID->25641438],
Cell[5016, 154, 367, 10, 70, "Notes",
 CellID->85560074],
Cell[5386, 166, 341, 8, 70, "Notes",
 CellID->531471448]
}, Closed]],
Cell[CellGroupData[{
Cell[5764, 179, 50, 1, 70, "SeeAlsoSection",
 CellID->29772],
Cell[5817, 182, 486, 17, 70, "SeeAlso",
 CellID->5249]
}, Open  ]],
Cell[CellGroupData[{
Cell[6340, 204, 52, 1, 70, "TutorialsSection",
 CellID->9961],
Cell[6395, 207, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6676, 218, 710, 19, 70, "Tutorials",
 CellID->29316]
}, Open  ]],
Cell[7401, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

