(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9145,        317]
NotebookOptionsPosition[      6947,        248]
NotebookOutlinePosition[      8106,        278]
CellTagsIndexPosition[      8063,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "MakeNETObject in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#17016"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"MakeNETObject in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NETNew" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETNew"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NETNew\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MakeNETObject", "ObjectName",
 CellID->954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MakeNETObject", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a .NET object that represents the given ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MakeNETObject", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", " ", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates an object of the specified type from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1030]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MakeNETObject"], "InlineFormula"],
 " accepts numbers, ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "/",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", strings, and lists of these, up to 3-deep."
}], "Notes",
 CellID->924468500],

Cell[TextData[{
 "This is a shortcut to calling ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ", and it is especially useful for arrays, as the array object can be \
created and initialized with values in a single call."
}], "Notes",
 CellID->18249],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " argument to force a nonstandard type."
}], "Notes",
 CellID->118774300],

Cell[TextData[{
 "For example, ",
 Cell[BoxData[
  RowBox[{"MakeNETObject", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "InlineFormula"],
 " will create an array of ",
 StyleBox["int (type System.Int32[]", "InlineCode"],
 "). If you want an array of ",
 StyleBox["Int16", "InlineCode"],
 StyleBox[",", "MR"],
 " use ",
 Cell[BoxData[
  RowBox[{"MakeNETObject", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    "\"\<System.Int16[]\>\""}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->578084644]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->162],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12771]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21375],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["MakeNETObject in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17016"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17016"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17016"]
}], "Tutorials",
 CellID->1425]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->114582863],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->457377435]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MakeNETObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "MakeNETObject", "summary" -> 
    "MakeNETObject[expr] constructs a .NET object that represents the given \
Mathematica expression. MakeNETObject[expr, type] creates an object of the \
specified type from expr.", "uri" -> "NETLink/ref/MakeNETObject", "type" -> 
    "Symbol", "label" -> "N E T Link Symbol", "paclet" -> "NETLink", 
    "context" -> "NETLink`", "keywords" -> {}, "synonyms" -> {"make object"}, 
    "status" -> "None", "built" -> "{2007, 4, 18, 11, 14, 21.7640314}", 
    "index" -> True}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2036, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2659, 82, 49, 1, 70, "ObjectName",
 CellID->954],
Cell[2711, 85, 853, 26, 70, "Usage",
 CellID->1030]
}, Open  ]],
Cell[CellGroupData[{
Cell[3601, 116, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4060, 132, 399, 14, 70, "Notes",
 CellID->924468500],
Cell[4462, 148, 330, 9, 70, "Notes",
 CellID->18249],
Cell[4795, 159, 163, 6, 70, "Notes",
 CellID->118774300],
Cell[4961, 167, 578, 20, 70, "Notes",
 CellID->578084644]
}, Closed]],
Cell[CellGroupData[{
Cell[5576, 192, 48, 1, 70, "SeeAlsoSection",
 CellID->162],
Cell[5627, 195, 200, 6, 70, "SeeAlso",
 CellID->12771]
}, Open  ]],
Cell[CellGroupData[{
Cell[5864, 206, 53, 1, 70, "TutorialsSection",
 CellID->21375],
Cell[5920, 209, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6201, 220, 446, 12, 70, "Tutorials",
 CellID->1425]
}, Open  ]],
Cell[CellGroupData[{
Cell[6684, 237, 58, 1, 70, "MoreAboutSection",
 CellID->114582863],
Cell[6745, 240, 160, 3, 70, "MoreAbout",
 CellID->457377435]
}, Open  ]],
Cell[6920, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

