(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7627,        249]
NotebookOptionsPosition[      5547,        188]
NotebookOutlinePosition[      6859,        220]
CellTagsIndexPosition[      6816,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\".NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DefineDLLFunction" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/DefineDLLFunction"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DefineDLLFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MarshalStringsAs", "ObjectName",
 CellID->3279],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MarshalStringsAs"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["DefineDLLFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
     
     " that specifies how string arguments should be marshaled into the DLL \
function. This applies to any arguments that are mapped to the System.String \
class, which includes types specified in your declaration as ",
     Cell[BoxData["\"\<char*\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<string\>\""], "InlineFormula"],
     ", or ",
     Cell[BoxData["\"\<ByVal As String\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible values are:", "Notes",
 CellID->12543],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ANSI\>\"", Cell["\<\
strings will be sent as single-byte C-style strings (default)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Unicode\>\"", Cell[
    "strings will be sent as 2-byte Unicode strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "strings will be sent in the platform's default format", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->82627380],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting picks the platform default (",
 Cell[BoxData["\"\<Unicode\>\""], "InlineFormula"],
 " on Windows NT/2000/XP, ",
 Cell[BoxData["\"\<ANSI\>\""], "InlineFormula"],
 " on 98/ME). ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " should rarely be used, as it is intended mainly for certain Windows API \
functions that automatically switch behaviors on different versions of \
Windows."
}], "Notes",
 CellID->659620102]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6635],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22881]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4306],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MarshalStringsAs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "MarshalStringsAs", "summary" -> 
    "MarshalStringsAs is an option to DefineDLLFunction that specifies how \
string arguments should be marshaled into the DLL function. This applies to \
any arguments that are mapped to the System.String class, which includes \
types specified in your declaration as \"char*\", \"string\", or \"ByVal As \
String\".", "uri" -> "NETLink/ref/MarshalStringsAs", "type" -> "Symbol", 
    "label" -> "N E T Link Symbol", "paclet" -> "NETLink", "context" -> 
    "NETLink`", "keywords" -> {}, "synonyms" -> {"marshal strings as"}, 
    "status" -> "None", "built" -> "{2007, 4, 18, 11, 14, 24.1979194}", 
    "index" -> True}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1265, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1888, 63, 53, 1, 70, "ObjectName",
 CellID->3279],
Cell[1944, 66, 917, 24, 70, "Usage",
 CellID->6094]
}, Open  ]],
Cell[CellGroupData[{
Cell[2898, 95, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3357, 111, 53, 1, 70, "Notes",
 CellID->12543],
Cell[3413, 114, 760, 17, 70, "2ColumnTableMod",
 CellID->82627380],
Cell[4176, 133, 648, 19, 70, "Notes",
 CellID->659620102]
}, Closed]],
Cell[CellGroupData[{
Cell[4861, 157, 49, 1, 70, "SeeAlsoSection",
 CellID->6635],
Cell[4913, 160, 222, 6, 70, "SeeAlso",
 CellID->22881]
}, Open  ]],
Cell[CellGroupData[{
Cell[5172, 171, 52, 1, 70, "TutorialsSection",
 CellID->4306],
Cell[5227, 174, 278, 9, 70, "Tutorials",
 CellID->608907033]
}, Open  ]],
Cell[5520, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

